<?php
if(file_exists(DOXCX_FRAME_PATH . "/fun/aliyun-dysms/sendSms.php")){
	require_once DOXCX_FRAME_PATH . "/fun/aliyun-dysms/sendSms.php";
}

/**
 * 添加星号
 * @param string $str 目标字符串
 * @param int $l 左侧留存长度
 * @param int $r 右侧留存长度
 * @param int $chr_len 星号数目
 * @param string $chr 星号或者其他自定义的字符
 * @return mixed 返回
 */
function gr_asterisk($str = '',$l = 3,$r = 3,$chr_len = null,$chr = '*'){
    if(empty($str)){
        return false;
    }
    $len_min = $l + $r;
    if(!$chr_len)$chr_len=mb_strlen($str,'utf-8')-$len_min;
    if(mb_strlen($str,'utf-8') <= $len_min){
        return str_repeat($chr,$chr_len);
    }

    $new_str = mb_substr($str,0,$l,'utf-8') . str_repeat($chr,$chr_len) . mb_substr($str,mb_strlen($str,'utf-8') - $r,$r);
    return $new_str;
}
/**
 * Created by daniel@liaodongting.com.
 * User: Daniel
 * Date: 2019/6/5
 * Time: 17:14
 */
if(!function_exists('array_column')){
    /**
     * array_column() // 不支持低版本;
     * 以下方法兼容PHP低版本
     */
    function array_column(array $array, $column_key, $index_key=null){
        $result = [];
        foreach($array as $arr) {
            if(!is_array($arr)) continue;

            if(is_null($column_key)){
                $value = $arr;
            }else{
                $value = $arr[$column_key];
            }

            if(!is_null($index_key)){
                $key = $arr[$index_key];
                $result[$key] = $value;
            }else{
                $result[] = $value;
            }
        }
        return $result;
    }
}
/**
 * 统一的短信发送
 * @param $uid int user表的id
 * @param $tel string 手机号
 * @param $content  string 短信内容
 * @param $identification  string 系统功能标识
 * @param $templateParam  array 阿里短信模板参数
 * @return bool
 */
function unified_send_sms($uid, $tel, $content,$identification,$templateParam) {
    if (!$uid) {
        return false;
    }
    $user = (new Model('user'))->where(['id' => $uid])->find();
   if ($user->agid) {
        $agency = (new Model('user_agency'))->find(['id' => $user->agid]);
    } else {
        $agency = (new Model('user_agency'))->find(['isadmin' => 1]);
    }
    if ($user->surplus_sms <= 0) {
        return false;
    }
	if($agency->message_td==2){//阿里云
		$alsms = new Model('user_agency_sms');
		$alsms->find(["uid"=>$agency->id]);
		$accessKeyId = $alsms->accessKeyId;
		$accessKeySecret = $alsms->accessKeySecret;
		$PhoneNumbers = $tel;
		$SignName = $alsms->signName;
		$tpls = json_decode($alsms->templateCodes,true);
		$TemplateCode = $tpls[$identification];
		foreach ($templateParam as $tIndex=>$tValue){
            if(mb_strlen($tValue) > 20){
                $tValue=gr_asterisk($tValue,8,9,3,"*");
                $templateParam[$tIndex]=$tValue;
            }
        }
		$TemplateParam = $templateParam;
		$resp = sendAlSms($accessKeyId,$accessKeySecret,$PhoneNumbers,$SignName,$TemplateCode,$TemplateParam);
		$raw_content = $content;
		$return = $resp->Code;
		if ($resp->Code=='OK') {
			$status=1;
		} else {
			$status=0;
		}
	}else{
		$message_sign = $agency->message_sign;
		$raw_content = $content = $content . "【" . $message_sign . "】";
		$message_id = $agency->message_id;
		$message_pwd = $agency->message_pwd;
		$url = "http://service.winic.org:8009/sys_port/gateway/index.asp?";
		$data = "id=%s&pwd=%s&to=%s&Content=%s&time=";
		$id = urlencode(iconv("utf-8", "gb2312", "$message_id"));
		$pwd = $message_pwd;
		$to = $tel;
		$content = urlencode(iconv("UTF-8", "GB2312", $content));
		$rdata = sprintf($data, $id, $pwd, $to, $content);
		// 发送短信
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $rdata);
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		$result = curl_exec($ch);
		curl_close($ch);
		$return = substr($result, 0, 3);
		if ($return == '000') {
			$status=1;
		} else {
			$status=0;
		}
	}
	// 剩余次数-1
	$user->surplus_sms = $user->surplus_sms - 1;
	$user->save();
	// 创建发送记录
	$rec = new Model('sms_send_record');
	$rec->uid = $uid;
	$rec->tel = $tel;
	$rec->content = $raw_content;
	$rec->ctime = time();
	$rec->return_code = $return;
	if ($status == 1) {
		// 发送成功
		$rec->status = 1;
		$rec->save();
		return true;
	} else {
		// 发送失败
		$rec->status = 0;
		$rec->save();
		return false;
	}
}
/*
 * 获取快递公司编码
 */
function getLogisticsEnName($cnName){
    $cnName=strstr($cnName,"快递",true);
    switch($cnName){
        case 'EMS':
            $type = 'ems';
            break;
        case '申通':
            $type = 'shentong';
            break;
        case '顺丰':
            $type = 'shunfeng';
            break;
        case '圆通':
            $type = 'yuantong';
            break;
        case '韵达':
            $type = 'yunda';
            break;
        case '中通':
            $type = 'zhongtong';
            break;
        case '汇通':
            $type = 'huitongkuaidi';
            break;
        case '天天':
            $type = 'tiantian';
            break;
        case '宅急':
            $type = 'zhaijisong';
            break;
        case '安捷':
            $type = 'anjiekuaidi';
            break;
        case '全峰':
            $type = 'quanfengkuaidi';
            break;
        case '中铁':
            $type = 'zhongtiewuliu';
            break;
    }
    return $type;
}
