<?php
/**
 * Created by PhpStorm.
 * User: Jeffrey
 * Date: 2017/12/11
 * Time: 12:25
 */

//
use Illuminate\Database\Eloquent\Model as Eloquent;
use Illuminate\Database\Capsule\Manager as Capsule;

$capsule = new Capsule();
$capsule->addConnection([
  'driver' => 'mysql',
  'host' => Conf::$db_host,
  'database' => Conf::$db_dbname,
  'username' => Conf::$db_username,
  'password' => Conf::$db_password,
  'charset' => 'utf8',
  'prefix' => '',
]);
$capsule->setAsGlobal();
$capsule->bootEloquent();

// 秒杀商品
class VshopProductSeckill extends Eloquent
{
  public $timestamps = false;
  protected $table = 'vshop_product_seckill';
}

// 秒杀商品订单
class VshopProductSeckillOrder extends Eloquent
{
  public $timestamps = false;
  protected $table = 'vshop_product_seckill_order';

  public function product()
  {
    return $this->belongsTo('VshopProductSeckill', 'product_id', 'id');
  }
}

// ComponentVerifyTicket
class ComponentVerifyTicket extends Eloquent
{
  public $timestamps = false;
  protected $table = 'component_verify_ticket';
}

// user_agency
class UserAgency extends Eloquent
{
  public $timestamps = false;
  protected $table = 'user_agency';
}

//component_access_token
class ComponentAccessToken extends Eloquent
{
  public $timestamps = false;
  protected $table = 'component_access_token';
}

//Pubs表
class Pubs extends Eloquent
{
  public $timestamps = false;
  protected $table = 'pubs';

  public function user()
  {
    return $this->belongsTo('User', 'uid', 'id');
  }

  public function wxTesters()
  {
    return $this->hasMany('WxTester', 'wid', 'id');
  }
}

//User表
class User extends Eloquent
{
  public $timestamps = false;
  protected $table = 'user';
}

//小程序体验者表
class WxTester extends Eloquent
{
  public $timestamps = false;
  protected $table = 'wx_tester';
}

//商城商品模型
class VshopProduct extends Eloquent
{
  public $timestamps = false;
  protected $table = 'vshop_product';

  // 和评论的关联方法
  public function vshop_evaluations()
  {
    return $this->hasMany('VshopEvaluation', 'product_id', 'id');
  }
}


//商城订单模型
class VshopOrder extends Eloquent
{
  public $timestamps = false;
  protected $table = 'vshop_order';

  // 和评论的关联方法
  public function vshop_evaluations()
  {
    return $this->hasMany('VshopEvaluation', 'order_id', 'id');
  }
}

//商城评价模型
class VshopEvaluation extends Eloquent
{
  public $timestamps = false;
  protected $table = 'vshop_evaluation';
  protected $with=['wechat_group_list'];
  protected $guarded=[];

  public function vshop_order()
  {
    return $this->belongsTo('VshopOrder', 'order_id', 'id');
  }

  public function vshop_product()
  {
    return $this->belongsTo('VshopProduct', 'order_id', 'id');
  }

  public function wechat_group_list()
  {
    return $this->belongsTo('WechatGroupList','openid','openid');
  }
}

class WechatGroupList extends  Eloquent{
  public $timestamps=false;
  protected $table='wechat_group_list';
}
class UserUploadCodeRecord extends Eloquent{
    public $timestamps=false;
    protected $table='user_upload_code_record';
    protected $guarded=[];
}
class UserRechargeRecord extends Eloquent{
  public $timestamps=false;
  protected $table='user_recharge_record';
  protected $guarded=[];
}