<?php
/**
 * Created by daniel@liaodongting.com.
 * User: Daniel
 * Date: 2019/6/6
 * Time: 9:46
 */

namespace Services\Wechat;


use Exception;
use HttpCurl;
use Lib\Hook;
use Services\Service;

class Template
{
    public $wid=null;
    public $form_id=null;
    public $type=null;
    public function __construct($wid,$form_id)
    {
        $this->wid=$wid;
        $this->form_id=$form_id;
    }

    /**
     * 模版发送
     * @param $type
     * @param $openid
     * @param array $data
     * @param string $page
     * @return array
     */
    public function send($type,$openid,array $data,$page='/pages/index/index'){
        $params=[
            'wid'=>$this->wid,
            'form_id'=>$this->form_id,
            'openid'=>$openid,
            'type'=>$type,
            'data'=>$data,
            'page'=>$page
        ];
        $send_re=Hook::listen('wechat_template_send',$params,[],true);
        if(!$send_re){
            return error('模版消息插件未找到');
        }elseif ($send_re['status']==='success'){
            return success($send_re['msg'],$send_re['data']);
        }else{
            return error($send_re['msg'],$send_re['data']);
        }

    }
}