<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2019/4/19
 * Time: 18:40
 */

namespace Services;



class Service
{
    /**
     * 错误的信息载体
     *
     * @access protected
     */
    protected $errorMsg;
    protected $errorCode;
    protected static $_instance=array();

    /**
     * 取回错误的信息
     *
     * @access public
     */
    public function getErrorMessage()
    {
        return $this->errorMsg;
    }
    public function getErrorCode(){
        return $this->errorCode;
    }
    public function setErrorCode($errorCode){
        $this->errorCode = $errorCode;
        return false;

    }
    /**
     * 设置错误的信息
     *
     * @param string $errorMsg 错误的信息
     */
    public function setErrorMessage($errorMsg)
    {
        $this->errorMsg = $errorMsg;
        return false;
    }

    /**
     * 返回错误数据
     * @param $errorMsg
     * @param null $data
     * @param array $extension
     * @return array
     */
    public  function error($errorMsg,$data=null,$extension = []){

        $this->setErrorMessage($errorMsg);
        $res = [
            'status' => 'error',
            'msg' => $errorMsg,
            'data' => $data,
        ];
        foreach ($extension as $k => $ext) {
            $res[$k] = $ext;
        }
        return $res;
    }

    /**
     * 返回正确数据
     * @param $successMsg
     * @param null $data
     * @param array $extension
     * @return array
     */
    public function success($successMsg,$data=null,$extension = []){
        $res = [
            'status' => 'success',
            'msg' => $successMsg,
            'data' => $data,
        ];
        foreach ($extension as $k => $ext) {
            $res[$k] = $ext;
        }
        return $res;
    }


    /**
     * 单粒调用服务类
     * @return static
     */
    public static function getInstance()
    {
        $class=get_called_class();
        if(empty(self::$_instance[$class])||!self::$_instance[$class] instanceof self)
        {
            self::$_instance[$class] = new static();
        }
        return self::$_instance[$class];

    }
}