<?php
/**
 * Created by daniel@liaodongting.com.
 * User: Daniel
 * Date: 2019/7/10
 * Time: 11:36
 */

namespace Services\Library;


use HttpCurl;
use LDB;

class PluginsInfo extends PluginsBase
{
    public function  getUpdateInfo(array $params){

        $plugin_code = $params['plugin_code'];
        $market_info = LDB::table('plugins_market_config')->first();
        if (!$market_info) return $this->error('您还没有绑定应用市场，请先进行绑定后再操作');
        $exits_info = LDB::table('plugins')->where(['plugin_code' => $plugin_code])->first();
        if (!$exits_info) return $this->error('本地插件信息不存在');
        $data = [
            'plugin_code' => $plugin_code,
            'time' => time(),
            'current_version' => $exits_info['version'],
            'app_key' => $market_info['app_key']
        ];
        $token = $market_info['app_secret'];
        $sign = up_make_sign($data, $token);
        $data['sign'] = $sign;
        $result = HttpCurl::post($this->update_host . '/?r=api/plugins/plugin-info', $data);

        $re = json_decode($result, true);

        if (!$re) {
            if (is_string($result) && !empty($result)) {
                return $this->error("请求出现错误：" . $result);
            }
            return $this->error('请求出现错误');
        } elseif ($re['status'] !== 'success') {

            return $this->error("更新服务器返回错误信息：" . ($re['message'] ? $re['message'] : $re['msg']), $re);
        } else {
            $data = $re['data'];
            return $this->success('success', $data);
        }
    }
}