<?php
/**
 * Created by daniel@liaodongting.com.
 * User: Daniel
 * Date: 2019/7/10
 * Time: 11:34
 */

namespace Services\Library;


use Services\Service;

class PluginsBase extends Service
{
    public $update_host = "https://addon.doxcx.cn";#升级网站地址

    public function __construct()
    {
        if(!empty(\Conf::$update_host)){
            $this->update_host=trim(\Conf::$update_host,'/');
        }
        $this->init();
    }
    public function init(){

    }
    /**
     * 执行sql 保证sql执行完
     * @param $content
     * @return array
     * @throws \Exception
     */
    public function updateRunSql($content)
    {
        // error_reporting(0);
        //遍历执行sql语句
        //去除空行和注释
        $content=removeBom($content);//自动去除bom头
        $content = preg_replace("/[\/\*][\s\S\r\n]*[\*\/]/", '', $content);
        $content = preg_replace("/[--]+(.+)(\r\n)+/", '', $content);
        $sqlArr = preg_split("/;[\r\n]*/", $content);
        $error_message = '';
        foreach ($sqlArr as $v) {
            $v = str_replace( "\r\n",' ',$v);
            if (empty($v)) continue;
            try {
                db_query($v);
            } catch (\Exception $e) {
                $error_message .= $e->getMessage() . ' ';
            }
        }
        if ($error_message) {
            return $this->error('sql执行过程出现错误:' . $error_message);
        } else {
            return $this->success('执行成功');
        }
    }

    function  post($url, $keysArr, $flag = 0){
        $ch = curl_init();
        $user_agent = "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.2; .NET CLR 1.1.4322)";
        if(! $flag) curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt ( $ch, CURLOPT_USERAGENT, $user_agent); // 模拟用户使用的浏览器
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_POST, TRUE);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $keysArr);
        curl_setopt($ch, CURLOPT_URL, $url);
        $ret = curl_exec($ch);

        curl_close($ch);
        return $ret;
    }
}