<?php
/**
 * Created by daniel
 * User: Daniel
 * Date: 2019/7/31
 * Time: 12:38
 */

namespace Models;


use Conf;
use Page;
use Request;

class BaseModel extends  \Model
{
    /**
     * 构造函数
     * @param string $tablename 表名
     * @param string $postid 表单提交的区分ID
     */
    function __construct($tablename,$postid=''){
        if(get_class($this) == 'Models\\BaseModel'){
            $this->DOXCXSYS_isorgin = true;
        }else{
            $this->DOXCXSYS_isorgin = false;
        }
        $this->DOXCXSYS_postid = $postid;
        $this->DOXCXSYS_post_id = strlen($postid)===32 ? $postid : md5('DOXCX_'.$postid);
        $this->DOXCXSYS_db = \DB::get_db();
        $this->DOXCXSYS_tablename = $tablename;
        $this->DOXCXSYS_real_tablename = Conf::$db_tablePrefix.$tablename;
        //填充一些有默认值的字段和字段描述
        if(!isset(self::$DOXCXSYS_FIELD_LABLE[$this->DOXCXSYS_tablename])){
            self::$DOXCXSYS_FIELD_LABLE[$this->DOXCXSYS_tablename] = array();
            self::$DOXCXSYS_FIELD_DATA[$this->DOXCXSYS_tablename] = array();
            self::$DOXCXSYS_FIELD_TYPE[$this->DOXCXSYS_tablename] = array();
            self::$DOXCXSYS_FIELD_DEFAULT[$this->DOXCXSYS_tablename] = array();
            self::$DOXCXSYS_FIELD_CANNULL[$this->DOXCXSYS_tablename] = array();
            $defaults = $this->DOXCXSYS_db->get_fields_array($this->DOXCXSYS_real_tablename);
            foreach ($defaults as $default){
                if(trim($default['Default'])!=''){
                    //存储默认值
                    self::$DOXCXSYS_FIELD_DEFAULT[$this->DOXCXSYS_tablename][$default['Field']] = $default['Default'];
                }
                if(trim($default['Null'])=='NO'){
                    //是否允许非空
                    self::$DOXCXSYS_FIELD_CANNULL[$this->DOXCXSYS_tablename][$default['Field']] = false;
                }else{
                    self::$DOXCXSYS_FIELD_CANNULL[$this->DOXCXSYS_tablename][$default['Field']] = true;
                }
                if(strpos($default['Type'], 'enum')===0){
                    self::$DOXCXSYS_FIELD_TYPE[$this->DOXCXSYS_tablename][$default['Field']] = 'enum';
                    //存储枚举类型的数据
                    $dataarray = array();
                    $tempstr = substr($default['Type'], 6,strlen($default['Type'])-8);
                    $arr1 = explode("','", $tempstr);
                    $arr2 = explode(",", $default['Comment']);
                    if(count($arr1)===count($arr2)){
                        $temparr2 = explode(':', $arr2[0]);
                        if(count($temparr2)>1){
                            //存储该字段的lable
                            self::$DOXCXSYS_FIELD_LABLE[$this->DOXCXSYS_tablename][$default['Field']] = $temparr2[0];
                        }
                        $arr2[0] = $temparr2[count($temparr2)-1];
                        foreach ($arr1 as $k=>$v){
                            $dataarray[$v] = $arr2[$k];
                        }
                    }else{
                        foreach ($arr1 as $v){
                            $dataarray[$v] = $v;
                        }
                        //存储该字段的lable
                        self::$DOXCXSYS_FIELD_LABLE[$this->DOXCXSYS_tablename][$default['Field']] = $default['Comment'];
                    }
                    //存储该字段的候选数据
                    self::$DOXCXSYS_FIELD_DATA[$this->DOXCXSYS_tablename][$default['Field']] = $dataarray;
                }else{
                    //存储该字段的lable
                    self::$DOXCXSYS_FIELD_TYPE[$this->DOXCXSYS_tablename][$default['Field']] = $default['Type'];
                    self::$DOXCXSYS_FIELD_LABLE[$this->DOXCXSYS_tablename][$default['Field']] = $default['Comment'];
                }
            }
        }
        //该表Model数据已经初始化过 给各个字段赋初始值
        $defaults = &self::$DOXCXSYS_FIELD_DEFAULT[$this->DOXCXSYS_tablename];
        foreach ($defaults as $field=>$default){
            $this->$field = $default;
        }
        //如果不是原始模型 增加各个字段的验证信息供页面form标签使用
        if(!$this->DOXCXSYS_isorgin&&!isset(self::$DOXCXSYS_FIELD_FORMVAL[$this->DOXCXSYS_tablename])){
            self::$DOXCXSYS_FIELD_FORMVAL[$this->DOXCXSYS_tablename] = array();
            self::$DOXCXSYS_first_valset[$this->DOXCXSYS_tablename] = true;
            $this->validate();
            self::$DOXCXSYS_first_valset[$this->DOXCXSYS_tablename] = false;
        }
        //默认的field字段写入
        $fields = $this->DOXCXSYS_db->list_fields($this->DOXCXSYS_real_tablename);
        $this->DOXCXSYS_select = '`'.implode('`,`', $fields).'`';
    }
    /**
     * 试探行的填充这个model
     * 如果能填充则采用post填充并返回：true否则返回：false
     *
     * @return boolean
     */
    public function try_post_api(){
        $request=\Lib\Request::instance();
        if($request->isPost()){
            $this->load_from_post_api();
            return true;
        }
        return false;
    }
    /**
     * 根据post请求内容填充这个Model<br/>
     * 这是表单字段自动提交的最常用方法
     *
     * @return Model 模型本身
     */
    public function load_from_post_api(){
        // 先进行解码
        $newpost = array();
        $request=\Lib\Request::instance();
        $post=$request->post();
        if(Page::$tk_str != null){
            foreach ($post as $k=>$v){
                $newpost[\strings::decryption($k,Page::$tk_str )] = $v;
            }
        }else{
            $newpost = $request->post();
        }
        Page::$tk_str = null;
        $fields=$this->DOXCXSYS_db->list_fields($this->DOXCXSYS_real_tablename);
        if($fields)$fields=array_flip($fields);
        if(!empty($newpost['id'])&&isset($this->DOXCXSYS_db)){
            $this->find($newpost['id']);
        }

        if(get_magic_quotes_gpc()){
            foreach ($newpost as $k=>$v){
                if(!key_exists($k,$fields))continue;
                    $field =$k;
                    if(is_array($v)){
                        $v = ','.implode(',', $v).',';
                    }
                    $this->$field = stripslashes($v);
            }
        }else{
            foreach ($newpost as $k=>$v){
                if(!key_exists($k,$fields))continue;
                    $field = $k;
                    if(is_array($v)){
                        $v = ','.implode(',', $v).',';
                    }
                    $this->$field = $v;
            }
        }
        //填充实体
        if(!$this->DOXCXSYS_isorgin){
            $this->fill_entity_field();
        }
        return $this;
    }
    /**
     * 试探行的填充这个model
     * 如果能填充则采用post填充并返回：true否则返回：false
     *
     * @return boolean
     */
    public function try_get_api(){
        if(Request::get()){
            $this->load_from_get_api();
            return true;
        }
        return false;
    }
    /**
     * 根据get请求内容填充这个Model<br/>
     * 这个方法通常用在信息检索页面的批量属性提交<br/>
     * 切不可用此方法得来的数据进行CUD操作！
     *
     * @return Model 模型本身
     */
    public function load_from_get_api(){
        $fields=$this->DOXCXSYS_db->list_fields($this->DOXCXSYS_real_tablename);
        if($fields)$fields=array_flip($fields);
        $request=\Lib\Request::instance();
        $get=$request->get();
        if(!empty($get['id'])&&isset($this->DOXCXSYS_db)){
            $this->find($get['id']);
        }
        foreach ($get as $k=>$v){
            if(!key_exists($k,$fields))continue;
                $field = $k;
                $this->$field = $v;
        }
        //填充实体
        if(!$this->DOXCXSYS_isorgin){
            $this->fill_entity_field();
        }
        return $this;
    }
    /**
     * 根据get请求内容填充这个Model并返回实际GET提交的数组<br/>
     * 这个方法通常用在信息检索页面的批量属性提交<br/>
     * 切不可用此方法得来的数据进行CUD操作！
     *
     * @return array 提交的数据
     */
    public function load_array_from_post_api(){
        $request=\Lib\Request::instance();
        $fields=$this->DOXCXSYS_db->list_fields($this->DOXCXSYS_real_tablename);
        if($fields)$fields=array_flip($fields);
        $post=$request->post();
        if(!empty($post['id'])&&isset($this->DOXCXSYS_db)){
            $this->find($post['id']);
        }
        $bakarr = array();
        foreach ($post as $k=>$v){
            if(!key_exists($k,$fields))continue;
                $field = $k;
                $this->$field = $v;
                if(trim($v)!='' && strpos($field, 'SEL_TXT_')!==0){
                    $bakarr[$field] = $v;
                }
        }
        //填充实体
        if(!$this->DOXCXSYS_isorgin){
            $this->fill_entity_field();
        }
        return $bakarr;
    }

    /**
     * @param $data
     * @return \Model
     */
    public function load_data($data){
        $fields=$this->DOXCXSYS_db->list_fields($this->DOXCXSYS_real_tablename);
        if($fields)$fields=array_flip($fields);
        if(!empty($data['id'])){
            unset($data['id']);
        }
        foreach ($data as $k=>$v){
            if(!key_exists($k,$fields))continue;
            $field = $k;
            $this->$field = $v;
        }
        //填充实体
        if(!$this->DOXCXSYS_isorgin){
            $this->fill_entity_field();
        }
        return $this;
    }

}