<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2019/5/17
 * Time: 13:12
 */
if (!function_exists('includeFile')) {
    function includeFile($file)
    {
        include $file;
    }
}

/**
 * 自定义返回成功JSON的方法
 * @param string $msg
 * @param null $data
 * @param array $exts
 * @return array
 */
function success($msg = 'OK', $data = null, $exts = [])
{
    $res = [
        'status' => 'success',
        'msg' => $msg,
        'data' => $data,
    ];
    foreach ($exts as $k => $ext) {
        $res[$k] = $ext;
    }
    return $res;
}

/**
 * 自定义返回失败JSON的方法
 * @param string $msg
 * @param null $data
 * @param array $exts
 * @return array
 */
function error($msg = 'OK', $data = null, $exts = [])
{
    $res = [
        'status' => 'error',
        'msg' => $msg,
        'data' => $data,
    ];
    foreach ($exts as $k => $ext) {
        $res[$k] = $ext;
    }
    return $res;
}

/**
 * 　　* 下划线转驼峰
 * 　　* 思路:
 * 　　* step1.原字符串转小写,原字符串中的分隔符用空格替换,在字符串开头加上分隔符 --修改为不转小写
 * 　　* step2.将字符串中每个单词的首字母转换为大写,再去空格,去字符串首部附加的分隔符.
 * 　　*/
function camelize($uncamelized_words, $separator = '_')
{
    $uncamelized_words = $separator . str_replace($separator, " ", $uncamelized_words);
    return ltrim(str_replace(" ", "", ucwords($uncamelized_words)), $separator);
}

/**
 * 驼峰命名转下划线命名
 * 思路:
 * 小写和大写紧挨一起的地方,加上分隔符,然后全部转小写
 */
function uncamelize($camelCaps,$separator='_')
{
    return strtolower(preg_replace('/([a-z])([A-Z])/', "$1" . $separator . "$2", $camelCaps));
}
 /**
* 浏览器友好的变量输出
* @access public
* @param  mixed       $var   变量
* @param  boolean     $echo  是否输出(默认为 true，为 false 则返回输出字符串)
* @param  string|null $label 标签(默认为空)
* @param  integer     $flags htmlspecialchars 的标志
* @return null|string
*/
 function dump($var, $echo = true, $label = null, $flags = ENT_SUBSTITUTE)
    {
        $label = (null === $label) ? '' : rtrim($label) . ':';

        ob_start();
        var_dump($var);
        $output = preg_replace('/\]\=\>\n(\s+)/m', '] => ', ob_get_clean());

        if ( PHP_SAPI == 'cli') {
            $output = PHP_EOL . $label . $output . PHP_EOL;
        } else {
            if (!extension_loaded('xdebug')) {
                $output = htmlspecialchars($output, $flags);
            }

            $output = '<pre>' . $label . $output . '</pre>';
        }

        if ($echo) {
            echo($output);
            return;
        }

        return $output;
    }

//插件初始化逻辑
\Lib\Hook::add('hook_init',function (){
    $tagList = glob(DOXCX_FRAME_PATH . 'Addons/*/tags.php');
    foreach ($tagList as $key => $tag) {
        \Lib\Hook::import(include_once($tag));
    }
});