<?php
namespace Addons\QyWechat\Services;

use Services\Service;
use Models\BaseModel as Model;
use Session;
use Addons\QyWechat\Helper;
use EasyWeChat\Factory;

class QyWechatApi extends Service
{	
	public function get_qy_app($corp_id,$secret){
		$config = [
			'corp_id' => $corp_id,
			'secret'   => $secret,

			// 指定 API 调用返回结果的类型：array(default)/collection/object/raw/自定义类名
			'response_type' => 'array',

			'log' => [
				'level' => 'debug',
				'file' => DOXCX_FRAME_PATH . 'log/wechat.log',
			],
		];
		$app = Factory::work($config);
		return $app;
	}
	
	public function get_qy_agent_app($corp_id,$agent_id,$secret){
		$config = [
			'corp_id' => $corp_id,
			'agent_id' => $agent_id,
			'secret'   => $secret,

			// 指定 API 调用返回结果的类型：array(default)/collection/object/raw/自定义类名
			'response_type' => 'array',

			'log' => [
				'level' => 'debug',
				'file' => DOXCX_FRAME_PATH . 'log/wechat.log',
			],
		];
		$app = Factory::work($config);
		return $app;
	}
	
	public function get_et_access_token($wid=''){
		$wid = $wid?$wid:Session::get('wid');
		$qyConfig = (new Model('qy_wechat_config'))->find(['wid'=>$wid]);
		$etApp = $this->get_qy_app($qyConfig->corp_id,$qyConfig->externalcontact_secret);
		// 获取 access token 实例
		$accessToken = $etApp->access_token;
		$token = $accessToken->getToken()['access_token']; // token 数组  token['access_token'] 字符串
		return $token;
	}
	
	//获取企业标签库
	public function get_corp_tag_list($tag_id = [],$wid=''){
		$token = $this->get_et_access_token($wid);
		$body = \HttpCurl::post("https://qyapi.weixin.qq.com/cgi-bin/externalcontact/get_corp_tag_list?access_token=" . $token,
			json_encode([
				"tag_id" => $tag_id
			])
		);
		$resp_arr = json_decode($body, 1);
		return $resp_arr;
	}
	
	//新增标签
	public function add_corp_tag($param){
		$token = $this->get_et_access_token();
		$body = \HttpCurl::post("https://qyapi.weixin.qq.com/cgi-bin/externalcontact/add_corp_tag?access_token=" . $token,
			json_encode([
				"group_id" => $param['group_id'],
				"group_name" => $param['group_name'],
				"tag" => $param['tag']
			])
		);
		$resp_arr = json_decode($body, 1);
		return $resp_arr;
	}
	
	//删除标签
	public function del_corp_tag($param){
		$token = $this->get_et_access_token();
		$body = \HttpCurl::post("https://qyapi.weixin.qq.com/cgi-bin/externalcontact/del_corp_tag?access_token=" . $token,
			json_encode([
				"tag_id" => $param['tag_id'],
				"group_id" => $param['group_id'],
			])
		);
		$resp_arr = json_decode($body, 1);
		return $resp_arr;
	}
	
	//编辑企业客户标签
	public function edit_corp_tag($param){
		$token = $this->get_et_access_token();
		$body = \HttpCurl::post("https://qyapi.weixin.qq.com/cgi-bin/externalcontact/edit_corp_tag?access_token=" . $token,
			json_encode([
				"id" => $param['id'],
				"name" => $param['name'],
				//"order" => $param['order']
			])
		);
		$resp_arr = json_decode($body, 1);
		return $resp_arr;
	}
	
	//编辑客户企业标签
	public function edit_et_tag($param,$wid=''){
		$token = $this->get_et_access_token($wid);
		$body = \HttpCurl::post("https://qyapi.weixin.qq.com/cgi-bin/externalcontact/mark_tag?access_token=" . $token,
			json_encode([
				"userid" => $param['userid'],
				"external_userid" => $param['external_userid'],
				"add_tag" => $param['add_tag'],
				"remove_tag" => $param['remove_tag']
			])
		);
		$resp_arr = json_decode($body, 1);
		return $resp_arr;
	}
	
	//获取群列表
	public function get_et_groupchat_list(){
		$token = $this->get_et_access_token();
		$body = \HttpCurl::post("https://qyapi.weixin.qq.com/cgi-bin/externalcontact/groupchat/list?access_token=" . $token,
			json_encode([
				"offset" => 0,
				"limit" => 1000,
			])
		);
		$resp_arr = json_decode($body, 1);
		return $resp_arr;
	}
	
	//获取群详情
	public function get_et_groupchat_info($chat_id,$wid=''){
		$token = $this->get_et_access_token($wid);
		$body = \HttpCurl::post("https://qyapi.weixin.qq.com/cgi-bin/externalcontact/groupchat/get?access_token=" . $token,
			json_encode([
				"chat_id" => $chat_id
			])
		);
		$resp_arr = json_decode($body, 1);
		return $resp_arr;
	}
	
	//获取客户群统计数据
	public function get_et_groupchat_statistic($begin_time = ''){
		if(!$begin_time){
			$begin_time = strtotime("-1 day");
		}
		$token = $this->get_et_access_token();
		$body = \HttpCurl::post("https://qyapi.weixin.qq.com/cgi-bin/externalcontact/groupchat/statistic?access_token=" . $token,
			json_encode([
				"day_begin_time" => $begin_time,
			])
		);
		$resp_arr = json_decode($body, 1);
		return $resp_arr;
	}
	
	//添加群欢迎语素材
	public function add_group_welcome_template($param = []){
		$token = $this->get_et_access_token();
		$body = \HttpCurl::post("https://qyapi.weixin.qq.com/cgi-bin/externalcontact/group_welcome_template/add?access_token=" . $token,
			json_encode($param)
		);
		$resp_arr = json_decode($body, 1);
		return $resp_arr;
	}
	
	//编辑群欢迎语素材
	public function edit_group_welcome_template($param = []){
		$token = $this->get_et_access_token();
		$body = \HttpCurl::post("https://qyapi.weixin.qq.com/cgi-bin/externalcontact/group_welcome_template/edit?access_token=" . $token,
			json_encode($param)
		);
		$resp_arr = json_decode($body, 1);
		return $resp_arr;
	}
	
	//删除群欢迎语素材
	public function del_group_welcome_template($template_id){
		$token = $this->get_et_access_token();
		$body = \HttpCurl::post("https://qyapi.weixin.qq.com/cgi-bin/externalcontact/group_welcome_template/del?access_token=" . $token,
			json_encode([
				'template_id'=>$template_id
			])
		);
		$resp_arr = json_decode($body, 1);
		return $resp_arr;
	}
	
	//修改客户备注信息
	public function edit_et_remark($param,$wid=''){
		$token = $this->get_et_access_token($wid);
		$body = \HttpCurl::post("https://qyapi.weixin.qq.com/cgi-bin/externalcontact/remark?access_token=" . $token,
			json_encode([
				"userid" => $param['userid'],
				"external_userid" => $param['external_userid'],
				"remark" => $param['remark']
			])
		);
		$resp_arr = json_decode($body, 1);
		return $resp_arr;
	}
}
