<?php
namespace Addons\QyWechat\Controller\H5;

use Models\BaseModel as Model;
use Session;
use Addons\CustomerPortrait\Helper;
use Addons\QyWechat\Services\QyWechatApi;
use Addons\QyWechat\Services\JsSdk;
use Addons\QyWechat\Helper as QyHelper;

class Portrait extends \BaseController
{	
	public function index(){
		$corp_id = \Request::get('corp_id');
		$agent_id = \Request::get('agent_id');
		$qyConfig = (new Model('qy_wechat_config'))->find(['corp_id'=>$corp_id]);
		$wid = $qyConfig->wid;
		$replyConfig = (new Model('qy_reply_config'))->find(['wid'=>$wid,'agent_id'=>$agent_id]);
		if($_GET['code']){
			$code = $_GET['code'];
			$app = QyWechatApi::getInstance()->get_qy_agent_app($corp_id,$replyConfig->agent_id,$replyConfig->secret);
			$accessToken = $app->access_token;
			$token = $accessToken->getToken()['access_token']; // token 数组  token['access_token'] 字符串
			$url = 'https://qyapi.weixin.qq.com/cgi-bin/user/getuserinfo?access_token='.$token.'&code='.$code;
			$resArr = json_decode(curlGet($url),1);
			$jsSdkServe = new JsSdk($corp_id,$agent_id,$replyConfig->secret);
			$wxConfig = $jsSdkServe->getSignPackage();
			$agentConfig = $jsSdkServe->getSignPackage('','agent');
			$this->assign("corp_id", $corp_id);
			$this->assign("agent_id", $agent_id);
			$this->assign("wxConfig", $wxConfig);		
			$this->assign("agentConfig", $agentConfig);		
			$this->assign("wid", $wid);		
			$this->assign("userId", $resArr['UserId']);		
			return $this->show();
		}else{
			$redirect_uri = urlencode(Helper::getInstance()->get_http_server_name().'/Addons/CustomerPortrait/H5/Portrait.html?corp_id='.$corp_id.'&agent_id='.$agent_id);
			$url = 'https://open.weixin.qq.com/connect/oauth2/authorize?appid='.$corp_id.'&redirect_uri='.$redirect_uri.'&response_type=code&scope=snsapi_base&state=STATE#wechat_redirect';
			echo "<script>window.location = '{$url}'</script>";
		}
	}
	
	public function customer_info(){
		$wid = \Request::get('wid');
		$qyConfig = (new Model('qy_wechat_config'))->find(['wid'=>$wid]);
		$sendConfig = (new Model('qy_message_send_config'))->find(['wid'=>$qyConfig->wid]);
		$jsSdkServe = new JsSdk($qyConfig->corp_id,$sendConfig->agent_id,$sendConfig->secret);
		$wxConfig = $jsSdkServe->getSignPackage();
		$agentConfig = $jsSdkServe->getSignPackage('','agent');
		$this->assign("corp_id", $qyConfig->corp_id);
		$this->assign("agent_id", $agent_id);		
		$this->assign("wxConfig", $wxConfig);			
		$etUserId = \Request::get('etUserId');
		$userId = \Request::get('userId');
		$et = (new Model('qy_externalcontact_list'))->find(['wid'=>$wid,'external_userid'=>$etUserId]);
		if(!$et->id){
			die('未知客户');
		}
		$follow_user = json_decode($et->follow_user,1);
		foreach($follow_user as $k=>$v){
			if($v['userid'] == $userId){
				$user = (new Model('qy_user_list'))->find(['wid'=>$wid,'userid'=>$v['userid']])->get_model_array();
				$v['user'] = $user;
				$userInfo = $v;
			}
		}
		$qyEtDynamic = (new Model('qy_et_dynamic'))->where(['wid'=>$wid,'external_userid'=>$et->external_userid])->order('ctime desc')->list_all_array();
		/**$etDynamic = [];
		foreach($qyEtDynamic as $qyetdynamic){
			$etDynamic[date('m_d',$qyetdynamic['ctime'])][] = $qyetdynamic;
		}*/
		$QyHelper = QyHelper::getInstance();
		$addWayArr = $QyHelper->add_way_arr();
		$this->assign("et", $et);
		$this->assign("userInfo", $userInfo);
		$this->assign("addWayArr", $addWayArr);
		$this->assign("etDynamic", $qyEtDynamic);
		$this->assign("h", $QyHelper);
		return $this->show();
	}
}