<?php
namespace Addons\QyWechat\Controller\Api\Providers;

use Models\BaseModel as Model;
use Addons\QyWechat\Services\ProvidersApi;
use Addons\QyWechat\Helper;
use EasyWeChat\Factory;
 
class ZlCallback extends \BaseController
{
	  public function  index(){
		  $ProvidersApi = ProvidersApi::getInstance();
		  $app = $ProvidersApi->get_provider_app();
		  $server = $app->server;
		  $server->push(function ($message) {
			  switch ($message['InfoType']) {
				  //推送suite_ticket
				  case 'suite_ticket':
					  break;
				  //授权成功通知
				  case 'create_auth':
					  break;
				  //变更授权通知
				  case 'cancel_auth':
					  break;
				  //通讯录事件通知
				  case 'change_contact':
					  switch ($message['ChangeType']){
						  case 'create_user':
							  return '新增成员事件';
							  break;
						  case 'update_user':
							  return '更新成员事件';
							  break;
						  case 'delete_user':
							  return '删除成员事件';
							  break;
						  case 'create_party':
							  return '新增部门事件';
							  break;
						  case 'update_party':
							  return '更新部门事件';
							  break;
						  case 'delete_party':
							  return '删除部门事件';
							  break;
						  case 'update_tag':
							  return '标签成员变更事件';
							  break;
					  }
					  break;
				  //外部联系人事件通知
				  case 'change_external_contact':
					  switch ($message['ChangeType']){
						  case 'add_external_contact':
							  return $this->add_external_contact($message);
							  break;
						  case 'edit_external_contact':
							  return $this->edit_external_contact($message);
							  break;
					  }
					  break;
				  default:
					  //return 'fail';
					  break;
			  }
		  });
		  $response = $server->serve();
		  $response->send();
	  }
	  
	  public function add_external_contact($arr){
	  	  //$this->import_et_data($arr);
	  }

	  public function edit_external_contact($arr){
	  	  //$this->import_et_data($arr);
	  }

	  public function import_et_data($arr){
	  	  $qyConfig = (new Model('qy_wechat_config'))->find(['corp_id'=>$arr['AuthCorpId']]);
		  $wid = $qyConfig->wid;
		  $ProvidersApi = ProvidersApi::getInstance();
		  $work = $ProvidersApi->get_work($arr['AuthCorpId']);

		  //获取客户详情 导入数据
		  $customer_info_res = $work->external_contact->get($arr['ExternalUserID']);
		  if($customer_info_res['errcode'] == 0){
		  		$qyUser = (new Model('qy_user_list'))->find(['wid'=>$qyConfig->wid,'userid'=>$arr['UserID']]);
				$customer_info = $customer_info_res;
				$qyCustomer = (new Model('qy_providers_externalcontact_list'))->find(['wid'=>$wid,'user_id'=>$qyUser->id,'external_userid'=>$customer_info['external_contact']['external_userid']]);
				$user = '';
				$tags = [];
				foreach($customer_info['follow_user'] as $followuser){
					if($qyUser->userid == $followuser['userid']){
						$user = $followuser;
						foreach($followuser['tags'] as $ftag){
							$tags[] = $ftag['tag_id'];
						}
					}
				}	

				$qyCustomer->wid = $wid;
				$qyCustomer->external_userid = $customer_info['external_contact']['external_userid'];
				$qyCustomer->name = Helper::getInstance()->filterEmoji($customer_info['external_contact']['name']);
				$qyCustomer->avatar = $customer_info['external_contact']['avatar'];
				$qyCustomer->type = $customer_info['external_contact']['type'];
				$qyCustomer->gender = $customer_info['external_contact']['gender'];
				$qyCustomer->unionid = $customer_info['external_contact']['unionid'];
				$qyCustomer->position = $customer_info['external_contact']['position'];
				$qyCustomer->corp_name = $customer_info['external_contact']['corp_name'];
				$qyCustomer->corp_full_name = $customer_info['external_contact']['corp_full_name'];
				$qyCustomer->external_profile = json_encode($customer_info['external_contact']['external_profile']);
				$qyCustomer->user_id = $qyUser->id;
				$qyCustomer->remark = $user['remark'];
				$qyCustomer->description = $user['description'];
				$qyCustomer->createtime = $user['createtime'];
				$qyCustomer->tags_info = json_encode($user['tags']);
				$qyCustomer->tags = json_encode($tags);
				$qyCustomer->remark_corp_name = $user['remark_corp_name'];
				$qyCustomer->remark_mobiles = $user['remark_mobiles'];
				$qyCustomer->add_way = $user['add_way'];
				$qyCustomer->oper_userid = $user['oper_userid'];
				$qyCustomer->state = $user['state'];
				$qyCustomer->status = 0;
				$qyCustomer->save();	
		  }
	  }

}
