<?php
/**
 * Created by PhpStorm.
 * User: Alvin
 * Date: 2020/9/13
 * Time: 22:01
 */
namespace Addons\QyWechat\Controller\Admin;

use Models\BaseModel as Model;
use Session;
use Addons\QyWechat\Helper;
use Addons\QyWechat\Services\QyWechatApi;

class MarketingTools extends \BaseController
{
    /**
     * 2020-08-21
     * 客户群群发
     */
    public function group_send_manage(){
        $wid = Session::get('wid');
        $groupMsgTask = new Model('qy_et_group_msg_task');

        //name 模糊查询
        $name = $_GET['name'];
        if(trim($name)!=''){
            $where['name@~'] = $name;
        }
        $where['wid'] = $wid;
        $p = new \Pagination();
        $res = $p->model_list($groupMsgTask->where($where)->order('id desc'));
        foreach($res as $k=>$v){
            if($v->other_type == 1){
                $sendType = '文本';
            }elseif($v->other_type == 2){
                $sendType = '图片';
            }elseif($v->other_type == 3){
                $sendType = '图文';
            }elseif($v->other_type == 4){
                $sendType = '小程序';
            }
            $res[$k]->sendType = $sendType;
            //查询群主名字
            $ownerIds = json_decode($res[$k]->owner,true);//返回数组
            $qyUser = new Model('qy_user_list');
            $where['id'] = $ownerIds;
            $owners =  $qyUser->where($where)->order('id')->list_all_array();
            $res[$k]->owners = $owners;
            //根据状态查询任务详情  只有发送完成的才去查询
            if($res[$k]->status == 1){
                $taskDetail = new Model("qy_et_group_msg_detail");
                $detailWhere["gtid"] = $res[$k]->id;
                //任务详情 会有多条
                $details = $taskDetail->where($detailWhere)->list_all_array();
                foreach($details as $dk=>$dv){
                    foreach ($owners as $s){
                        if($s['id']  == $details[$dk]['owner'] ){
                            $details[$dk]['owenerName'] = $s['name'];
                            break;
                        }
                    }
                }
                $res[$k]->details = $details;
            }
        }
        $this->assign("P", $p);
        //$this->assign("P", $GLOBALS['P']);
        $this->assign("res", $res);
        $this->assign("name", $name);

        return $this->show();
    }

    /**
     * 2020-08-21
     * 创建客户群群发任务
     */
    public function add_group_msg_task(){
        $wid = Session::get('wid');
        $QyWechatApi = QyWechatApi::getInstance();
        $qyConfig = (new Model('qy_wechat_config'))->find(['wid'=>$wid]);
        $etApp = $QyWechatApi->get_qy_app($qyConfig->corp_id,$qyConfig->externalcontact_secret);
        if(is_post()){
            setApi();
            $groupMsgTask = new Model('qy_et_group_msg_task');
            $groupMsgTask->wid = $wid;
            $groupMsgTask->name = $_POST['name'];
            $groupMsgTask->owner = json_encode(explode(",",$_POST['checkUser']),320);
            $groupMsgTask->send_mode = $_POST['selectTime'];
            $groupMsgTask->timing_time = $_POST['timing_time'];
            $groupMsgTask->text_content = $_POST['text_content'];
            $groupMsgTask->other_type = $_POST['shareType'];
            $groupMsgTask->image_url = $_POST['image'];
            $groupMsgTask->link_title = $_POST['link_title'];
            $groupMsgTask->link_picurl = $_POST['link_pic'];
            $groupMsgTask->link_desc = $_POST['link_desc'];
            $groupMsgTask->link_url = $_POST['link_url'];
            $groupMsgTask->miniprogram_name = $_POST['miniprogram_name'];
            $groupMsgTask->miniprogram_appid = $_POST['miniprogram_appid'];
            $groupMsgTask->miniprogram_page = $_POST['miniprogram_page'];
            $groupMsgTask->miniprogram_title = $_POST['miniprogram_title'];
            $groupMsgTask->miniprogram_picurl = $_POST['miniprogram_pic'];
            $groupMsgTask->status = 3; //默认待发送
            $groupMsgTask->ctime = date('Y-m-d H:i:s');
            if($groupMsgTask->save()) {
                if($groupMsgTask->send_mode == 1){
                    //如果是立即发送 ，先改变成发送中
                    $groupMsgTask->status = 0;
                    $groupMsgTask->save();
                    //开始发送
                    //1.因为会有多个群主，循环创建群发任务
                    $userWhere['id'] = explode(",",$_POST['checkUser']);
                    $qyUser = new Model('qy_user_list');
                    $owners =  $qyUser->where($userWhere)->list_all();
                    foreach ($owners as $u){
                        //给每一个群主创建群发任务

                        $msg = [];
                        $msg['chat_type'] = 'group';
                        $msg['sender'] = $u->userid;
                        $msg['text'] = ['content'=>$groupMsgTask->text_content];
                        if($groupMsgTask->other_type == 2){//图片
                            //$image_url_arr = explode("/", $msgTemplate->image_url);
                            //$image_media_id = $etApp->media->uploadImage("./tmpImg/{$image_url_arr[count($image_url_arr)-1]}")["media_id"];
                            $msg['image'] = ['media_id'=>$etApp->media->uploadImage($groupMsgTask->image_url)['media_id']];
                        }elseif($groupMsgTask->other_type == 3){//图文
                            $msg['link'] = [
                                'title'=>$groupMsgTask->link_title,
                                'picurl'=>$groupMsgTask->link_picurl,
                                'desc'=>$groupMsgTask->link_desc,
                                'url'=>$groupMsgTask->link_url
                            ];
                        }elseif($groupMsgTask->other_type == 4){//小程序
                            //$miniprogram_pic_arr = explode("/", $msgTemplate->miniprogram_picurl);
                            //$miniprogram_pic_media_id = $etApp->media->uploadImage("./tmpImg/{$miniprogram_pic_arr[count($miniprogram_pic_arr)-1]}")["media_id"];
                            $msg['miniprogram'] = [
                                'title'=>$groupMsgTask->miniprogram_title,
                                'pic_media_id'=>$etApp->media->uploadImage($groupMsgTask->miniprogram_picurl)['media_id'],
                                'appid'=>$groupMsgTask->miniprogram_appid,
                                'page'=>$groupMsgTask->miniprogram_page
                            ];
                        }
                        $messageRes = $etApp->external_contact_message->submit($msg);
                        //测试方便 假数据
                        //$messageRes['errcode'] = 1;
                        if($messageRes['errcode'] == 0){
                            $groupMsgTask->status = 1;
                            $groupMsgTask->save();
                            if($messageRes['msgid']){
                                $taskDetail =  new Model('qy_et_group_msg_detail');
                                $taskDetail->wid = $wid;
                                $taskDetail->gtid = $groupMsgTask->id;
                                $taskDetail->owner = $u->id;
                                $taskDetail->msgid = $messageRes['msgid'];
                                $taskDetail->result = '';
                                $taskDetail->ctime = date('Y-m-d H:i:s');
                                $taskDetail->save();
                            }
                        }else{
                            $groupMsgTask->status = 2;
                            $groupMsgTask->save();
                        }
                    }
                }
                sendSuccess('操作成功');
            }else{
                sendError('操作失败');
            }
        }
        return $this->show();
    }

    public function select_group_owner(){
        $wid = Session::get('wid');

        //(new Model('qy_et_groupchat'))->where(['wid'=>$wid])
        //框架model没有GROUP by方法 故用 原生DB
        $db = \DB::get_db();
        $res = $db->query("select * from qvmh_qy_et_groupchat where wid = ? group by `user_id`",array($wid));
        $ids = array();
        foreach ($res as $r){
            $ids[]=$r['user_id'];
        }
        $userList = (new Model('qy_user_list'))->where(['id'=>$ids,"wid"=>$wid])->list_all_array();
        $this->assign("userList", $userList);
        $this->assign("count", count($userList));
        return $this->show();
    }

    /**
     * 删除客户群群发任务  只限 待发送的
     */
    public function del_group_task(){
        setApi();
        $wid = Session::get('wid');
        $id = $_POST['gid'];
        $groupMsgTask = new Model('qy_et_group_msg_task');
        $task = $groupMsgTask->find($id);
        if($task->status == 3){
            $task->remove();
            sendSuccess('操作成功');
        }else{
            sendError("操作失败");
        }

    }

    /**
     * 更新本条数据 从微信那获取
     */
    public function ref_task_info(){
        setApi();
        $wid = Session::get('wid');
        $QyWechatApi = QyWechatApi::getInstance();
        $qyConfig = (new Model('qy_wechat_config'))->find(['wid'=>$wid]);
        $etApp = $QyWechatApi->get_qy_app($qyConfig->corp_id,$qyConfig->externalcontact_secret);

        $id = $_POST['gid'];
        $groupMsgTask = new Model('qy_et_group_msg_task');
        $task = $groupMsgTask->find($id);
        //不等于0 代表查询到数据  查询出下面task 详情
        if($task->id != 0 ){
            $taskDetail =  new Model('qy_et_group_msg_detail');
            $where['wid'] = $wid;
            $where['gtid'] = $id;
            $list = $taskDetail->where($where)->list_all();
            foreach ($list as $detail){
                $result = $etApp->external_contact_message->get($detail->msgid);
                $success = 0; //发送成功数目
                $fail = 0 ; //发送失败数目
                if($result['errcode'] == 0){
                    $detail_list = $result['detail_list'];
                    foreach ($detail_list as $d){
						$d = json_decode(json_encode($d));
                        if($d->status == 1 ){
                            $success ++;
                        }else{
                            $fail ++;
                        }
                    }
                    $detail->success_num = $success;
                    $detail->fail_num = $fail;
                    $detail->result = json_encode($detail_list,320);
                    $detail->update_time = date('Y-m-d H:i:s');
                    $detail->save();
                }
            }
        }
        sendSuccess('操作成功');
    }

    /**
     * 2020-08-26
     * 标签建群
     */
    public function tag_group_list(){
        $wid = Session::get('wid');
        //name 模糊查询
        $name = $_GET['name'];
        if(trim($name)!=''){
            $where['name@~'] = $name;
        }
        $where['wid'] = $wid;
        $tagGroup = new Model('qy_et_tag_group');
        $p = new \Pagination();
        $res = $p->model_list($tagGroup->where($where)->order('id desc'));
        foreach($res as $k=>$v){
            //会有多个群聊
            $chatList = json_decode($res[$k]->group_chat_list,1); //返回群聊数组
            foreach($chatList as $k2=>$group_chat) {
                $etGroupchat = (new Model('qy_et_groupchat'))->find(['wid' => $wid, 'chat_id' => $group_chat['chatid']]);
                //从每个群聊中 取出 群聊名称
                $chatList[$k2]['name'] = $etGroupchat->name;
            }

            $res[$k]->group_chat_list = $chatList;
            $res[$k]->sendUserNum = count(json_decode($res[$k]->send_msg_userid,1));
            $res[$k]->getMsgUserNum = count(json_decode($res[$k]->get_msg_userid,1));
            $res[$k]->joinUserNum = count(json_decode($res[$k]->join_userid,1));
        }

        $this->assign("P", $p);
        //$this->assign("P", $GLOBALS['P']);
        $this->assign("res", $res);
        $this->assign("name", $name);

        return $this->show();
    }

    public function select_group_chat2(){
        $wid = Session::get('wid');
        $groupchatList = (new Model('qy_et_groupchat'))->where(['wid'=>$wid])->list_all_array();
        $this->assign("groupchatList", $groupchatList);
        $this->assign("count", count($groupchatList));
        return $this->show();
    }
	
	public function groupchat_info(){
        setApi();
        $wid = Session::get('wid');
        $chatid = $_POST['chatid'];
        foreach ($chatid as $key => $value) {
            $etGroupchat[] = (new Model('qy_et_groupchat'))->find(['wid'=>$wid,'chat_id'=>$value]);
        }
        foreach ($etGroupchat as $keys => $values) {
            if($values->name == ""){
                $values->name = "默认群名";
            }
        }
        sendSuccess('获取成功',$etGroupchat);
    }

    public function add_tag_user_group(){
        $wid = Session::get('wid');
        if(is_post()){
            setApi();

            $QyWechatApi = QyWechatApi::getInstance();
            $qyConfig = (new Model('qy_wechat_config'))->find(['wid'=>$wid]);
            $etApp = $QyWechatApi->get_qy_app($qyConfig->corp_id,$qyConfig->externalcontact_secret);
            $tagGroupTask = new Model('qy_et_tag_group');

            $itemId = $_POST['item_id'];
			$itemChatid = $_POST['item_chatid'];
            $itemName = $_POST['item_name'];
            $itemImg = $_POST['item_img'];
            $itmeArr = [];
            foreach($itemId as $k=>$id){
                $itmeArr[$k]['id'] = $id;
				$itmeArr[$k]['chatid'] = $itemChatid[$k];
                $itmeArr[$k]['name'] = $itemName[$k];
                $itmeArr[$k]['img'] = $itemImg[$k];
            }

            $tagGroupTask->wid = $wid;
            $tagGroupTask->group_chat_list = json_encode($itmeArr,320);
            $tagGroupTask->name = $_POST['name'];
            $tagGroupTask->text_content = $_POST['text_content'];
            $tagGroupTask->send_to = $_POST['shareuser'];
            $tagGroupTask->send_tag = json_encode(explode(',',$_POST['checkLable']),320);
            $tagGroupTask->send_user = json_encode(explode(',',$_POST['checkUser']),320);

            $filter = $_POST['filter'];
            if($filter == 1){
                $tagGroupTask->filter = 1;
            }else{
                $tagGroupTask->filter = 2;
            }
            $tagGroupTask->ctime = date('Y-m-d H:i:s');
            //先保存
            $tagGroupTask->save();
            //查询出用户ids
            $external_userids = $this->get_send_user($wid,$tagGroupTask);
            //查询出群聊
            $groupchatList = (new Model('qy_et_groupchat'))->where(['wid'=>$wid,'chat_id'=>$itemChatid])->list_all();
            foreach($groupchatList as $k=>$v){
                foreach($itmeArr as $item){
                    if($item['id'] == $v->id){
                        $groupchatList[$k]->item = $item;
                        break;
                    }
                }
            }
            //是否需要过滤
            if($tagGroupTask->filter == 1){
                $group_chat_userid = [];
                foreach ($groupchatList as $k=>$v){
                    $member_list = json_decode($v->member_list,1);
                    foreach ($member_list as $m){
                        $group_chat_userid[] = $m['userid'];
                    }
                }
                //取出差值  就是不在群里面的
                $external_userids = array_diff($external_userids,$group_chat_userid);

                $tagGroupTask->send_msg_userid = json_encode($external_userids,320);
                $tagGroupTask->save();
            }
            //sendSuccess('操作成功');
            $lista = $external_userids;  //表示发送的用户
            $listb = $groupchatList;  //表示群聊
            $max_size = 200; //微信群 二维码入群 最大200
            $send_index = 0; //表示发送用户的下标  同时也表示 发送的用户数

            $msgid = []; //发送群发任务的 msgid
            //如果发送的用户数  少于第一个群的 剩余群位置  直接发送第一个群聊
            $first_chat_num = count(json_decode($listb[0]->member_list,1));//第一个群聊的 用户数
            if(count($lista)<= ($max_size-$first_chat_num)){
                //执行发送逻辑
                $msgid[] = $this->send_msg_group($etApp,$tagGroupTask->text_content, $listb[0]->item['img'] ,$lista);

            }else{
                foreach ($listb as $k=>$v){
                    //如果 当前群聊是最后一个 用户都用这个群聊发送
                    if($k == count($listb)){
                        //从余下的下标 之后的发送
                        $send_user = array_slice($lista,$send_index);
                        //执行发送逻辑
                        $msgid[] = $this->send_msg_group($etApp,$tagGroupTask->text_content, $v->item['img'] ,$send_user);
                        break;
                    }else{
                        //本次 群剩下可以邀请的数目
                        $group_Num = $max_size - count(json_decode($listb[$k]->member_list,1));

                        //判断  这个群聊是否满足 剩下的客户
                        if( count($lista) - $send_index <= $group_Num){
                            //已经满足  说明这是最后一批用户
                            $send_user = array_slice($lista,$send_index);
                            $send_index = count($lista);
                            //执行发送逻辑
                            $msgid[] = $this->send_msg_group($etApp,$tagGroupTask->text_content, $v->item['img'] ,$send_user);
                            break;
                        }else{
                            //获得本次发送的用户
                            $send_user = array_slice($lista,$send_index,$group_Num);
                            $send_index += $group_Num;
                            //执行发送逻辑
                            $msgid[] = $this->send_msg_group($etApp,$tagGroupTask->text_content, $v->item['img'] ,$send_user);
                        }
                    }
                }
            }
            $tagGroupTask->msg_id = json_encode($msgid,320);
            $tagGroupTask->save();
            sendSuccess('操作成功');
        }

        return $this->show();
    }

    private function get_send_user($wid,$tagGroupTask){
        $externalcontact = (new Model('qy_externalcontact_list'))->where(['wid'=>$wid])->list_all_array();
        $external_userids = [];
        if($tagGroupTask->send_to == 1){
            foreach($externalcontact as $et){
                $external_userids[] = $et['external_userid'];
            }
        }elseif($tagGroupTask->send_to == 2){
            foreach($externalcontact as $et){
                if(array_intersect(json_decode($et['tags'],1),json_decode($tagGroupTask->send_tag,1))){
                    $external_userids[] = $et['external_userid'];
                }
            }
        }elseif($tagGroupTask->send_to == 3){
            foreach($externalcontact as $et){
                $follow_user = json_decode($et['follow_user'],1);
                foreach($follow_user as $user){
                    if(in_array($user['userid'],json_decode($tagGroupTask->send_user,1))){
                        $external_userids[] = $et['external_userid'];
                        break;
                    }
                }
            }
        }
        return $external_userids;
    }

    private function send_msg_group($etApp,$text,$imgUrl,$send_user){
        //$msgid = "1234";
        $msg['external_userid'] = $send_user;
        $msg['text'] = ['content'=>$text];
        $msg['image'] = ['media_id'=>$etApp->media->uploadImage($imgUrl)['media_id']];
        $messageRes = $etApp->external_contact_message->submit($msg);
        if($messageRes['errcode'] == 0){
            $msgid = $messageRes['msgid'];
        }
        return $msgid;
    }

    /**
     * 标签建群  更新数据   微信那边获取
     */
    public function tag_group_detail(){
        setApi();
        $wid = Session::get('wid');
        $QyWechatApi = QyWechatApi::getInstance();
        $qyConfig = (new Model('qy_wechat_config'))->find(['wid'=>$wid]);
        $etApp = $QyWechatApi->get_qy_app($qyConfig->corp_id,$qyConfig->externalcontact_secret);

        $id = $_POST['id'];
        $tagGroupTask = new Model('qy_et_tag_group');
        $task = $tagGroupTask->find($id);
        //不等于0 代表查询到数据  查询出下面task 详情
        if($task->id != 0 ) {
            $list = json_decode($task->msg_id,1);
            $success_user = [];
            foreach ($list as $detail) {
                $result = $etApp->external_contact_message->get($detail);
                if ($result['errcode'] == 0) {
                    $detail_list = $result->detail_list;
                    foreach ($detail_list as $d) {
                        if ($d->status == 1) {
                            $success_user[] = $d->external_userid;
                        }
                    }

                }
            }
            if(count($success_user)>0){
                //查询到收到消息的用户
                $success_user = array_unique($success_user);
                $tagGroupTask->get_msg_userid = json_encode($success_user,320);
                $tagGroupTask->save();
                //查看收到消息的用户 在不在群里面
                $chat_list = json_decode($tagGroupTask->group_chat_list,1);
                $chat_user = []; //在群里的成员
                foreach ($chat_list as $v){
                    $chat = (new Model('qy_et_groupchat'))->find(['wid'=>$wid,'chat_id'=>$v['chatid']]);
                    $mermbers = json_decode($chat->member_list,1);
                    foreach ($mermbers as $m){
                        $chat_user[] = $m['userid'];
                    }
                }
                //取出在群里的 用户id
                $join_user = array_intersect($success_user,$chat_user);
                $tagGroupTask->join_userid = json_encode($join_user,320);
                $tagGroupTask->save();
            }
        }
        sendSuccess("操作成功");
    }

    /**
     * 2020-08-30
     * 客户群提醒列表
     */
    public function group_remind_list(){
        $wid = Session::get('wid');
        $groupMsgTask = new Model('qy_et_group_user_remind');

        $where['wid'] = $wid;
        $p = new \Pagination();
        $res = $p->model_list($groupMsgTask->where($where)->order('id desc'));
        //循环每个规则适用的群聊  用于展示
        foreach ($res as $k=>$v){
            $chatList = json_decode($res[$k]->chat_list,1);
            $etGroupchat = (new Model('qy_et_groupchat'))->where(['wid' => $wid, 'chat_id' => $chatList])->list_all();
            $res[$k]->chat = $etGroupchat;
            $res[$k]->key_list = json_decode($res[$k]->keys,1);
        }

        $this->assign("P", $p);
        //$this->assign("P", $GLOBALS['P']);
        $this->assign("res", $res);

        return $this->show();
    }

    public function save_group_remind(){
        $wid = Session::get('wid');
        $remind = new Model('qy_et_group_user_remind');
        $id = \Request::get(1);
        if($id){
            $remind->find(['wid'=>$wid,'id'=>$id]);
            $chatList = json_decode($remind->chat_list,1);
            //查询群聊
            $etGroupchat = (new Model('qy_et_groupchat'))->where(['wid' => $wid, 'chat_id' => $chatList])->list_all();
            $remind->chat = $etGroupchat;
            $remind->key_list = json_decode($remind->keys,1);
        }
        if(is_post()){
            setApi();
            if(!$_POST['chatid']){
                sendError('请选择群聊');
            }
            if($remind->id){

            }else{
                $remind->wid = $wid;
                $remind->ctime = date('Y-m-d H:i:s');
            }
            $remind->name = $_POST['name'];
            $remind->chat_list = json_encode($_POST['chatid'],320);
            $remind->img_qrcode = $_POST["img_qrcode"] ?: 0 ;
            $remind->link = $_POST["link"] ?: 0 ;
            $remind->weapp = $_POST["weapp"] ?: 0 ;
            $remind->card = $_POST["card"] ?: 0 ;
            $remind->text_key = $_POST["text_key"] ?: 0 ;
            if($remind->text_key){
                $remind->keys = json_encode($_POST["keys"],320);
            }
            $remind->status = $_POST["status"] ?: 0;
            $remind->save();
            sendSuccess("操作成功");
        }
        $this->assign("remind", $remind);
        return $this->show();
    }

    public function del_group_remind(){
        setApi();
        $wid = Session::get('wid');
        $id = $_POST['id'];
        $remind = new Model('qy_et_group_user_remind');
        $task = $remind->find($id);
        if($task->id){
            $task->remove();
            sendSuccess('操作成功');
        }else{
            sendError("操作失败");
        }
    }
    /**
     * 2020-10-29
     * 违规词提醒添加
     */
    public function violation_remind_list(){
        $wid = Session::get('wid');
        $groupMsgTask = new Model('qy_et_vio_remind');

        $where['wid'] = $wid;
        $p = new \Pagination();
        $res = $p->model_list($groupMsgTask->where($where)->order('id desc'));
        //循环每个规则适用的群聊  用于展示
        foreach ($res as $k=>$v){
            $chatList = json_decode($res[$k]->chat_list,1);
            $etGroupchat = (new Model('qy_et_groupchat'))->where(['wid' => $wid, 'chat_id' => $chatList])->list_all();
            $res[$k]->chat = $etGroupchat;
            $res[$k]->key_list = json_decode($res[$k]->keys,1);
        }

        $this->assign("P", $p);
        //$this->assign("P", $GLOBALS['P']);
        $this->assign("res", $res);

        return $this->show();
    }

    public function save_violation_remind(){
        $wid = Session::get('wid');
        $vioremind = new Model('qy_et_vio_remind');
        // sendSuccess("wew");
        $id = \Request::get(1);
        if($id){
            $vioremind->find(['wid'=>$wid,'id'=>$id]);
            // $chatList = json_decode($vioremind->chat_list,1);
            //查询群聊
            // $etGroupchat = (new Model('qy_et_groupchat'))->where(['wid' => $wid, 'chat_id' => $chatList])->list_all();
            // $vioremind->chat = $etGroupchat;
            $vioremind->key_list = json_decode($vioremind->keys,1);
        }
        if(is_post()){
            setApi();
            if($vioremind->id){
            }else{
                $vioremind->wid = $wid;
                $vioremind->ctime = date('Y-m-d H:i:s');
            }
            $vioremind->name = $_POST['name'];
            // $vioremind->chat_list = json_encode($_POST['chatid'],320);
            $vioremind->img_qrcode =  0 ;
            $vioremind->link = 0 ;
            $vioremind->weapp = 0 ;
            $vioremind->card = 0 ;
            $vioremind->text_key = 1 ;
            // if($vioremind->text_key){
                $vioremind->keys = json_encode($_POST["keys"],320);
            // }
            $vioremind->status = 0;
            // sendSuccess($vioremind);
            $vioremind->save();
            // sendSuccess($_POST);
            sendSuccess("操作成功");
        }
        $this->assign("vioremind", $vioremind);
        return $this->show();
    }

    public function del_violation_remind(){
        setApi();
        $wid = Session::get('wid');
        $id = $_POST['id']; 
        $vioremind = new Model('qy_et_vio_remind');
        $task = $vioremind->find($id);
        if($task->id){
            $task->remove();
            sendSuccess('操作成功');
        }else{
            sendError("操作失败");
        }
    }
}