<?php
namespace Addons\QyWechat\Controller\Admin;

use Models\BaseModel as Model;
use Session;
use Addons\QyWechat\Helper;
use Addons\QyWechat\Services\QyWechatApi;

class Datas extends BaseAdmin
{	
    public function statistics(){
		$wid = Session::get('wid');
		$qyConfig = (new Model('qy_wechat_config'))->find(['wid'=>$wid]);
		$QyWechatApi = QyWechatApi::getInstance();
		$etApp = $QyWechatApi->get_qy_app($qyConfig->corp_id,$qyConfig->externalcontact_secret);
		$etNum = (new Model('qy_externalcontact_list'))->where(['wid'=>$wid])->count();//客户总数
		$groupchatNum = (new Model('qy_et_groupchat'))->where(['wid'=>$wid])->count();//群总数
		$groupchat = (new Model('qy_et_groupchat'))->where(['wid'=>$wid])->list_all();
		foreach($groupchat as $group){
			$groupchatuserNum += count(json_decode($group->member_list,1));//群成员总数
		}
		if(is_post()){
			setApi();
			$statistics_date =[];
			$new_apply_cnt = [];
			$new_contact_cnt = [];
			$chat_cnt = [];
			$message_cnt = [];
			$reply_percentage = [];
			$avg_reply_time = [];
			$negative_feedback_cnt = [];
			$userIds = [];
			$userList = (new Model('qy_user_list'))->field('userid')->where(['wid'=>$wid,"is_del"=>0])->list_all_array();
			foreach($userList as $user){
				$userIds[] = $user['userid'];
			}
			$chunk_result = array_chunk($userIds, 100);
			$count = count($chunk_result);
			if($_POST['type'] == 'first'){
				//第一次加载数据
				$startDate = date('Y-m-d',strtotime("-1 week"));//前一周
				$endDate = date('Y-m-d',strtotime("-1 day"));//昨天
			}elseif($_POST['type'] == 'one_week'){
				//一周数据
				$startDate = date('Y-m-d',strtotime("-1 week"));//前一周
				$endDate = date('Y-m-d',strtotime("-1 day"));//昨天
			}elseif($_POST['type'] == 'two_week'){
				//二周数据
				$startDate = date('Y-m-d',strtotime("-2 week"));//前二周
				$endDate = date('Y-m-d',strtotime("-1 day"));//昨天
			}elseif($_POST['type'] == 'one_month'){
				//一月数据
				$startDate = date('Y-m-d',strtotime("-1 month"));//前一月
				$endDate = date('Y-m-d',strtotime("-1 day"));//昨天
			}elseif($_POST['type'] == 'usedate'){
				$startDate =  $_POST['startDate'];
				$endDate = $_POST['endDate'];
			}
			for ($x=0; $x<$count; $x++){
				$statisticsRes[] = $etApp->external_contact_statistics->userBehavior($chunk_result[$x], strtotime($startDate), strtotime($endDate));
				if($statisticsRes['errcode'] == 0){
					$behavior_data = $statisticsRes['0']['behavior_data'];
					foreach ($behavior_data as $data) {
						$date_ = date('Y-m-d',$data['stat_time']);
						if (isset($statistics_date[$date_])) {
							$new_apply_cnt[$date_] +=$data['new_apply_cnt'];
							$new_contact_cnt[$date_] +=$data['new_contact_cnt'];
							$chat_cnt[$date_] +=$data['chat_cnt'];
							$message_cnt[$date_] +=$data['message_cnt'];
							$reply_percentage[$date_] +=$data['reply_percentage'];
							$avg_reply_time[$date_] +=$data['avg_reply_time'];
							$negative_feedback_cnt[$date_] +=$data['negative_feedback_cnt'];
						} else {
							$statistics_date[$date_] = $date_;
							$new_apply_cnt[$date_] = $data['new_apply_cnt'];
							$new_contact_cnt[$date_] = $data['new_contact_cnt'];
							$chat_cnt[$date_] = $data['chat_cnt'];
							$message_cnt[$date_] = $data['message_cnt'];
							$reply_percentage[$date_] = $data['reply_percentage'];
							$avg_reply_time[$date_] = $data['avg_reply_time'];
							$negative_feedback_cnt[$date_] = $data['negative_feedback_cnt'];
						}
					}
					
				}else{
					//sendError('获取数据失败:'.$statisticsRes['errmsg']);
					sendError('获取数据失败:请检查企微配置');
				}
			}
			$data = [
				'statistics_date'=> array_values($statistics_date),
				'new_apply_cnt'=>array_values($new_apply_cnt),
				'new_contact_cnt'=>array_values($new_contact_cnt),
				'chat_cnt'=>array_values($chat_cnt),
				'message_cnt'=>array_values($message_cnt),
				'reply_percentage'=>array_values($reply_percentage),
				'avg_reply_time'=>array_values($avg_reply_time),
				'negative_feedback_cnt'=>array_values($negative_feedback_cnt),
			];
			sendSuccess('获取成功',$data);
		}
		$this->assign("etNum", $etNum);
		$this->assign("groupchatNum", $groupchatNum);
		$this->assign("groupchatuserNum", $groupchatuserNum);
		return $this->show();
	}	
}