

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for `ims_user_linshi`
-- ----------------------------
DROP TABLE IF EXISTS `ims_user_linshi`;
CREATE TABLE `ims_user_linshi` (
  `id` int(11) NOT NULL,
  `username` varchar(100) NOT NULL,
  `token` varchar(255) NOT NULL
) ENGINE=MyISAM AUTO_INCREMENT=48 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of ims_user_linshi
-- ----------------------------

-- ----------------------------
-- Table structure for `qvmh_agency_imglib`
-- ----------------------------
DROP TABLE IF EXISTS `qvmh_agency_imglib`;
CREATE TABLE `qvmh_agency_imglib` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) DEFAULT NULL,
  `type` varchar(255) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `is_oss` tinyint(1) DEFAULT NULL,
  `ctime` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of qvmh_agency_imglib
-- ----------------------------

-- ----------------------------
-- Table structure for `qvmh_auth_check`
-- ----------------------------
DROP TABLE IF EXISTS `qvmh_auth_check`;
CREATE TABLE `qvmh_auth_check` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `auth_id` smallint(1) DEFAULT NULL COMMENT 'user表中level_id column',
  `controllers` text COMMENT '控制器名（php文件名不包括后缀.php）',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COMMENT='权限控制表';

-- ----------------------------
-- Records of qvmh_auth_check
-- ----------------------------
INSERT INTO `qvmh_auth_check` VALUES ('1', '1', 'userCenter/balance');
INSERT INTO `qvmh_auth_check` VALUES ('2', '2', 'vshopadmin/vshop/GroupBuy/plist/List,vshopadmin/vshop/GroupBuy/set,vshopadmin/vshop/GroupBuy/List,vshopadmin/vshop/GroupBuy/OrderList,vshopadmin/vshop/zhongchou/Set,vshopadmin/vshop/zhongchou/List,vshopadmin/vshop/zhongchou/OrderList,vshopadmin/vshop/Seckill/set,vshopadmin/vshop/Seckill/List,vshopadmin/vshop/Seckill/OrderList');
INSERT INTO `qvmh_auth_check` VALUES ('3', '3', 'vshopadmin/vshop/GroupBuy/plist/List,vshopadmin/vshop/GroupBuy/set,vshopadmin/vshop/GroupBuy/List,vshopadmin/vshop/GroupBuy/OrderList,vshopadmin/vshop/zhongchou/Set,vshopadmin/vshop/zhongchou/List,vshopadmin/vshop/zhongchou/OrderList,vshopadmin/vshop/Seckill/set,vshopadmin/vshop/Seckill/List,vshopadmin/vshop/Seckill/OrderList');
INSERT INTO `qvmh_auth_check` VALUES ('4', '4', 'vshopadmin/vshop/GroupBuy/plist/List,vshopadmin/vshop/GroupBuy/set,vshopadmin/vshop/GroupBuy/List,vshopadmin/vshop/GroupBuy/OrderList,vshopadmin/vshop/zhongchou/Set,vshopadmin/vshop/zhongchou/List,vshopadmin/vshop/zhongchou/OrderList,vshopadmin/vshop/Seckill/set,vshopadmin/vshop/Seckill/List,vshopadmin/vshop/Seckill/OrderList');
INSERT INTO `qvmh_auth_check` VALUES ('5', '5', 'Addons/GoodsAide/Admin/TaoBao,Addons/GoodsAide/Admin/ApiSet,Addons/DuoZhanBao/Admin/msgList/index,Addons/DuoZhanBao/Admin/userList/index,Addons/DuoZhanBao/Admin/setting/index,Addons/DuoZhanBao/Admin/imgList/index,Addons/DuoZhanBao/Admin/noticeList/index,Addons/DuoZhanBao/Admin/cateList/index,Addons/DuoZhanBao/Admin/commentList/index,Addons/H5Support/Admin/Info/pay_set,Addons/H5Support/Admin/Info/shop_view,Addons/AliPublish/Admin/Publishs/get_auth,Addons/AliPublish/Admin/AliOpen/certify,vshopadmin/vshop/GroupBuynew/List,vshopadmin/vshop/GroupBuynew/GroupList,vshopadmin/vshop/GroupBuynew/SingleOrderList,Addons/Zhct/Admin/IndexPage,Addons/Zhct/Admin/Defaults,Addons/Zhct/Admin/HeaderColor,Addons/Zhct/Admin/Firstad,Addons/Zhct/Admin/Dada,Addons/Zhct/Admin/setList,Addons/Zhct/Admin/SellerIn/SellerIn,Addons/Zhct/Admin/ShopList/ShopList,Addons/Zhct/Admin/Withdraw/Lists,Addons/Zhct/Admin/TempDownload,Addons/AliLive/Admin/Live/live_set,Addons/AliLive/Admin/Dms/dms_set,Addons/AliLive/Admin/Live/index,Addons/AliLive/Admin/TemplateMsg/set,Addons/Zhibo/Admin/RoomList/index,addons/template_msg/admin/wechat/index,userCenter/indexGif,userCenter/copyright,userCenter/personalCenter,vshopadmin/vshop/ShopSet,vshopadmin/seller/account,vshopadmin/Store/List,vshopadmin/weblist/List,vshopadmin/hardware/printerList,vshopadmin/vshop/Firstad/List,vshopadmin/vshop/BusinessStyle/PageTemplate,vshopadmin/vshop/BusinessStyle/PageList,vshopadmin/vshop/BusinessStyle/generate,Publish/fabu,userCenter/payset,Template/download,vshopadmin/programlist/List,vshopadmin/vshop/Sharexzc/List,PublishBd/fabu,userCenter/bdPayset,userCenter/bdPayupdate,Template/downloadBd,userCenter/zfbPayset,Template/downloadAli,userCenter/TtPayset,userCenter/TtPayupdate,Template/downloadTt,vshopadmin/vip/vipList,vshopadmin/vip/tagMgr,vshopadmin/vip/getPoint,vshopadmin/vip/consumePoint,vshopadmin/vip/pointRule,vshopadmin/vip/tplMsg,vshopadmin/vip/vipLevel,vshopadmin/vshop/uniForm/formList,vshopadmin/vshop/uniForm/addForm,userCenter/tongji,TemplateMsg/Set,vshopadmin/vshop/Goods/sproduct,vshopadmin/vshop/Classify/List,vshopadmin/vshop/Goods/sprop,vshopadmin/vshop/Goods/sgroup,vshopadmin/vshop/Goods/stag,vshopadmin/vshop/Order/OrderRules,vshopadmin/vshop/Order/DeliveryMode,vshopadmin/vshop/Order/FreightRules,vshopadmin/vshop/Order/OrderList,vshopadmin/vshop/Order/OrderTask,vshopadmin/vshop/Order/OrderDelivery,vshopadmin/vshop/Order/OrderEvaluation,vshopadmin/vshop/Order/RefundOrderList,vshopadmin/vshop/SystemSet/LogisticsOrderSet/DeliveryTemplateList,vshopadmin/vshop/SystemSet/LogisticsOrderSet/AddressLibraryList,vshopadmin/vagent/Setting,vshopadmin/vagent/VagentList,vshopadmin/vagent/ExtractAccount,vshopadmin/vagent/Brokerage/List,vshopadmin/vagent/Brokerage/List2,vshopadmin/vshop/ShopActivity/ActivityList,vshopadmin/vshop/ShopActivity/CouponSet,vshopadmin/vshop/GroupBuy/List,vshopadmin/vshop/GroupBuy/GroupList,vshopadmin/vshop/GroupBuy/SingleOrderList,vshopadmin/vshop/Seckill/List,vshopadmin/vshop/Seckill/OrderList,Dzp/setting,Dzp/prizeList,Dzp/record,vshopadmin/vshop/Bargain/Goods/GoodsList,vshopadmin/vshop/Bargain/OrderList,kefu/config,kefu/tuwenList,kefu/setting,kefu/autoReplyList,vshopadmin/bespeak/set,vshopadmin/bespeak/Classify/List,vshopadmin/bespeak/bespeak/List,vshopadmin/bespeak/service/List,vshopadmin/bespeak/feedback/List,reserve/list,reserve/shop,reserve/user,reserve/works,addons/pay_cheap/admin/Payset,addons/pay_cheap/admin/Paylook,addons/PayCheap/Admin/adviseCharge,vshopadmin/Article/Classify/List,vshopadmin/Article/Article/List,vshopadmin/vshop/Leave/List,answer/answerList,customPage/setting,customPage/lunboList,customPage/aboutSetting,customPage/newsSetting,customPage/prodSetting,customPage/demoSetting,customPage/contactSetting,customPage/joinusSetting,customPage/ly,jd/jdList,jd/kfList,jd/orderList,jd/commentList,jd/setting,vshopadmin/vshop/MoreShop/setList,vshopadmin/vshop/MoreShop/SellerIn/SellerIn,vshopadmin/vshop/MoreShop/ShopList/ShopList,vshopadmin/vshop/MoreShop/Withdraw/List,vshopadmin/vshop/MoreShop/classify/cateList,tc/setting,tc/imgList,tc/noticeList,tc/userList,tc/cateList,tc/msgList,tc/commentList,wd/setting,wd/cateList,wd/authorList,wd/quoteList,wd/designList,wd/demoList,wd/imgList,vshopadmin/vshop/WeiTrain/Setting,vshopadmin/vshop/WeiTrain/Lesson/LessonList,vshopadmin/vshop/WeiTrain/Teacher/TeacherList,vshopadmin/vshop/WeiTrain/Video/VideoList,vshopadmin/vshop/WeiTrain/YueKe/YueKeList,vshopadmin/vshop/WeiTrain/Order/OrderList,vshopadmin/vshop/WordsGame/List,vshopadmin/vshop/WordsGame/PrizeList,wpc/list,vshopadmin/vshop/ZhaiMore/Setting,vshopadmin/vshop/ZhaiMore/ShopList/ShopList,vshopadmin/vshop/ZhaiMore/UserList/UserList,vshopadmin/vshop/ZhaiMore/Area/ListArea,vshopadmin/vshop/ZhaiMore/ZhuangXiu/List,vshopadmin/vshop/ZhaiMore/YongTu/List,vshopadmin/vshop/ZhaiMore/FaTie/List,vshopadmin/vshop/ZhaiMore/Qiu/List,zhct/setting,zhct/youhuiList,zhct/tableList,zhct/qrcode,zhct/cateList,zhct/productList,zhct/ctOrderList,zhct/wmOrderList,Addons/BdWeb/Admin/WebSet,addons/QqSupport/admin/Info/applet_set,addons/QqSupport/admin/Info/pay_set,addons/QqSupport/admin/Info/download_info,addons/qr_image/admin/collect,userCenter/sykpayset,Addons/WechatTemplate/Admin/ParameterSet,Addons/WechatTemplate/Admin/LogList,Addons/WechatTemplate/Admin/UsefulUser,Addons/WechatTemplate/Admin/JumpPageSet/Lists');

-- ----------------------------
-- Table structure for `qvmh_help_center`
-- ----------------------------
DROP TABLE IF EXISTS `qvmh_help_center`;
CREATE TABLE `qvmh_help_center` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `url` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of qvmh_help_center
-- ----------------------------
INSERT INTO `qvmh_help_center` VALUES ('1', 'https://support.qq.com/product/174823');

-- ----------------------------
-- Table structure for `qvmh_houtai_check`
-- ----------------------------
DROP TABLE IF EXISTS `qvmh_houtai_check`;
CREATE TABLE `qvmh_houtai_check` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `typ` tinyint(1) DEFAULT NULL COMMENT '权限类别 1员工 2 代理 3特殊',
  `typid` bigint(20) DEFAULT NULL COMMENT '各项类别: 员工 代理 用户ID等等 见fun',
  `nopages` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=18 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of qvmh_houtai_check
-- ----------------------------

-- ----------------------------
-- Table structure for `qvmh_imglib`
-- ----------------------------
DROP TABLE IF EXISTS `qvmh_imglib`;
CREATE TABLE `qvmh_imglib` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wid` int(11) DEFAULT NULL,
  `type` varchar(255) DEFAULT NULL COMMENT '类别:vshop_img ......',
  `url` varchar(255) DEFAULT NULL COMMENT '图片可访问地址',
  `is_oss` tinyint(1) DEFAULT NULL COMMENT '是否存储在oss',
  `md5` varchar(50) DEFAULT NULL COMMENT '判断文件是否存在',
  `is_qiniu` tinyint(1) DEFAULT NULL COMMENT '是否存储在七牛',
  `ctime` varchar(20) DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `md5` (`md5`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=184 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of qvmh_imglib
-- ----------------------------

-- ----------------------------
-- Table structure for `qvmh_order`
-- ----------------------------
DROP TABLE IF EXISTS `qvmh_order`;
CREATE TABLE `qvmh_order` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `out_trade_no` varchar(30) DEFAULT NULL,
  `uid` int(11) DEFAULT NULL,
  `price` decimal(10,2) DEFAULT NULL,
  `describe` varchar(255) DEFAULT NULL,
  `pay_status` int(1) DEFAULT '0',
  `trade_time` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of qvmh_order
-- ----------------------------

-- ----------------------------
-- Table structure for `qvmh_pubs`
-- ----------------------------
DROP TABLE IF EXISTS `qvmh_pubs`;
CREATE TABLE `qvmh_pubs` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `uid` bigint(20) DEFAULT NULL,
  `pubun` varchar(50) DEFAULT NULL,
  `ghid` varchar(50) DEFAULT NULL,
  `wun` varchar(50) DEFAULT NULL COMMENT '微信用户名',
  `wpwd` varchar(50) DEFAULT NULL COMMENT '微信密码',
  `rtime` datetime DEFAULT NULL COMMENT '关联时间',
  `isval` tinyint(1) DEFAULT '0' COMMENT '是否验证通过',
  `http` text COMMENT '请求对象',
  `httptime` int(11) DEFAULT NULL COMMENT '对象确认时间',
  `token` varchar(32) DEFAULT NULL COMMENT '授权令牌',
  `uuid` varchar(32) DEFAULT NULL COMMENT '公共帐号的微信授权ID',
  `cusid` varchar(32) DEFAULT NULL COMMENT '接口ID',
  `cussec` varchar(32) DEFAULT NULL COMMENT '接口密钥',
  `headpic` varchar(255) DEFAULT NULL,
  `reval` tinyint(1) DEFAULT '1',
  `wtyp` int(2) DEFAULT '1',
  `oauth` tinyint(1) DEFAULT NULL,
  `appid` varchar(32) DEFAULT NULL,
  `appsecret` varchar(32) DEFAULT NULL,
  `authorizer_appid` varchar(255) DEFAULT NULL COMMENT '授权方appid',
  `authorizer_access_token` varchar(255) DEFAULT NULL COMMENT '授权访问令牌',
  `authorizer_refresh_token` varchar(255) DEFAULT NULL COMMENT '刷新授权令牌',
  `token_create_time` datetime DEFAULT NULL COMMENT '令牌获取时间',
  `printer_partner` varchar(255) DEFAULT NULL COMMENT '打印机用户id',
  `printer_apikey` varchar(255) DEFAULT NULL COMMENT '打印机key',
  `ald_access_token` varchar(255) DEFAULT NULL COMMENT '阿拉丁授权令牌',
  `ald_refresh_toke` varchar(255) DEFAULT NULL COMMENT '阿拉丁刷新授权令牌',
  `ald_create_time` datetime DEFAULT NULL COMMENT '阿拉丁令牌获取时间',
  `ald_appkey` varchar(255) DEFAULT NULL COMMENT '阿拉丁生成的小程序key',
  `bd_appid` varchar(32) DEFAULT NULL,
  `bd_authorizer_access_token` varchar(255) DEFAULT NULL,
  `bd_authorizer_refresh_token` varchar(255) DEFAULT NULL,
  `bd_token_create_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=46 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of qvmh_pubs
-- ----------------------------
INSERT INTO `qvmh_pubs` VALUES ('2', '2', null, null, null, null, null, '0', null, null, null, null, 'wx0176187a057cffda', 'f56121996de9c2f11baa5f5192cc6808', null, '1', '4', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `qvmh_pubs` VALUES ('3', '51', null, null, null, null, null, '0', null, null, null, null, null, null, null, '1', '1', null, null, null, null, null, null, null, '43216900', '87a7e180f31835a2c9d768e74eec8a74c0a17ff6', null, null, null, null, null, null, null, null);
INSERT INTO `qvmh_pubs` VALUES ('4', '52', null, null, null, null, null, '0', null, null, null, null, null, null, null, '1', '1', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `qvmh_pubs` VALUES ('5', '53', null, null, null, null, null, '0', null, null, null, null, null, null, null, '1', '1', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `qvmh_pubs` VALUES ('6', '54', null, null, null, null, null, '0', null, null, null, null, null, null, null, '1', '1', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `qvmh_pubs` VALUES ('7', '55', null, null, null, null, null, '0', null, null, null, null, null, null, null, '1', '1', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `qvmh_pubs` VALUES ('8', '56', null, null, null, null, null, '0', null, null, null, null, null, null, null, '1', '1', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `qvmh_pubs` VALUES ('9', '58', null, null, null, null, null, '0', null, null, null, null, null, null, null, '1', '1', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `qvmh_pubs` VALUES ('10', '57', null, null, null, null, null, '0', null, null, null, null, null, null, null, '1', '1', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `qvmh_pubs` VALUES ('11', '61', null, null, null, null, null, '0', null, null, null, null, null, null, null, '1', '1', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `qvmh_pubs` VALUES ('12', '63', null, null, null, null, null, '0', null, null, null, null, null, null, null, '1', '1', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `qvmh_pubs` VALUES ('13', '62', null, null, null, null, null, '0', null, null, null, null, null, null, null, '1', '1', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `qvmh_pubs` VALUES ('14', '66', null, null, null, null, null, '0', null, null, null, null, null, null, null, '1', '1', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `qvmh_pubs` VALUES ('15', '67', null, null, null, null, null, '0', null, null, null, null, null, null, null, '1', '1', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `qvmh_pubs` VALUES ('16', '68', null, null, null, null, null, '0', null, null, null, null, null, null, null, '1', '1', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `qvmh_pubs` VALUES ('17', '69', null, null, null, null, null, '0', null, null, null, null, null, null, null, '1', '1', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `qvmh_pubs` VALUES ('18', '70', null, null, null, null, null, '0', null, null, null, null, null, null, null, '1', '1', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `qvmh_pubs` VALUES ('19', '72', null, null, null, null, null, '0', null, null, null, null, null, null, null, '1', '1', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `qvmh_pubs` VALUES ('20', '73', null, null, null, null, null, '0', null, null, null, null, null, null, null, '1', '1', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `qvmh_pubs` VALUES ('21', '74', null, null, null, null, null, '0', null, null, null, null, null, null, null, '1', '1', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `qvmh_pubs` VALUES ('22', '76', null, null, null, null, null, '0', null, null, null, null, null, null, null, '1', '1', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `qvmh_pubs` VALUES ('23', '78', null, null, null, null, null, '0', null, null, null, null, null, null, null, '1', '1', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `qvmh_pubs` VALUES ('24', '79', null, null, null, null, null, '0', null, null, null, null, null, null, null, '1', '1', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `qvmh_pubs` VALUES ('25', '80', null, null, null, null, null, '0', null, null, null, null, null, null, null, '1', '1', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `qvmh_pubs` VALUES ('26', '81', null, null, null, null, null, '0', null, null, null, null, null, null, null, '1', '1', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `qvmh_pubs` VALUES ('27', '83', null, null, null, null, null, '0', null, null, null, null, null, null, null, '1', '1', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `qvmh_pubs` VALUES ('28', '84', null, null, null, null, null, '0', null, null, null, null, null, null, null, '1', '1', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `qvmh_pubs` VALUES ('29', '82', null, null, null, null, null, '0', null, null, null, null, null, null, null, '1', '1', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `qvmh_pubs` VALUES ('30', '85', null, null, null, null, null, '0', null, null, null, null, null, null, null, '1', '1', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `qvmh_pubs` VALUES ('31', '88', null, null, null, null, null, '0', null, null, null, null, null, null, null, '1', '1', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `qvmh_pubs` VALUES ('32', '89', null, null, null, null, null, '0', null, null, null, null, null, null, null, '1', '1', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `qvmh_pubs` VALUES ('33', '91', null, null, null, null, null, '0', null, null, null, null, null, null, null, '1', '1', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `qvmh_pubs` VALUES ('34', '92', null, null, null, null, null, '0', null, null, null, null, null, null, null, '1', '1', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `qvmh_pubs` VALUES ('35', '93', null, null, null, null, null, '0', null, null, null, null, null, null, null, '1', '1', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `qvmh_pubs` VALUES ('36', '96', null, null, null, null, null, '0', null, null, null, null, null, null, null, '1', '1', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `qvmh_pubs` VALUES ('37', '97', null, null, null, null, null, '0', null, null, null, null, null, null, null, '1', '1', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `qvmh_pubs` VALUES ('38', '110', null, null, null, null, null, '0', null, null, null, null, null, null, null, '1', '1', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `qvmh_pubs` VALUES ('39', '111', null, null, null, null, null, '0', null, null, null, null, null, null, null, '1', '1', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `qvmh_pubs` VALUES ('40', '112', null, null, null, null, null, '0', null, null, null, null, null, null, null, '1', '1', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `qvmh_pubs` VALUES ('41', '113', null, null, null, null, null, '0', null, null, null, null, null, null, null, '1', '1', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `qvmh_pubs` VALUES ('42', '114', null, null, null, null, null, '0', null, null, null, null, null, null, null, '1', '1', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `qvmh_pubs` VALUES ('43', '115', null, null, null, null, null, '0', null, null, null, null, null, null, null, '1', '1', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `qvmh_pubs` VALUES ('44', '109', null, null, null, null, null, '0', null, null, null, null, null, null, null, '1', '1', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `qvmh_pubs` VALUES ('45', '116', null, null, null, null, null, '0', null, null, null, null, null, null, null, '1', '1', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);

-- ----------------------------
-- Table structure for `qvmh_qy_agency_gzh_config`
-- ----------------------------
DROP TABLE IF EXISTS `qvmh_qy_agency_gzh_config`;
CREATE TABLE `qvmh_qy_agency_gzh_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) DEFAULT NULL,
  `appid` varchar(255) DEFAULT NULL,
  `appsecret` varchar(255) DEFAULT NULL,
  `ctime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of qvmh_qy_agency_gzh_config
-- ----------------------------

-- ----------------------------
-- Table structure for `qvmh_qy_del_follow_user_record`
-- ----------------------------
DROP TABLE IF EXISTS `qvmh_qy_del_follow_user_record`;
CREATE TABLE `qvmh_qy_del_follow_user_record` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wid` int(11) DEFAULT NULL,
  `external_userid` varchar(255) DEFAULT NULL COMMENT '外部联系人的userid',
  `name` varchar(255) DEFAULT NULL,
  `avatar` varchar(255) DEFAULT NULL,
  `gender` int(11) DEFAULT '0' COMMENT '外部联系人性别 0-未知 1-男性 2-女性',
  `user_id` int(11) DEFAULT NULL COMMENT '所属成员',
  `follow_user` text,
  `ctime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of qvmh_qy_del_follow_user_record
-- ----------------------------

-- ----------------------------
-- Table structure for `qvmh_qy_del_udexternal_record`
-- ----------------------------
DROP TABLE IF EXISTS `qvmh_qy_del_udexternal_record`;
CREATE TABLE `qvmh_qy_del_udexternal_record` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wid` int(11) DEFAULT NULL,
  `external_userid` varchar(255) DEFAULT NULL COMMENT '外部联系人的userid',
  `name` varchar(255) DEFAULT NULL,
  `avatar` varchar(255) DEFAULT NULL,
  `gender` int(11) DEFAULT '0' COMMENT '外部联系人性别 0-未知 1-男性 2-女性',
  `user_id` int(11) DEFAULT NULL COMMENT '所属成员',
  `follow_user` text,
  `ctime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of qvmh_qy_del_udexternal_record
-- ----------------------------

-- ----------------------------
-- Table structure for `qvmh_qy_et_contact_way`
-- ----------------------------
DROP TABLE IF EXISTS `qvmh_qy_et_contact_way`;
CREATE TABLE `qvmh_qy_et_contact_way` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wid` int(11) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL COMMENT '渠道名称',
  `skip_verify` tinyint(1) DEFAULT '1' COMMENT '自动通过验证 1是 0否',
  `state` varchar(255) DEFAULT NULL COMMENT '企业自定义的state参数，用于区分不同的添加渠道',
  `users` varchar(255) DEFAULT NULL COMMENT '使用该联系方式的用户userID列表',
  `type` tinyint(1) DEFAULT NULL COMMENT '联系方式类型,1-单人, 2-多人',
  `bz` varchar(255) DEFAULT NULL COMMENT '备注',
  `config_id` varchar(255) DEFAULT NULL COMMENT '新增联系方式的配置id',
  `qr_code` varchar(255) DEFAULT NULL COMMENT '联系二维码的URL',
  `auto_label` tinyint(1) DEFAULT '1' COMMENT '自动打标签 1是 0否',
  `select_label` varchar(255) DEFAULT NULL COMMENT '选中的标签',
  `auto_welcome_msg` tinyint(1) DEFAULT '1' COMMENT '自动发送欢迎语 1是 0否',
  `text_content` text COMMENT '消息文本内容,最长为4000字节',
  `other_type` tinyint(1) DEFAULT '1' COMMENT '添加其他类型 1无 2图片 3图文 4小程序',
  `image_url` varchar(255) DEFAULT NULL COMMENT '图片的url',
  `image_media_id` varchar(255) DEFAULT NULL COMMENT '图片的media_id',
  `link_title` varchar(255) DEFAULT NULL COMMENT '图文消息标题，最长为128字节',
  `link_picurl` varchar(255) DEFAULT NULL COMMENT '图文消息封面的url',
  `link_desc` text COMMENT '图文消息的描述，最长为512字节',
  `link_url` varchar(255) DEFAULT NULL COMMENT '图文消息的链接',
  `miniprogram_name` varchar(255) DEFAULT NULL,
  `miniprogram_title` varchar(255) DEFAULT NULL COMMENT '小程序消息标题，最长为64字节',
  `miniprogram_url` varchar(255) DEFAULT NULL COMMENT '小程序消息封面的url',
  `miniprogram_pic_media_id` varchar(255) DEFAULT NULL COMMENT '小程序消息封面的mediaid',
  `miniprogram_appid` varchar(255) DEFAULT NULL COMMENT '小程序appid',
  `miniprogram_page` varchar(255) DEFAULT NULL COMMENT '小程序page路径',
  `is_auto_pull_group` tinyint(1) DEFAULT '0' COMMENT '是否是自动拉群活码 0不是 1是',
  `group_chat_list` text COMMENT '群聊列表',
  `ctime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of qvmh_qy_et_contact_way
-- ----------------------------

-- ----------------------------
-- Table structure for `qvmh_qy_et_contact_way_statistics`
-- ----------------------------
DROP TABLE IF EXISTS `qvmh_qy_et_contact_way_statistics`;
CREATE TABLE `qvmh_qy_et_contact_way_statistics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wid` int(11) DEFAULT NULL,
  `state` varchar(11) DEFAULT NULL COMMENT '添加此用户的「联系我」方式配置的state参数，可用于识别添加此用户的渠道',
  `add_num` int(11) DEFAULT '0' COMMENT '今日新增',
  `ctime` varchar(255) DEFAULT NULL COMMENT '日期时间戳',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of qvmh_qy_et_contact_way_statistics
-- ----------------------------

-- ----------------------------
-- Table structure for `qvmh_qy_et_dynamic`
-- ----------------------------
DROP TABLE IF EXISTS `qvmh_qy_et_dynamic`;
CREATE TABLE `qvmh_qy_et_dynamic` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wid` int(11) DEFAULT NULL,
  `external_userid` varchar(255) DEFAULT NULL COMMENT '外部联系人userid',
  `type` int(11) DEFAULT NULL COMMENT '1: 添加好友 2:删除好友 3:客户流失 4:加入群聊 5:点击雷达(radar_list id)',
  `user_id` int(11) DEFAULT NULL COMMENT '员工id（员工表id）',
  `chat_id` varchar(255) DEFAULT NULL COMMENT '群聊chatid（客户群表chat_id）',
  `ctime` varchar(255) DEFAULT NULL,
  `glian_id` int(11) DEFAULT NULL COMMENT 'type对应的表id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of qvmh_qy_et_dynamic
-- ----------------------------

-- ----------------------------
-- Table structure for `qvmh_qy_et_groupchat`
-- ----------------------------
DROP TABLE IF EXISTS `qvmh_qy_et_groupchat`;
CREATE TABLE `qvmh_qy_et_groupchat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wid` int(11) DEFAULT NULL,
  `chat_id` varchar(255) DEFAULT NULL COMMENT '客户群ID',
  `status` int(11) DEFAULT NULL COMMENT '客户群状态。',
  `name` varchar(255) DEFAULT NULL COMMENT '群名',
  `user_id` int(11) DEFAULT NULL COMMENT '员工表id',
  `create_time` varchar(255) DEFAULT NULL COMMENT '群的创建时间',
  `notice` varchar(255) DEFAULT NULL COMMENT '群公告',
  `member_list` text COMMENT '群成员列表',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of qvmh_qy_et_groupchat
-- ----------------------------

-- ----------------------------
-- Table structure for `qvmh_qy_et_group_msg_detail`
-- ----------------------------
DROP TABLE IF EXISTS `qvmh_qy_et_group_msg_detail`;
CREATE TABLE `qvmh_qy_et_group_msg_detail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wid` int(11) DEFAULT NULL,
  `gtid` int(11) DEFAULT NULL,
  `owner` int(11) DEFAULT NULL COMMENT '群主id （员工id）',
  `msgid` varchar(255) DEFAULT NULL COMMENT '企业群发消息的id',
  `success_num` int(11) DEFAULT NULL COMMENT '发送成功数量',
  `fail_num` int(11) DEFAULT NULL COMMENT '发送失败数量',
  `result` text COMMENT '群发消息发送结果',
  `update_time` datetime DEFAULT NULL COMMENT '最后更新时间',
  `ctime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='客户群群发任务详情';

-- ----------------------------
-- Records of qvmh_qy_et_group_msg_detail
-- ----------------------------

-- ----------------------------
-- Table structure for `qvmh_qy_et_group_msg_task`
-- ----------------------------
DROP TABLE IF EXISTS `qvmh_qy_et_group_msg_task`;
CREATE TABLE `qvmh_qy_et_group_msg_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wid` int(11) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL COMMENT '任务名称',
  `send_mode` tinyint(1) DEFAULT NULL COMMENT '1立即发送 2定时发送',
  `timing_time` varchar(255) DEFAULT NULL COMMENT '定时发送时间',
  `owner` varchar(255) DEFAULT NULL COMMENT '群主ids',
  `text_content` text COMMENT '消息文本内容',
  `other_type` tinyint(1) DEFAULT NULL COMMENT '添加其他类型 1无 2图片 3图文 4小程序',
  `image_url` varchar(255) DEFAULT NULL COMMENT '图片url',
  `image_media_id` varchar(255) DEFAULT NULL COMMENT '图片的media_id',
  `link_title` varchar(255) DEFAULT NULL COMMENT '图文消息标题',
  `link_picurl` varchar(255) DEFAULT NULL COMMENT '图文消息封面的url',
  `link_desc` text COMMENT '图文消息的描述，最多512个字节',
  `link_url` varchar(255) DEFAULT NULL COMMENT '图文消息的链接',
  `miniprogram_name` varchar(255) DEFAULT NULL COMMENT '小程序名称',
  `miniprogram_title` varchar(255) DEFAULT NULL COMMENT '小程序消息标题，最多64个字节',
  `miniprogram_picurl` varchar(255) DEFAULT NULL COMMENT '小程序消息封面的url',
  `miniprogram_pic_media_id` varchar(255) DEFAULT NULL COMMENT '小程序消息封面的mediaid',
  `miniprogram_appid` varchar(255) DEFAULT NULL COMMENT '小程序appid',
  `miniprogram_page` varchar(255) DEFAULT NULL COMMENT '小程序page路径',
  `status` tinyint(1) DEFAULT '0' COMMENT '发送状态 3待发送 0发送中 1发送成功  2发送失败',
  `ctime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of qvmh_qy_et_group_msg_task
-- ----------------------------

-- ----------------------------
-- Table structure for `qvmh_qy_et_group_user_remind`
-- ----------------------------
DROP TABLE IF EXISTS `qvmh_qy_et_group_user_remind`;
CREATE TABLE `qvmh_qy_et_group_user_remind` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wid` int(11) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `chat_list` text COMMENT '群聊列表',
  `img_qrcode` int(11) DEFAULT NULL COMMENT '检查带二维码图片',
  `link` int(11) DEFAULT NULL COMMENT '链接分享',
  `weapp` int(11) DEFAULT NULL COMMENT '小程序',
  `card` int(11) DEFAULT NULL COMMENT '名片',
  `text_key` int(11) DEFAULT NULL COMMENT '关键词',
  `keys` text COMMENT '关键词列表',
  `status` int(11) DEFAULT NULL COMMENT '是否启用 0:启用 1：停用',
  `ctime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of qvmh_qy_et_group_user_remind
-- ----------------------------

-- ----------------------------
-- Table structure for `qvmh_qy_et_msg_template`
-- ----------------------------
DROP TABLE IF EXISTS `qvmh_qy_et_msg_template`;
CREATE TABLE `qvmh_qy_et_msg_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wid` int(11) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL COMMENT '任务名称',
  `send_to` tinyint(1) DEFAULT '1' COMMENT '群发对象 1全部  2按客户标签 3按成员',
  `send_tag` varchar(255) DEFAULT NULL COMMENT '所选客户标签',
  `send_user` varchar(255) DEFAULT NULL COMMENT '所选成员',
  `send_mode` tinyint(1) DEFAULT '1' COMMENT '1立即群发 2定时群发',
  `timing_time` varchar(255) DEFAULT NULL COMMENT '定时群发时间',
  `text_content` text COMMENT '消息文本内容',
  `other_type` tinyint(1) DEFAULT '1' COMMENT '添加其他类型 1无 2图片 3图文 4小程序',
  `image_url` varchar(255) DEFAULT NULL COMMENT '图片url',
  `image_media_id` varchar(255) DEFAULT NULL COMMENT '图片的media_id',
  `link_title` varchar(255) DEFAULT NULL COMMENT '图文消息标题',
  `link_picurl` varchar(255) DEFAULT NULL COMMENT '图文消息封面的url',
  `link_desc` text COMMENT '图文消息的描述，最多512个字节',
  `link_url` varchar(255) DEFAULT NULL COMMENT '图文消息的链接',
  `miniprogram_name` varchar(255) DEFAULT NULL COMMENT '小程序名称',
  `miniprogram_title` varchar(255) DEFAULT NULL COMMENT '小程序消息标题，最多64个字节',
  `miniprogram_picurl` varchar(255) DEFAULT NULL COMMENT '小程序消息封面的url',
  `miniprogram_pic_media_id` varchar(255) DEFAULT NULL COMMENT '小程序消息封面的mediaid',
  `miniprogram_appid` varchar(255) DEFAULT NULL COMMENT '小程序appid',
  `miniprogram_page` varchar(255) DEFAULT NULL COMMENT '小程序page路径',
  `status` tinyint(1) DEFAULT '0' COMMENT '发送状态 0发送中 1发送成功  2发送失败',
  `msgid` varchar(255) DEFAULT NULL COMMENT '企业群发消息的id',
  `ctime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of qvmh_qy_et_msg_template
-- ----------------------------

-- ----------------------------
-- Table structure for `qvmh_qy_et_tag_group`
-- ----------------------------
DROP TABLE IF EXISTS `qvmh_qy_et_tag_group`;
CREATE TABLE `qvmh_qy_et_tag_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wid` int(11) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL COMMENT '任务名称',
  `send_to` tinyint(1) DEFAULT '1' COMMENT '群发对象 1全部  2按客户标签 3按成员',
  `send_tag` varchar(500) DEFAULT NULL COMMENT '所选客户标签',
  `send_user` varchar(500) DEFAULT NULL COMMENT '所选成员',
  `text_content` text COMMENT '入群引导语  消息文本内容,最长为4000字节',
  `group_chat_list` text COMMENT '选择的群',
  `filter` tinyint(1) DEFAULT '1' COMMENT '是否过滤在群的客户  1：过滤 2：不过滤',
  `send_msg_userid` text COMMENT '发送用户的id',
  `get_msg_userid` text COMMENT '收到消息的id',
  `join_userid` text COMMENT '入群的id',
  `msg_id` text COMMENT '发送群发的msgid  用于查询数据',
  `update_time` datetime DEFAULT NULL COMMENT '最后更新时间',
  `ctime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of qvmh_qy_et_tag_group
-- ----------------------------

-- ----------------------------
-- Table structure for `qvmh_qy_externalcontact_list`
-- ----------------------------
DROP TABLE IF EXISTS `qvmh_qy_externalcontact_list`;
CREATE TABLE `qvmh_qy_externalcontact_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wid` int(11) DEFAULT NULL,
  `external_userid` varchar(255) DEFAULT NULL COMMENT '外部联系人的userid',
  `name` varchar(255) DEFAULT NULL COMMENT '外部联系人的名称',
  `avatar` varchar(255) DEFAULT NULL COMMENT '外部联系人头像',
  `type` int(11) DEFAULT NULL COMMENT '外部联系人的类型，1表示该外部联系人是微信用户，2表示该外部联系人是企业微信用户',
  `gender` int(11) DEFAULT NULL COMMENT '外部联系人性别 0-未知 1-男性 2-女性',
  `unionid` varchar(255) DEFAULT NULL COMMENT '外部联系人在微信开放平台的唯一身份标识（微信unionid）',
  `position` varchar(255) DEFAULT NULL COMMENT '外部联系人的职位，如果外部企业或用户选择隐藏职位，则不返回，仅当联系人类型是企业微信用户时有此字段',
  `corp_name` varchar(255) DEFAULT NULL COMMENT '外部联系人所在企业的简称，仅当联系人类型是企业微信用户时有此字段',
  `corp_full_name` varchar(255) DEFAULT NULL COMMENT '外部联系人所在企业的主体名称，仅当联系人类型是企业微信用户时有此字段',
  `external_profile` varchar(255) DEFAULT NULL COMMENT '外部联系人的自定义展示信息，可以有多个字段和多种类型，包括文本，网页和小程序',
  `user_id` int(11) DEFAULT NULL COMMENT '员工表id',
  `remark` varchar(255) DEFAULT NULL COMMENT '该成员对此外部联系人的备注',
  `description` varchar(255) DEFAULT NULL COMMENT '该成员对此外部联系人的描述',
  `createtime` varchar(255) DEFAULT NULL COMMENT '该成员添加此外部联系人的时间',
  `tags_info` text COMMENT '该成员添加此外部联系人所打标签详情信息',
  `tags` text COMMENT '该成员添加此外部联系人所打企业标签的id，仅企业设置（type为1）的标签返回',
  `remark_corp_name` varchar(255) DEFAULT NULL COMMENT '该成员对此客户备注的企业名称',
  `remark_mobiles` varchar(255) DEFAULT NULL COMMENT '该成员对此客户备注的手机号码，第三方不可获取',
  `add_way` int(11) DEFAULT NULL COMMENT '该成员添加此客户的来源',
  `oper_userid` varchar(255) DEFAULT NULL COMMENT '发起添加的userid',
  `state` varchar(255) DEFAULT NULL COMMENT '企业自定义的state参数，用于区分客户具体是通过哪个「联系我」添加',
  `custom_information` text COMMENT '该成员自定义客户信息',
  `status` int(11) DEFAULT '0' COMMENT '客户状态 0正常 1员工删除客户 2员工被客户删除',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of qvmh_qy_externalcontact_list
-- ----------------------------

-- ----------------------------
-- Table structure for `qvmh_qy_externalcontact_tag`
-- ----------------------------
DROP TABLE IF EXISTS `qvmh_qy_externalcontact_tag`;
CREATE TABLE `qvmh_qy_externalcontact_tag` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wid` int(11) DEFAULT NULL,
  `group_id` varchar(255) DEFAULT NULL COMMENT '标签组id',
  `group_name` varchar(255) DEFAULT NULL COMMENT '标签组名称',
  `create_time` varchar(255) DEFAULT NULL COMMENT '标签组创建时间',
  `order` int(11) DEFAULT '0' COMMENT '标签组排序的次序值，order值大的排序靠前',
  `deleted` varchar(255) DEFAULT NULL COMMENT '标签组是否已经被删除',
  `tags` longtext COMMENT '标签组内的标签列表',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=50 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of qvmh_qy_externalcontact_tag
-- ----------------------------

-- ----------------------------
-- Table structure for `qvmh_qy_group_welcome_template`
-- ----------------------------
DROP TABLE IF EXISTS `qvmh_qy_group_welcome_template`;
CREATE TABLE `qvmh_qy_group_welcome_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wid` int(11) DEFAULT NULL,
  `template_id` varchar(255) DEFAULT NULL,
  `text_content` text,
  `other_type` tinyint(1) DEFAULT '1' COMMENT '添加其他类型 1无 2图片 3图文 4小程序',
  `image_url` varchar(255) DEFAULT NULL,
  `link_title` varchar(255) DEFAULT NULL,
  `link_picurl` varchar(255) DEFAULT NULL,
  `link_desc` text,
  `link_url` varchar(255) DEFAULT NULL,
  `miniprogram_name` varchar(255) DEFAULT NULL,
  `miniprogram_title` varchar(255) DEFAULT NULL,
  `miniprogram_url` varchar(255) DEFAULT NULL,
  `miniprogram_appid` varchar(255) DEFAULT NULL,
  `miniprogram_page` varchar(255) DEFAULT NULL,
  `ctime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of qvmh_qy_group_welcome_template
-- ----------------------------

-- ----------------------------
-- Table structure for `qvmh_qy_inqunbao`
-- ----------------------------
DROP TABLE IF EXISTS `qvmh_qy_inqunbao`;
CREATE TABLE `qvmh_qy_inqunbao` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wid` int(11) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL COMMENT '渠道名称',
  `users` varchar(255) DEFAULT NULL COMMENT '使用该联系方式的用户userID列表',
  `skip_verify` tinyint(1) DEFAULT '1' COMMENT '自动通过验证 1是 0否',
  `auto_label` tinyint(1) DEFAULT '0' COMMENT '自动打标签 1是 0否',
  `select_label` varchar(255) DEFAULT NULL COMMENT '选中的标签',
  `end_time` varchar(255) DEFAULT NULL COMMENT '活动结束时间戳',
  `qr_valid` tinyint(1) DEFAULT '1' COMMENT '二维码有效期 1立即失效 2 n天后过期',
  `qr_valid_days` int(11) DEFAULT '7' COMMENT '二维码n天后过期',
  `target_number` int(11) DEFAULT '0' COMMENT '目标人数',
  `new_friends` tinyint(1) DEFAULT '0' COMMENT '新好友才能助力 1开启 0关闭',
  `del_friends` tinyint(1) DEFAULT '1' COMMENT '删除员工好友后助力失效 1开启 0关闭',
  `lj_mode` tinyint(1) DEFAULT '1' COMMENT '领奖方式 1联系客服 2兑换链接',
  `lj_lxr` varchar(255) DEFAULT NULL COMMENT '领奖联系员工',
  `lj_qrcode` varchar(255) DEFAULT NULL COMMENT '领奖联系活码',
  `lj_link` varchar(255) DEFAULT NULL COMMENT '兑换链接',
  `poster_type` tinyint(1) DEFAULT '1' COMMENT '1海报 2个人名片',
  `poster_avatar` tinyint(1) DEFAULT '1' COMMENT '1开启 0关闭',
  `poster_nickname` tinyint(1) DEFAULT '1',
  `poster_imgurl` varchar(255) DEFAULT NULL,
  `poster_coordinate` varchar(255) DEFAULT NULL,
  `business_card` varchar(255) DEFAULT NULL COMMENT '个人名片',
  `forward_set` tinyint(1) DEFAULT '1' COMMENT '海报转发 0关闭 1开启（开启可直接复制）',
  `forward_text` text COMMENT '海报转发话术',
  `hy_text_content` text COMMENT '消息文本内容,最长为4000字节',
  `hy_link_title` varchar(255) DEFAULT NULL COMMENT '图文消息标题，最长为128字节',
  `hy_link_desc` text COMMENT '图文消息的描述，最长为512字节',
  `hy_link_picurl` varchar(255) DEFAULT NULL COMMENT '图文消息封面的url',
  `push_staff` tinyint(1) DEFAULT '1' COMMENT '给员工推送 1开启 0关闭',
  `push_customer` tinyint(1) DEFAULT '1' COMMENT '给客户推送 1开启0关闭',
  `push_text_content` text COMMENT '推送消息文本内容',
  `push_two_type` tinyint(1) DEFAULT '1' COMMENT '1图片 2链接',
  `push_image` varchar(255) DEFAULT NULL,
  `push_link_url` varchar(255) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL COMMENT '企业自定义的state参数，用于区分不同的添加渠道',
  `config_id` varchar(255) DEFAULT NULL COMMENT '新增联系方式的配置id',
  `qr_code` varchar(255) DEFAULT NULL COMMENT '联系二维码的URL',
  `invitation_check` tinyint(1) DEFAULT '1',
  `invitation_range` tinyint(1) DEFAULT '1',
  `selected_et` varchar(255) DEFAULT NULL,
  `invitation_text` text,
  `invitationLink_title` varchar(255) DEFAULT NULL,
  `invitationLink_desc` varchar(255) DEFAULT NULL,
  `invitationLink_pic` varchar(255) DEFAULT NULL,
  `ctime` datetime DEFAULT NULL,
  `sex` tinyint(1) DEFAULT '0' COMMENT '0男女不限，1男性 ，2女性',
  `poster_fontstyle` varchar(255) DEFAULT NULL COMMENT '海报昵称文字样式记录 json格式{"left":"162","top":"338","size":"100","color":"red"}',
  `qun_imgurl` varchar(255) DEFAULT NULL,
  `huodong_url` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=165 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of qvmh_qy_inqunbao
-- ----------------------------

-- ----------------------------
-- Table structure for `qvmh_qy_kefu`
-- ----------------------------
DROP TABLE IF EXISTS `qvmh_qy_kefu`;
CREATE TABLE `qvmh_qy_kefu` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `url` varchar(255) NOT NULL COMMENT '客服二维码',
  `mid` int(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Records of qvmh_qy_kefu
-- ----------------------------
INSERT INTO `qvmh_qy_kefu` VALUES ('1', 'https://www.qvmh.cn/static/picture/0ef6919f243e6c83037fb5c596bd2e28.png', '189');

-- ----------------------------
-- Table structure for `qvmh_qy_message_send_config`
-- ----------------------------
DROP TABLE IF EXISTS `qvmh_qy_message_send_config`;
CREATE TABLE `qvmh_qy_message_send_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wid` int(11) DEFAULT NULL,
  `agent_id` varchar(255) DEFAULT NULL COMMENT '应用的唯一标识，用于接口区分不同应用',
  `secret` varchar(255) DEFAULT NULL COMMENT '用于获取access_token',
  `name` varchar(255) DEFAULT NULL COMMENT '企业应用名称',
  `square_logo_url` varchar(255) DEFAULT NULL COMMENT '企业应用方形头像',
  `description` text COMMENT '企业应用详情',
  `ctime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of qvmh_qy_message_send_config
-- ----------------------------

-- ----------------------------
-- Table structure for `qvmh_qy_moments_app_config`
-- ----------------------------
DROP TABLE IF EXISTS `qvmh_qy_moments_app_config`;
CREATE TABLE `qvmh_qy_moments_app_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wid` int(11) DEFAULT NULL,
  `agent_id` varchar(255) DEFAULT NULL COMMENT '应用的唯一标识，用于接口区分不同应用',
  `secret` varchar(255) DEFAULT NULL COMMENT '用于获取access_token',
  `name` varchar(255) DEFAULT NULL COMMENT '企业应用名称',
  `square_logo_url` varchar(255) DEFAULT NULL COMMENT '企业应用方形头像',
  `description` text COMMENT '企业应用详情',
  `ctime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of qvmh_qy_moments_app_config
-- ----------------------------

-- ----------------------------
-- Table structure for `qvmh_qy_moments_user_background`
-- ----------------------------
DROP TABLE IF EXISTS `qvmh_qy_moments_user_background`;
CREATE TABLE `qvmh_qy_moments_user_background` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wid` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `background` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of qvmh_qy_moments_user_background
-- ----------------------------

-- ----------------------------
-- Table structure for `qvmh_qy_moments_user_publish`
-- ----------------------------
DROP TABLE IF EXISTS `qvmh_qy_moments_user_publish`;
CREATE TABLE `qvmh_qy_moments_user_publish` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wid` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `type` tinyint(1) DEFAULT NULL COMMENT '发布类型 1文字 2图片 3视频 4图文',
  `writing` text COMMENT '文字',
  `pics` text COMMENT '图片',
  `video` varchar(255) DEFAULT NULL COMMENT '视频',
  `link_url` varchar(255) DEFAULT NULL COMMENT '图文链接',
  `ctime` varchar(255) DEFAULT NULL COMMENT '发布时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of qvmh_qy_moments_user_publish
-- ----------------------------

-- ----------------------------
-- Table structure for `qvmh_qy_providers_permanent_code`
-- ----------------------------
DROP TABLE IF EXISTS `qvmh_qy_providers_permanent_code`;
CREATE TABLE `qvmh_qy_providers_permanent_code` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wid` int(11) DEFAULT NULL,
  `suite_id` varchar(255) DEFAULT NULL COMMENT '服务商应用id',
  `corpid` varchar(255) DEFAULT NULL COMMENT '授权方企业微信id',
  `permanent_code` varchar(255) DEFAULT NULL COMMENT '企业微信永久授权码',
  `ctime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of qvmh_qy_providers_permanent_code
-- ----------------------------

-- ----------------------------
-- Table structure for `qvmh_qy_quick_reply_group`
-- ----------------------------
DROP TABLE IF EXISTS `qvmh_qy_quick_reply_group`;
CREATE TABLE `qvmh_qy_quick_reply_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wid` int(11) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `sort` int(11) DEFAULT '0',
  `keyid` varchar(50) DEFAULT NULL,
  `ctime` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of qvmh_qy_quick_reply_group
-- ----------------------------

-- ----------------------------
-- Table structure for `qvmh_qy_quick_reply_list`
-- ----------------------------
DROP TABLE IF EXISTS `qvmh_qy_quick_reply_list`;
CREATE TABLE `qvmh_qy_quick_reply_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wid` int(11) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `type` tinyint(1) DEFAULT '1' COMMENT '类型 1文本 2图片 3视频 4文件 5链接',
  `groupid` varchar(300) DEFAULT NULL COMMENT '组分',
  `text_content` text COMMENT '文本内容',
  `pic_path` varchar(255) DEFAULT NULL COMMENT '图片路径',
  `video_path` varchar(255) DEFAULT NULL COMMENT '视频路径',
  `video_name` varchar(255) DEFAULT NULL COMMENT '视频名称',
  `file_path` varchar(255) DEFAULT NULL COMMENT '文件路径',
  `file_name` varchar(255) DEFAULT NULL COMMENT '文件名称',
  `link_url` varchar(255) DEFAULT NULL COMMENT '链接地址',
  `link_title` varchar(255) DEFAULT NULL,
  `link_pic` varchar(255) DEFAULT NULL,
  `link_desc` varchar(255) DEFAULT NULL,
  `ctime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of qvmh_qy_quick_reply_list
-- ----------------------------

-- ----------------------------
-- Table structure for `qvmh_qy_reply_config`
-- ----------------------------
DROP TABLE IF EXISTS `qvmh_qy_reply_config`;
CREATE TABLE `qvmh_qy_reply_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wid` int(11) DEFAULT NULL,
  `agent_id` varchar(255) DEFAULT NULL COMMENT '应用的唯一标识，用于接口区分不同应用',
  `secret` varchar(255) DEFAULT NULL COMMENT '用于获取access_token',
  `name` varchar(255) DEFAULT NULL COMMENT '企业应用名称',
  `square_logo_url` varchar(255) DEFAULT NULL COMMENT '企业应用方形头像',
  `description` text COMMENT '企业应用详情',
  `ctime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of qvmh_qy_reply_config
-- ----------------------------

-- ----------------------------
-- Table structure for `qvmh_qy_user_list`
-- ----------------------------
DROP TABLE IF EXISTS `qvmh_qy_user_list`;
CREATE TABLE `qvmh_qy_user_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wid` int(11) DEFAULT NULL,
  `userid` varchar(255) DEFAULT NULL COMMENT '成员UserID。对应管理端的帐号',
  `name` varchar(255) DEFAULT NULL COMMENT '成员名称',
  `mobile` varchar(255) DEFAULT NULL COMMENT '手机号码',
  `department` varchar(255) DEFAULT NULL COMMENT '成员所属部门id列表',
  `department_name` varchar(255) DEFAULT NULL COMMENT '成员所属部门name列表',
  `order` varchar(255) DEFAULT NULL COMMENT '部门内的排序值，默认为0',
  `position` varchar(255) DEFAULT NULL COMMENT '职务信息',
  `gender` int(11) DEFAULT NULL COMMENT '性别。0表示未定义，1表示男性，2表示女性',
  `email` varchar(255) DEFAULT NULL COMMENT '邮箱',
  `is_leader_in_dept` varchar(255) DEFAULT NULL COMMENT '表示在所在的部门内是否为上级',
  `avatar` varchar(255) DEFAULT NULL COMMENT '头像url',
  `thumb_avatar` varchar(255) DEFAULT NULL COMMENT '头像缩略图url',
  `telephone` varchar(255) DEFAULT NULL COMMENT '座机。',
  `alias` varchar(255) DEFAULT NULL COMMENT '别名',
  `extattr` varchar(255) DEFAULT NULL COMMENT '扩展属性',
  `status` int(11) DEFAULT NULL COMMENT '激活状态: 1=已激活，2=已禁用，4=未激活，5=退出企业。',
  `qr_code` varchar(255) DEFAULT NULL COMMENT '员工个人二维码',
  `external_profile` varchar(255) DEFAULT NULL COMMENT '成员对外属性',
  `external_position` varchar(255) DEFAULT NULL COMMENT '对外职务',
  `address` varchar(255) DEFAULT NULL COMMENT '地址',
  `open_userid` varchar(255) DEFAULT NULL COMMENT '全局唯一。对于同一个服务商，不同应用获取到企业内同一个成员的open_userid是相同的，最多64个字节。仅第三方应用可获取',
  `main_department` int(11) DEFAULT NULL COMMENT '主部门',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '是否删除 0未删除 1执行删除',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of qvmh_qy_user_list
-- ----------------------------

-- ----------------------------
-- Table structure for `qvmh_qy_wechat_config`
-- ----------------------------
DROP TABLE IF EXISTS `qvmh_qy_wechat_config`;
CREATE TABLE `qvmh_qy_wechat_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wid` int(11) NOT NULL,
  `corp_name` varchar(255) DEFAULT NULL COMMENT '企业名称',
  `corp_id` varchar(255) DEFAULT NULL COMMENT '企业ID',
  `externalcontact_secret` varchar(255) DEFAULT NULL COMMENT '外部联系人管理secret',
  `user_secret` varchar(255) DEFAULT NULL COMMENT '通讯录管理secret',
  `externalcontact_token` varchar(255) DEFAULT NULL,
  `externalcontact_aes` varchar(255) DEFAULT NULL,
  `user_tokent` varchar(255) DEFAULT NULL,
  `user_aes` varchar(255) DEFAULT NULL,
  `ctime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of qvmh_qy_wechat_config
-- ----------------------------

-- ----------------------------
-- Table structure for `qvmh_qy_welcome_msg_list`
-- ----------------------------
DROP TABLE IF EXISTS `qvmh_qy_welcome_msg_list`;
CREATE TABLE `qvmh_qy_welcome_msg_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wid` int(11) DEFAULT NULL,
  `type` tinyint(1) DEFAULT '1' COMMENT '1通用 2企业部分成员',
  `users` varchar(255) DEFAULT NULL COMMENT '使用该欢迎语 的成员userID列表',
  `text_content` text,
  `other_type` tinyint(1) DEFAULT '1' COMMENT '添加其他类型 1无 2图片 3图文 4小程序',
  `image_url` varchar(255) DEFAULT NULL,
  `link_title` varchar(255) DEFAULT NULL,
  `link_picurl` varchar(255) DEFAULT NULL,
  `link_desc` text,
  `link_url` varchar(255) DEFAULT NULL,
  `miniprogram_name` varchar(255) DEFAULT NULL,
  `miniprogram_title` varchar(255) DEFAULT NULL,
  `miniprogram_url` varchar(255) DEFAULT NULL,
  `miniprogram_appid` varchar(255) DEFAULT NULL,
  `miniprogram_page` varchar(255) DEFAULT NULL,
  `ctime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of qvmh_qy_welcome_msg_list
-- ----------------------------

-- ----------------------------
-- Table structure for `qvmh_seller_account`
-- ----------------------------
DROP TABLE IF EXISTS `qvmh_seller_account`;
CREATE TABLE `qvmh_seller_account` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wid` int(11) DEFAULT NULL,
  `username` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `ctime` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of qvmh_seller_account
-- ----------------------------

-- ----------------------------
-- Table structure for `qvmh_sms_buy_record`
-- ----------------------------
DROP TABLE IF EXISTS `qvmh_sms_buy_record`;
CREATE TABLE `qvmh_sms_buy_record` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL,
  `ctime` varchar(20) NOT NULL,
  `buy_num` int(11) NOT NULL,
  `total_price` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of qvmh_sms_buy_record
-- ----------------------------

-- ----------------------------
-- Table structure for `qvmh_sms_send_record`
-- ----------------------------
DROP TABLE IF EXISTS `qvmh_sms_send_record`;
CREATE TABLE `qvmh_sms_send_record` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) DEFAULT NULL,
  `content` varchar(255) DEFAULT NULL,
  `tel` varchar(20) DEFAULT NULL,
  `ctime` varchar(20) DEFAULT NULL,
  `status` tinyint(2) DEFAULT NULL,
  `return_code` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=26 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of qvmh_sms_send_record
-- ----------------------------

-- ----------------------------
-- Table structure for `qvmh_user`
-- ----------------------------
DROP TABLE IF EXISTS `qvmh_user`;
CREATE TABLE `qvmh_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `un` varchar(200) NOT NULL COMMENT '用户名',
  `pwd` varchar(32) DEFAULT '',
  `email` varchar(50) DEFAULT NULL COMMENT '邮箱',
  `telephone` varchar(20) DEFAULT NULL COMMENT '电话',
  `qq` int(11) DEFAULT NULL,
  `logtimes` bigint(20) DEFAULT '0' COMMENT '登录次数 每登一次加一',
  `isadmin` tinyint(1) DEFAULT NULL,
  `rtime` datetime DEFAULT NULL,
  `level_id` tinyint(1) DEFAULT '1' COMMENT '1:普通用户2:普通会员3:白金会员4：钻石会员',
  `mendtime` datetime DEFAULT NULL,
  `next_level_id` tinyint(1) DEFAULT '1',
  `next_mendtime` datetime DEFAULT NULL,
  `qqopenid` varchar(255) DEFAULT NULL,
  `l_sheng` int(11) DEFAULT NULL,
  `l_shi` int(11) DEFAULT NULL,
  `l_xianqu` int(11) DEFAULT NULL,
  `addr` varchar(255) DEFAULT NULL,
  `agid` int(11) unsigned DEFAULT '0' COMMENT '代理id',
  `cwid` int(11) DEFAULT '11' COMMENT '财务id',
  `kfid` int(11) DEFAULT '0' COMMENT '客服id',
  `rip` varchar(32) DEFAULT NULL,
  `isstop` tinyint(1) DEFAULT '0',
  `ygid` int(11) DEFAULT '0' COMMENT '员工ID',
  `jingli` varchar(50) DEFAULT NULL,
  `lxr` varchar(50) DEFAULT NULL,
  `tel` varchar(50) DEFAULT NULL,
  `isdirect` tinyint(1) DEFAULT '1' COMMENT '是否直接客户',
  `isfromnet` tinyint(1) DEFAULT '1' COMMENT ' 是否网络注册',
  `pid` int(11) DEFAULT '0' COMMENT '上级用户id',
  `theme` varchar(20) DEFAULT NULL,
  `xiane` smallint(6) DEFAULT '1' COMMENT '账户限额',
  `surplus_sms` int(11) DEFAULT '0' COMMENT '剩余短信条数',
  `ispwdcg` tinyint(1) DEFAULT '1',
  `smsuser` varchar(50) DEFAULT NULL COMMENT '短信平台用户',
  `smspassword` varchar(20) DEFAULT NULL COMMENT '短信平台密码',
  `pagetype` int(50) DEFAULT NULL,
  `ttype` int(50) DEFAULT NULL COMMENT '0',
  `balance` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_un` (`un`)
) ENGINE=MyISAM AUTO_INCREMENT=128 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of qvmh_user
-- ----------------------------
INSERT INTO `qvmh_user` VALUES ('51', 'admin', '0192023a7bbd73250516f069df18b500', null, '18686868686', null, '0', null, '2017-08-14 09:23:06', '5', '2095-03-29 16:17:14', '3', '2023-03-29 16:17:14', null, '43', '69', '72', null, '189', '11', '0', '106.46.46.255', '0', '0', null, '123', null, '1', '0', '0', null, '1', '75', '1', null, null, '2', null, '0.01');

-- ----------------------------
-- Table structure for `qvmh_user_agency`
-- ----------------------------
DROP TABLE IF EXISTS `qvmh_user_agency`;
CREATE TABLE `qvmh_user_agency` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `un` varchar(20) NOT NULL COMMENT '用户名',
  `pwd` varchar(32) DEFAULT '',
  `key_word` varchar(100) DEFAULT NULL,
  `describe` varchar(255) DEFAULT NULL,
  `company_name` varchar(100) DEFAULT NULL,
  `company_address` varchar(255) DEFAULT NULL,
  `record_number` varchar(100) DEFAULT NULL,
  `qr_code` varchar(255) DEFAULT 'https://xcx188.oss-cn-hangzhou.aliyuncs.com/guanzhu.jpg',
  `email` varchar(50) DEFAULT NULL COMMENT '邮箱',
  `telephone` varchar(20) DEFAULT NULL COMMENT '电话',
  `qq` int(13) unsigned DEFAULT NULL,
  `logtimes` bigint(20) DEFAULT '0' COMMENT '登录次数 每登一次加一',
  `isadmin` tinyint(1) DEFAULT '0' COMMENT '是否是管理员',
  `yue` decimal(10,2) DEFAULT '0.00' COMMENT '余额',
  `logo` varchar(255) DEFAULT 'https://xcx188.oss-cn-hangzhou.aliyuncs.com/logo.png',
  `domain` varchar(255) DEFAULT NULL,
  `webname` varchar(255) DEFAULT '企微魔盒',
  `webtitle` varchar(255) DEFAULT NULL,
  `kfcode` varchar(1024) DEFAULT NULL,
  `pid` int(11) unsigned DEFAULT NULL COMMENT '开通人员id',
  `rtime` datetime DEFAULT NULL,
  `isyg` tinyint(1) DEFAULT '0',
  `dljb` tinyint(4) NOT NULL DEFAULT '1',
  `l_sheng` int(11) DEFAULT '1502',
  `l_shi` int(11) DEFAULT '1620',
  `name` varchar(50) DEFAULT NULL,
  `isstop` tinyint(1) DEFAULT '0',
  `level` int(11) DEFAULT '1',
  `cwid` int(11) DEFAULT '0' COMMENT '财务id',
  `kfid` int(11) DEFAULT '0' COMMENT '客服id',
  `addr` varchar(255) DEFAULT NULL,
  `jingli` varchar(50) DEFAULT NULL,
  `lxr` varchar(50) DEFAULT NULL,
  `tel` varchar(50) DEFAULT NULL,
  `isdirect` tinyint(4) DEFAULT '1',
  `weiurl` varchar(255) DEFAULT NULL,
  `ispwdcg` tinyint(1) DEFAULT '1',
  `app_id` varchar(255) DEFAULT NULL COMMENT '开放平台配置appid',
  `app_secret` varchar(255) DEFAULT NULL COMMENT '开放平台配置appsecret',
  `token` varchar(255) DEFAULT NULL COMMENT '开放平台配置token',
  `encoding_aes_key` varchar(255) DEFAULT NULL COMMENT '开放平台配置encoding_aes_key',
  `config_domain` varchar(255) DEFAULT NULL COMMENT '给授权方小程序设置的白名单域名',
  `auth_type` tinyint(1) DEFAULT '1' COMMENT '授权模式（1.默认2.借用）',
  `auth_url` varchar(255) DEFAULT NULL COMMENT '借用授权域名',
  `template_id` varchar(255) DEFAULT NULL COMMENT '绑定的template_id',
  `recharge_appid` varchar(255) DEFAULT NULL,
  `recharge_mchid` varchar(255) DEFAULT NULL,
  `recharge_key` varchar(255) DEFAULT NULL,
  `is_open_collect` int(11) DEFAULT '1',
  `userlevel` int(11) DEFAULT '1',
  `userdays` int(11) DEFAULT '15',
  `message_id` varchar(100) DEFAULT NULL,
  `message_pwd` varchar(100) DEFAULT NULL,
  `message_sign` varchar(255) DEFAULT NULL,
  `sms_price` double(10,2) DEFAULT '0.00' COMMENT '短信价格',
  `oss_status` tinyint(1) DEFAULT NULL COMMENT '是否开启oss存储',
  `oss_id` varchar(100) DEFAULT NULL COMMENT 'oss id',
  `oss_secret` varchar(100) DEFAULT NULL COMMENT 'oss secret',
  `oss_endpoint` varchar(100) DEFAULT NULL COMMENT 'oss 访问域名',
  `sms_balance` double(10,2) DEFAULT NULL COMMENT '短信余额',
  `register_check` tinyint(1) DEFAULT '1' COMMENT '验证码功能（1开启，2关闭）',
  `switch_pc` tinyint(1) DEFAULT '1' COMMENT '是否开启pc页面（1开，2关）',
  `copyright` varchar(255) DEFAULT '' COMMENT '小程序版权',
  `bucket_name` varchar(100) DEFAULT NULL,
  `client_id` varchar(255) DEFAULT NULL,
  `client_secret` varchar(255) DEFAULT NULL,
  `taoshu` int(11) DEFAULT '0' COMMENT '代理商套数',
  `user_pc` int(11) DEFAULT NULL,
  `domain_set` tinyint(1) DEFAULT '1' COMMENT '小程序接口设置（1浏览器地址，2配置文件地址）',
  `qiniu_status` tinyint(1) DEFAULT NULL COMMENT '是否开启七牛存储',
  `qiniu_key` varchar(100) DEFAULT NULL COMMENT '七牛key',
  `qiniu_secret` varchar(100) DEFAULT NULL,
  `qiniu_domain` varchar(100) DEFAULT NULL,
  `qiniu_bucket_name` varchar(100) DEFAULT NULL,
  `bd_client_id` varchar(255) DEFAULT NULL COMMENT '百度第三方平台ID',
  `bd_key` varchar(255) DEFAULT NULL,
  `bd_token` varchar(255) DEFAULT NULL,
  `bd_aes_key` varchar(255) DEFAULT NULL COMMENT '百度第三方ase_key',
  `bd_config_domain` varchar(255) DEFAULT NULL,
  `bd_auth_type` tinyint(1) DEFAULT '1' COMMENT '授权模式（1.默认2.借用）',
  `bd_auth_url` varchar(255) DEFAULT NULL COMMENT '借用授权域名',
  `bd_template_id` varchar(255) DEFAULT NULL,
  `app_auth` varchar(255) DEFAULT NULL COMMENT '小程序权限',
  `message_td` tinyint(3) NOT NULL DEFAULT '1' COMMENT '官方通道',
  PRIMARY KEY (`id`,`dljb`)
) ENGINE=MyISAM AUTO_INCREMENT=379 DEFAULT CHARSET=utf8 COMMENT='代理用户表';

-- ----------------------------
-- Records of qvmh_user_agency
-- ----------------------------
INSERT INTO `qvmh_user_agency` VALUES ('189', 'admin', '0192023a7bbd73250516f069df18b500', null, null, null, null, null, 'https://xcx188.oss-cn-hangzhou.aliyuncs.com/guanzhu.jpg', null, null, null, '0', '1', '98953149.00', 'https://xcx188.oss-cn-hangzhou.aliyuncs.com/logo.png', 'vip.qvmh.cn', '企微魔盒', null, '', '1', null, '1', '0', '1502', '1620', '系统管理员', '0', null, '0', '0', null, null, null, null, '1', 'vip.qvmh.cn', '1', '', '', '', null, null, '2', '', null, '', '', '', '1', '1', '15', '', '', '', '0.10', '0', null, null, null, '4.70', '1', '2', null, null, null, null, '0', '0', '1', '0', null, null, null, null, null, null, null, null, null, '2', null, null, null, '1');

-- ----------------------------
-- Table structure for `qvmh_user_agency_sms`
-- ----------------------------
DROP TABLE IF EXISTS `qvmh_user_agency_sms`;
CREATE TABLE `qvmh_user_agency_sms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` varchar(255) DEFAULT NULL,
  `accessKeyId` varchar(255) DEFAULT NULL,
  `accessKeySecret` varchar(255) DEFAULT NULL,
  `signName` varchar(255) DEFAULT NULL,
  `templateCodes` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of qvmh_user_agency_sms
-- ----------------------------

-- ----------------------------
-- Table structure for `qvmh_user_prices`
-- ----------------------------
DROP TABLE IF EXISTS `qvmh_user_prices`;
CREATE TABLE `qvmh_user_prices` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) DEFAULT NULL,
  `price` varchar(255) DEFAULT NULL,
  `isadmin` int(11) DEFAULT '0' COMMENT '是否是管理员',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of qvmh_user_prices
-- ----------------------------
INSERT INTO `qvmh_user_prices` VALUES ('1', '189', '{\"1\":\"0\",\"2\":\"2400\",\"3\":\"4800\",\"4\":\"7200\",\"5\":\"9600\",\"6\":\"12000\",\"7\":\"12000\",\"8\":\"12000\"}', '1');

-- ----------------------------
-- Table structure for `qvmh_user_recharge_record`
-- ----------------------------
DROP TABLE IF EXISTS `qvmh_user_recharge_record`;
CREATE TABLE `qvmh_user_recharge_record` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `openid` varchar(255) NOT NULL,
  `money` double NOT NULL,
  `recharge_time` varchar(255) NOT NULL,
  `out_trade_no` varchar(255) NOT NULL,
  `transaction_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of qvmh_user_recharge_record
-- ----------------------------

-- ----------------------------
-- Table structure for `qvmh_weidogsadminyg_check`
-- ----------------------------
DROP TABLE IF EXISTS `qvmh_weidogsadminyg_check`;
CREATE TABLE `qvmh_weidogsadminyg_check` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) DEFAULT NULL COMMENT '管理员/代理商 用户ID',
  `typid` bigint(20) DEFAULT NULL COMMENT '各项类别: 员工 级别',
  `nopages` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of qvmh_weidogsadminyg_check
-- ----------------------------

-- ----------------------------
-- Table structure for `qvmh_weidogsadmin_check`
-- ----------------------------
DROP TABLE IF EXISTS `qvmh_weidogsadmin_check`;
CREATE TABLE `qvmh_weidogsadmin_check` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `typ` tinyint(1) DEFAULT NULL COMMENT '权限类别 1员工 2 代理 3特殊',
  `typid` bigint(20) DEFAULT NULL COMMENT '各项类别: 员工 代理 用户ID等等 见fun',
  `nopages` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of qvmh_weidogsadmin_check
-- ----------------------------
INSERT INTO `qvmh_weidogsadmin_check` VALUES ('1', '1', '1', null);
INSERT INTO `qvmh_weidogsadmin_check` VALUES ('2', '2', '1', null);
INSERT INTO `qvmh_weidogsadmin_check` VALUES ('3', '2', '2', null);
INSERT INTO `qvmh_weidogsadmin_check` VALUES ('4', '1', '2', null);
INSERT INTO `qvmh_weidogsadmin_check` VALUES ('5', '1', '3', null);
INSERT INTO `qvmh_weidogsadmin_check` VALUES ('6', '1', '7', null);

-- ----------------------------
-- Table structure for `qvmh_yg`
-- ----------------------------
DROP TABLE IF EXISTS `qvmh_yg`;
CREATE TABLE `qvmh_yg` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wid` int(11) DEFAULT NULL,
  `username` varchar(100) DEFAULT NULL,
  `password` varchar(32) DEFAULT '',
  `authority` text COMMENT '权限json',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of qvmh_yg
-- ----------------------------

-- ----------------------------
-- Table structure for `user_linshi`
-- ----------------------------
DROP TABLE IF EXISTS `user_linshi`;
CREATE TABLE `user_linshi` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(100) NOT NULL,
  `token` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of user_linshi
-- ----------------------------
