## Types of changes

<!-- Please place an `x` in all [ ] that apply: -->

This PR contains a:

- [ ] **bugfix**
- [ ] new **feature**
- [ ] **code refactor**
- [ ] **test update** <!-- if bug or feature is checked, this should be too -->
- [ ] **typo fix**
- [ ] **docs change**
- [ ] **breaking change** <!-- fix or feature that change existing functionality -->

## Motivation / Use-Case

<!--
  Please explain the motivation or use-case for your change.
  What existing problem does the PR solve?
  If this PR addresses an issue, please link to the issue.
-->

## Breaking Changes

<!--
  If this PR introduces a breaking change, please describe the impact and a
  migration path for existing applications.
-->

## Additional Info

---

## Checklist

<!-- Go over all the following points, and place an `x` in all the boxes that apply. -->

- [ ] My code follows the code style of this project.
- [ ] My change requires a change to the documentation.
- [ ] I have updated the documentation accordingly.
- [ ] I have updated the **CHANGELOG.md**.
- [ ] I have read the **CONTRIBUTING** document.
- [ ] I have added tests to cover my changes.
- [ ] All new and existing tests passed.

## Appreciation for the useful project

- [ ] Do not forget to give a star ⭐
