<?php

namespace Wanglelecc\Laracms\Providers;

use Illuminate\Support\Facades\Route;
use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;

class RouteServiceProvider extends ServiceProvider
{
    /**
     * This namespace is applied to your controller routes.
     *
     * In addition, it is set as the URL generator's root namespace.
     *
     * @var string
     */
    protected $namespace = 'Wanglelecc\Laracms\Http\Controllers';

    /**
     * Define your route model bindings, pattern filters, etc.
     *
     * @return void
     */
    public function boot()
    {
        Route::bind('safePage',function($value){ return \Wanglelecc\Laracms\Models\Page::show($value); });
        Route::bind('safeArticle',function($value){ return \Wanglelecc\Laracms\Models\Article::show( $value); });
        Route::bind('articleCategory',function($value){ return \Wanglelecc\Laracms\Models\Category::show($value, 'article'); });
        Route::bind('safeWechat',function($value){ return \Wanglelecc\Laracms\Models\Wechat::where('object_id', $value)->first(); });

        parent::boot();
    }

    /**
     * Define the routes for the application.
     *
     * @return void
     */
    public function map()
    {
        $this->mapApiRoutes();

        $this->mapWebRoutes();

        //
    }

    /**
     * Define the "web" routes for the application.
     *
     * These routes all receive session state, CSRF protection, etc.
     *
     * @return void
     */
    protected function mapWebRoutes()
    {
        Route::middleware('web')
             ->namespace($this->namespace)
             ->group(__DIR__.'/../../routes/web.php');
    }

    /**
     * Define the "api" routes for the application.
     *
     * These routes are typically stateless.
     *
     * @return void
     */
    protected function mapApiRoutes()
    {
        Route::prefix('api')
             ->middleware('api')
             ->namespace($this->namespace)
             ->group(__DIR__.'/../../routes/api.php');
    }
}
