/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.enhancement.cglib;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.NoOp;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.config.java.core.AutoBeanMethodProcessor;
import org.springframework.config.java.core.BeanMethodReturnValueProcessor;
import org.springframework.config.java.core.BeanNameTrackingDefaultListableBeanFactory;
import org.springframework.config.java.core.ExternalBeanMethodProcessor;
import org.springframework.config.java.core.ExternalValueMethodProcessor;
import org.springframework.config.java.core.MethodBeanWrapper;
import org.springframework.config.java.core.ScopedProxyMethodProcessor;
import org.springframework.config.java.core.StandardBeanMethodProcessor;
import org.springframework.config.java.enhancement.ConfigurationEnhancer;
import org.springframework.config.java.enhancement.cglib.BeanMethodMethodInterceptor;
import org.springframework.config.java.enhancement.cglib.ExternalBeanMethodMethodInterceptor;
import org.springframework.config.java.enhancement.cglib.ExternalValueMethodMethodInterceptor;
import org.springframework.config.java.enhancement.cglib.ScopedProxyBeanMethodMethodInterceptor;
import org.springframework.config.java.naming.BeanNamingStrategy;
import org.springframework.config.java.valuesource.ValueSource;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CglibConfigurationEnhancer
implements ConfigurationEnhancer {
    private static final CallbackFilter BEAN_CREATION_METHOD_CALLBACK_FILTER = new CallbackFilter(){

        public int accept(Method candidateMethod) {
            if (ScopedProxyMethodProcessor.isScopedProxyMethod(candidateMethod)) {
                return 3;
            }
            if (StandardBeanMethodProcessor.isBeanCreationMethod(candidateMethod)) {
                return 1;
            }
            if (ExternalBeanMethodProcessor.isExternalBeanCreationMethod(candidateMethod) || AutoBeanMethodProcessor.isAutoBeanCreationMethod(candidateMethod)) {
                return 2;
            }
            if (ExternalValueMethodProcessor.isExternalValueCreationMethod(candidateMethod)) {
                return 4;
            }
            return 0;
        }
    };
    private static final Class<?>[] CALLBACK_TYPES = new Class[]{NoOp.class, BeanMethodMethodInterceptor.class, ExternalBeanMethodMethodInterceptor.class, ScopedProxyBeanMethodMethodInterceptor.class, ExternalValueMethodMethodInterceptor.class};
    private static final int NO_OP_CALLBACK_INDEX = 0;
    private static final int BEAN_CALLBACK_INDEX = 1;
    private static final int EXTERNAL_BEAN_CALLBACK_INDEX = 2;
    private static final int EXTERNAL_PROPERTY_CALLBACK_INDEX = 4;
    private static final int SCOPED_PROXY_CALLBACK_INDEX = 3;
    private final Callback[] callbacks;

    public CglibConfigurationEnhancer(ConfigurableListableBeanFactory owningBeanFactory, BeanNameTrackingDefaultListableBeanFactory childFactory, BeanNamingStrategy beanNamingStrategy, List<BeanMethodReturnValueProcessor> returnValueProcessors, ValueSource valueSource) {
        Assert.notNull((Object)owningBeanFactory, (String)"owningBeanFactory is required");
        Assert.notNull((Object)((Object)childFactory), (String)"childFactory is required");
        Assert.notNull((Object)beanNamingStrategy, (String)"beanNamingStrategy is required");
        Assert.notNull((Object)valueSource, (String)"valueSource is required");
        MethodBeanWrapper beanWrapper = new MethodBeanWrapper((BeanFactory)owningBeanFactory, childFactory, returnValueProcessors);
        ExternalValueMethodProcessor evmp = new ExternalValueMethodProcessor(valueSource);
        ExternalBeanMethodProcessor ebmp = new ExternalBeanMethodProcessor((BeanFactory)owningBeanFactory, beanNamingStrategy);
        StandardBeanMethodProcessor rbmp = new StandardBeanMethodProcessor(owningBeanFactory, childFactory, beanNamingStrategy, beanWrapper);
        ScopedProxyMethodProcessor spmp = new ScopedProxyMethodProcessor(rbmp);
        this.callbacks = new Callback[]{NoOp.INSTANCE, new BeanMethodMethodInterceptor(rbmp), new ExternalBeanMethodMethodInterceptor(ebmp), new ScopedProxyBeanMethodMethodInterceptor(spmp, new BeanMethodMethodInterceptor(rbmp)), new ExternalValueMethodMethodInterceptor(evmp)};
    }

    @Override
    public <T> Class<? extends T> enhanceConfiguration(Class<T> configurationClass) {
        Assert.notNull(configurationClass, (String)"configuration class required");
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(configurationClass);
        enhancer.setUseFactory(false);
        enhancer.setCallbackFilter(BEAN_CREATION_METHOD_CALLBACK_FILTER);
        enhancer.setCallbackTypes((Class[])CALLBACK_TYPES);
        Class configurationSubclass = enhancer.createClass();
        Enhancer.registerCallbacks((Class)configurationSubclass, (Callback[])this.callbacks);
        return configurationSubclass.asSubclass(configurationClass);
    }

    public static void validateSuitabilityForEnhancement(Class<?> configurationClass) {
        if (Modifier.isFinal(configurationClass.getModifiers())) {
            throw new IllegalArgumentException(String.format("%s is not enhanceable: classes may not be declared final", configurationClass.getName()));
        }
    }
}

