/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.core;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import org.aopalliance.aop.Advice;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.interceptor.ExposeInvocationInterceptor;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.config.java.annotation.Bean;
import org.springframework.config.java.core.BeanMethodReturnValueProcessor;
import org.springframework.config.java.core.BeanNameTrackingDefaultListableBeanFactory;
import org.springframework.config.java.core.EnhancerMethodInvoker;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodBeanWrapper {
    private final BeanFactory owningBeanFactory;
    private final BeanNameTrackingDefaultListableBeanFactory childTrackingFactory;
    private final Collection<BeanMethodReturnValueProcessor> returnValueProcessors;

    public MethodBeanWrapper(BeanFactory owningBeanFactory, BeanNameTrackingDefaultListableBeanFactory childTrackingFactory, Collection<BeanMethodReturnValueProcessor> returnValueProcessors) {
        this.owningBeanFactory = owningBeanFactory;
        this.returnValueProcessors = returnValueProcessors;
        this.childTrackingFactory = childTrackingFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object wrapResult(String beanName, EnhancerMethodInvoker invoker) throws Throwable {
        Assert.hasText((String)beanName, (String)"a non-empty beanName is required");
        Assert.notNull((Object)invoker, (String)"a non-null invoker is required");
        String lastRequestedBeanName = this.childTrackingFactory.lastRequestedBeanName();
        boolean newBeanRequested = lastRequestedBeanName == null || beanName.equals(lastRequestedBeanName);
        try {
            if (newBeanRequested) {
                this.childTrackingFactory.recordRequestForBeanName(beanName);
            }
            Object originallyCreatedBean = null;
            BeanDefinition beanDef = null;
            beanDef = this.childTrackingFactory.containsBeanDefinition(beanName) ? this.childTrackingFactory.getBeanDefinition(beanName) : ((BeanDefinitionRegistry)this.owningBeanFactory).getBeanDefinition(beanName);
            if (beanDef.getAttribute("org.springframework.config.java") == null) {
                originallyCreatedBean = this.owningBeanFactory.getBean(beanName);
            }
            if (originallyCreatedBean == null) {
                originallyCreatedBean = invoker.invokeOriginalClass();
            }
            if (ClassUtils.isPresent((String)"org.springframework.aop.TargetSource")) {
                Object object = new ProxyHelper().proxyIfAppropriate(originallyCreatedBean, invoker.getMethod());
                return object;
            }
            Object object = originallyCreatedBean;
            return object;
        }
        finally {
            if (newBeanRequested) {
                this.childTrackingFactory.pop();
            }
        }
    }

    private class ProxyHelper {
        private ProxyHelper() {
        }

        public Object proxyIfAppropriate(Object originallyCreatedBean, Method method) {
            if (!MethodBeanWrapper.this.returnValueProcessors.isEmpty()) {
                ProxyFactory pf = new ProxyFactory(originallyCreatedBean);
                if (this.shouldProxyBeanCreationMethod(method)) {
                    pf.setProxyTargetClass(true);
                } else {
                    pf.setInterfaces(new Class[]{method.getReturnType()});
                    pf.setProxyTargetClass(false);
                }
                boolean customized = false;
                for (BeanMethodReturnValueProcessor processor : MethodBeanWrapper.this.returnValueProcessors) {
                    customized = customized || processor.processBeanMethodReturnValue((BeanFactory)MethodBeanWrapper.this.childTrackingFactory, originallyCreatedBean, method, pf);
                }
                if (customized || pf.getAdvisors().length > 0) {
                    pf.addAdvice(0, (Advice)ExposeInvocationInterceptor.INSTANCE);
                    if (pf.isProxyTargetClass() && Modifier.isFinal(method.getReturnType().getModifiers())) {
                        throw new BeanDefinitionStoreException(method + " is eligible for proxying target class " + "but return type " + method.getReturnType().getName() + " is final");
                    }
                    return pf.getProxy();
                }
            }
            return originallyCreatedBean;
        }

        private boolean shouldProxyBeanCreationMethod(Method m) {
            Bean bean = (Bean)AnnotationUtils.findAnnotation((Method)m, Bean.class);
            return !m.getReturnType().isInterface() || bean.autowire().isAutowire();
        }
    }
}

