/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.trace.Tracer;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class EscapeTokenizer {
    private int bracesLevel = 0;
    private boolean emittingEscapeCode = false;
    private boolean inComment = false;
    private boolean inQuotes = false;
    private char lastChar = '\u0000';
    private char lastLastChar = '\u0000';
    private int pos = 0;
    private char quoteChar = '\u0000';
    private boolean sawVariableUse = false;
    private String source = null;
    private int sourceLength = 0;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;

    public EscapeTokenizer(String s) {
        this.source = s;
        this.sourceLength = s.length();
        this.pos = 0;
    }

    public synchronized boolean hasMoreTokens() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        boolean bl = this.pos < this.sourceLength;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl), joinPoint);
        return bl;
    }

    public synchronized String nextToken() {
        String string;
        JoinPoint joinPoint;
        block26: {
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
            Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
            StringBuffer tokenBuf = new StringBuffer();
            if (this.emittingEscapeCode) {
                tokenBuf.append("{");
                this.emittingEscapeCode = false;
            }
            while (this.pos < this.sourceLength) {
                block29: {
                    char c;
                    block30: {
                        block27: {
                            block28: {
                                c = this.source.charAt(this.pos);
                                if (!this.inQuotes && c == '@') {
                                    this.sawVariableUse = true;
                                }
                                if (c != '\'' && c != '\"') break block27;
                                if (!this.inQuotes || c != this.quoteChar || this.pos + 1 >= this.sourceLength || this.source.charAt(this.pos + 1) != this.quoteChar) break block28;
                                tokenBuf.append(this.quoteChar);
                                tokenBuf.append(this.quoteChar);
                                ++this.pos;
                                break block29;
                            }
                            if (this.lastChar != '\\') {
                                if (this.inQuotes) {
                                    if (this.quoteChar == c) {
                                        this.inQuotes = false;
                                    }
                                } else {
                                    this.inQuotes = true;
                                    this.quoteChar = c;
                                }
                            } else if (this.lastLastChar == '\\') {
                                if (this.inQuotes) {
                                    if (this.quoteChar == c) {
                                        this.inQuotes = false;
                                    }
                                } else {
                                    this.inQuotes = true;
                                    this.quoteChar = c;
                                }
                            }
                            tokenBuf.append(c);
                            break block30;
                        }
                        if (c == '-') {
                            if (this.lastChar == '-' && this.lastLastChar != '\\' & !this.inQuotes) {
                                this.inComment = true;
                            }
                            tokenBuf.append(c);
                        } else if (c == '\n' || c == '\r') {
                            this.inComment = false;
                            tokenBuf.append(c);
                        } else if (c == '{') {
                            if (this.inQuotes || this.inComment) {
                                tokenBuf.append(c);
                            } else {
                                ++this.bracesLevel;
                                if (this.bracesLevel == 1) {
                                    ++this.pos;
                                    this.emittingEscapeCode = true;
                                    string = tokenBuf.toString();
                                    break block26;
                                }
                                tokenBuf.append(c);
                            }
                        } else if (c == '}') {
                            tokenBuf.append(c);
                            if (!this.inQuotes && !this.inComment) {
                                this.lastChar = c;
                                --this.bracesLevel;
                                if (this.bracesLevel == 0) {
                                    ++this.pos;
                                    string = tokenBuf.toString();
                                    break block26;
                                }
                            }
                        } else {
                            tokenBuf.append(c);
                        }
                    }
                    this.lastLastChar = this.lastChar;
                    this.lastChar = c;
                }
                ++this.pos;
            }
            string = tokenBuf.toString();
        }
        String string2 = string;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(string2, joinPoint);
        return string;
    }

    boolean sawVariableUse() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        boolean bl = this.sawVariableUse;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl), joinPoint);
        return bl;
    }

    static {
        Factory factory = new Factory("EscapeTokenizer.java", Class.forName("com.mysql.jdbc.EscapeTokenizer"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-hasMoreTokens-com.mysql.jdbc.EscapeTokenizer----boolean-"), 82);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-nextToken-com.mysql.jdbc.EscapeTokenizer----java.lang.String-"), 91);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-sawVariableUse-com.mysql.jdbc.EscapeTokenizer----boolean-"), 192);
    }
}

