/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.util.fs;

import com.opensymphony.xwork2.FileManager;
import com.opensymphony.xwork2.util.fs.FileRevision;
import com.opensymphony.xwork2.util.fs.JarEntryRevision;
import com.opensymphony.xwork2.util.fs.Revision;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFileManager
implements FileManager {
    private static Logger LOG = LoggerFactory.getLogger(DefaultFileManager.class);
    private static final Pattern JAR_PATTERN = Pattern.compile("^(jar:|wsjar:|zip:|vfsfile:|code-source:)?(file:)?(.*?)(\\!/|\\.jar/)(.*)");
    private static final int JAR_FILE_PATH = 3;
    protected static Map<String, Revision> files = Collections.synchronizedMap(new HashMap());
    protected boolean reloadingConfigs = false;

    @Override
    public void setReloadingConfigs(boolean reloadingConfigs) {
        this.reloadingConfigs = reloadingConfigs;
    }

    @Override
    public boolean fileNeedsReloading(URL fileUrl) {
        return fileUrl != null && this.fileNeedsReloading(fileUrl.toString());
    }

    @Override
    public boolean fileNeedsReloading(String fileName) {
        Revision revision = files.get(fileName);
        if (revision == null) {
            return this.reloadingConfigs;
        }
        return revision.needsReloading();
    }

    @Override
    public InputStream loadFile(URL fileUrl) {
        if (fileUrl == null) {
            return null;
        }
        InputStream is = this.openFile(fileUrl);
        this.monitorFile(fileUrl);
        return is;
    }

    private InputStream openFile(URL fileUrl) {
        try {
            InputStream is = fileUrl.openStream();
            if (is == null) {
                throw new IllegalArgumentException("No file '" + fileUrl + "' found as a resource");
            }
            return is;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("No file '" + fileUrl + "' found as a resource");
        }
    }

    @Override
    public void monitorFile(URL fileUrl) {
        Revision revision;
        String fileName = fileUrl.toString();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating revision for URL: " + fileName, new String[0]);
        }
        if ((revision = this.isJarURL(fileUrl) ? JarEntryRevision.build(fileUrl, this) : FileRevision.build(fileUrl)) == null) {
            files.put(fileName, Revision.build(fileUrl));
        } else {
            files.put(fileName, revision);
        }
    }

    protected boolean isJarURL(URL fileUrl) {
        Matcher jarMatcher = JAR_PATTERN.matcher(fileUrl.getPath());
        return jarMatcher.matches();
    }

    @Override
    public URL normalizeToFileProtocol(URL url) {
        String fileName = url.toExternalForm();
        Matcher jarMatcher = JAR_PATTERN.matcher(fileName);
        try {
            if (jarMatcher.matches()) {
                String path = jarMatcher.group(3);
                return new URL("file", "", path);
            }
            return null;
        }
        catch (MalformedURLException e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Error opening url [#0]", e, url.toString());
            }
            return null;
        }
    }

    @Override
    public boolean support() {
        return false;
    }

    @Override
    public boolean internal() {
        return true;
    }

    @Override
    public Collection<? extends URL> getAllPhysicalUrls(URL url) throws IOException {
        return Arrays.asList(url);
    }
}

