/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.process;

import java.io.IOException;
import org.springframework.beans.BeanMetadataAttribute;
import org.springframework.beans.BeanMetadataAttributeAccessor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.config.java.annotation.Configuration;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.SimpleMetadataReaderFactory;

class ConfigurationBeanDefinitionDecoratingBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    ConfigurationBeanDefinitionDecoratingBeanFactoryPostProcessor() {
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        String[] stringArray = beanFactory.getBeanDefinitionNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String beanName = stringArray[n2];
            BeanDefinition beanDef = beanFactory.getBeanDefinition(beanName);
            if (this.isConfigClass(beanDef)) {
                this.addConfigClassMetadata((BeanMetadataAttributeAccessor)beanDef);
            }
            ++n2;
        }
    }

    private void addConfigClassMetadata(BeanMetadataAttributeAccessor beanDef) {
        beanDef.addMetadataAttribute(new BeanMetadataAttribute("IS_CONFIGURATION_CLASS", (Object)true));
    }

    private boolean isConfigClass(BeanDefinition beanDef) {
        MetadataReader reader;
        BeanDefinition beanDefinition = beanDef;
        String className = beanDefinition.getBeanClassName();
        try {
            reader = new SimpleMetadataReaderFactory().getMetadataReader(className);
        }
        catch (IOException e) {
            throw new BeanCreationException("problem reading class " + className, (Throwable)e);
        }
        return reader.getAnnotationMetadata().hasAnnotation(Configuration.class.getName());
    }
}

