/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.internal.parsing.asm;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Stack;
import org.springframework.config.java.internal.model.ConfigurationClass;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImportStack
extends Stack<ConfigurationClass> {
    ImportStack() {
    }

    @Override
    public boolean contains(Object elem) {
        Assert.isInstanceOf(ConfigurationClass.class, (Object)elem);
        ConfigurationClass configClass = (ConfigurationClass)elem;
        Comparator<ConfigurationClass> comparator = new Comparator<ConfigurationClass>(){

            @Override
            public int compare(ConfigurationClass first, ConfigurationClass second) {
                return first.getName().equals(second.getName()) ? 0 : 1;
            }
        };
        int index = Collections.binarySearch(this, configClass, comparator);
        return index >= 0;
    }

    @Override
    public synchronized String toString() {
        StringBuilder builder = new StringBuilder();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            builder.append(((ConfigurationClass)iterator.next()).getSimpleName());
            if (!iterator.hasNext()) continue;
            builder.append("->");
        }
        return builder.toString();
    }
}

