/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.internal.parsing.asm;

import org.springframework.asm.ClassReader;
import org.springframework.asm.ClassVisitor;
import org.springframework.config.java.internal.model.ConfigurationClass;
import org.springframework.config.java.internal.model.ConfigurationModel;
import org.springframework.config.java.internal.parsing.ConfigurationParser;
import org.springframework.config.java.internal.parsing.asm.ConfigurationClassVisitor;
import org.springframework.util.Assert;

public class AsmConfigurationParser
implements ConfigurationParser {
    private final ConfigurationModel model;

    public AsmConfigurationParser(ConfigurationModel model) {
        this.model = model;
    }

    public void parse(Object configurationSource) {
        this.parse(configurationSource, null);
    }

    public void parse(Object configurationSource, String configurationId) {
        Assert.isInstanceOf(ClassReader.class, (Object)configurationSource, (String)"configurationSource must be an ASM ClassReader");
        ConfigurationClass configClass = new ConfigurationClass();
        configClass.setId(configurationId);
        this.parse((ClassReader)configurationSource, configClass);
    }

    private void parse(ClassReader classReader, ConfigurationClass configClass) {
        this.model.add(configClass);
        ConfigurationClassVisitor configClassVisitor = new ConfigurationClassVisitor(configClass, this.model);
        classReader.accept((ClassVisitor)configClassVisitor, false);
    }
}

