/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.internal.model;

import java.util.ArrayList;
import org.springframework.config.java.annotation.Configuration;
import org.springframework.config.java.internal.model.BeanMethod;
import org.springframework.config.java.internal.model.ConfigurationClass;
import org.springframework.config.java.internal.model.MalformedJavaConfigurationException;
import org.springframework.config.java.internal.model.UsageError;

public class ConfigurationModel {
    private ArrayList<ConfigurationClass> configurationClasses = new ArrayList();

    public ConfigurationModel add(ConfigurationClass configurationClass) {
        this.configurationClasses.add(configurationClass);
        return this;
    }

    public ConfigurationClass[] getConfigurationClasses() {
        return this.configurationClasses.toArray(new ConfigurationClass[0]);
    }

    public ConfigurationClass[] getAllConfigurationClasses() {
        ArrayList<ConfigurationClass> allConfigClasses = new ArrayList<ConfigurationClass>();
        for (ConfigurationClass configClass : this.configurationClasses) {
            allConfigClasses.addAll(configClass.getSelfAndAllImports());
        }
        return allConfigClasses.toArray(new ConfigurationClass[allConfigClasses.size()]);
    }

    public UsageError[] detectUsageErrors() {
        ArrayList<UsageError> errors = new ArrayList<UsageError>();
        if (this.configurationClasses.isEmpty()) {
            errors.add(new EmptyModelError());
        }
        for (ConfigurationClass configClass : this.configurationClasses) {
            configClass.detectUsageErrors(errors);
        }
        ConfigurationClass[] allClasses = this.getAllConfigurationClasses();
        int i = 0;
        while (i < allClasses.length) {
            BeanMethod[] beanMethodArray = allClasses[i].getFinalBeanMethods();
            int n = beanMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                BeanMethod finalBeanMethod = beanMethodArray[n2];
                int j = i + 1;
                while (j < allClasses.length) {
                    if (allClasses[j].containsBeanMethod(finalBeanMethod.getName())) {
                        ConfigurationClass configurationClass = allClasses[i];
                        configurationClass.getClass();
                        errors.add(configurationClass.new ConfigurationClass.IllegalBeanOverrideError(allClasses[j], finalBeanMethod));
                    }
                    ++j;
                }
                ++n2;
            }
            ++i;
        }
        return errors.toArray(new UsageError[errors.size()]);
    }

    public void assertIsValid() {
        UsageError[] errors = this.detectUsageErrors();
        if (errors.length > 0) {
            throw new MalformedJavaConfigurationException(errors);
        }
    }

    public String toString() {
        return String.format("%s: configurationClasses=%s", this.getClass().getSimpleName(), this.configurationClasses);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.configurationClasses == null ? 0 : this.configurationClasses.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigurationModel other = (ConfigurationModel)obj;
        return !(this.configurationClasses == null ? other.configurationClasses != null : !this.configurationClasses.equals(other.configurationClasses));
    }

    public class EmptyModelError
    extends UsageError {
        public EmptyModelError() {
            super(null, 0);
        }

        public String getDescription() {
            return String.format("Configuration model was empty. Make sure at least one @%s class has been specified.", Configuration.class.getSimpleName());
        }
    }
}

