/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.internal.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.springframework.config.java.internal.model.AnnotatedMethod;
import org.springframework.config.java.internal.model.JavaConfigMethod;
import org.springframework.config.java.internal.model.ValidatableMethod;
import org.springframework.config.java.internal.util.AnnotationExtractionUtils;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractValidatableAnnotatedMethod<A extends Annotation>
extends JavaConfigMethod
implements ValidatableMethod,
AnnotatedMethod<A> {
    private final A metadata;

    public AbstractValidatableAnnotatedMethod(String name, int modifiers, Annotation ... annotations) {
        super(name, modifiers, annotations);
        Type superclass = this.getClass().getGenericSuperclass();
        if (!(superclass instanceof ParameterizedType)) {
            throw new IllegalStateException("must subclass parameterized type");
        }
        ParameterizedType pSuper = (ParameterizedType)superclass;
        Type[] typeArgs = pSuper.getActualTypeArguments();
        Type arg = typeArgs[0];
        Class annoType = (Class)arg;
        this.metadata = AnnotationExtractionUtils.findAnnotation(annoType, annotations);
        Assert.notNull(this.metadata, (String)("could not find target annotation @" + annoType.getName()));
    }

    @Override
    public A getMetadata() {
        return this.metadata;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.metadata == null ? 0 : this.metadata.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractValidatableAnnotatedMethod other = (AbstractValidatableAnnotatedMethod)obj;
        return !(this.metadata == null ? other.metadata != null : !this.metadata.equals(other.metadata));
    }
}

