/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.internal.factory;

import java.util.ArrayList;
import java.util.Map;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.config.java.internal.factory.AmbiguousBeanLookupException;
import org.springframework.config.java.internal.factory.MultiplePrimaryBeanDefinitionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeSafeBeanFactoryUtils {
    public static <T> T getBean(ListableBeanFactory beanFactory, Class<T> type) {
        Map beansOfType = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)beanFactory, type);
        int matchingBeanCount = beansOfType.size();
        if (matchingBeanCount == 1) {
            return (T)beansOfType.values().iterator().next();
        }
        if (matchingBeanCount == 0) {
            throw new NoSuchBeanDefinitionException(type, "");
        }
        ArrayList<String> primaryCandidates = new ArrayList<String>();
        for (String beanName : beansOfType.keySet()) {
            AbstractBeanDefinition beanDef = (AbstractBeanDefinition)((ConfigurableListableBeanFactory)beanFactory).getBeanDefinition(beanName);
            if (!beanDef.isPrimary()) continue;
            primaryCandidates.add(beanName);
        }
        int primaryCandidateCount = primaryCandidates.size();
        if (primaryCandidateCount == 0) {
            throw new AmbiguousBeanLookupException(type, beansOfType);
        }
        if (primaryCandidateCount > 1) {
            throw new MultiplePrimaryBeanDefinitionException(type, primaryCandidates);
        }
        return (T)beanFactory.getBean((String)primaryCandidates.get(0));
    }

    public static <T> T getBean(ListableBeanFactory beanFactory, Class<T> type, String beanName) {
        return (T)beanFactory.getBean(beanName, type);
    }
}

