/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.internal.enhancement;

import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ThreadLocalUtils {
    static Class<?> CLASS_THREAD_LOCAL_MAP_ENTRY = ThreadLocalUtils.classForName("java.lang.ThreadLocal$ThreadLocalMap$Entry");
    static final Field FIELD_REFERENT = ThreadLocalUtils.getDeclaredField(Reference.class, "referent");
    static final Field FIELD_VALUE = ThreadLocalUtils.getDeclaredField(CLASS_THREAD_LOCAL_MAP_ENTRY, "value");
    static Class<?> CLASS_THREAD_LOCAL_MAP = ThreadLocalUtils.classForName("java.lang.ThreadLocal$ThreadLocalMap");
    static final Method METHOD_REMOVE = ThreadLocalUtils.getDeclaredMethod(CLASS_THREAD_LOCAL_MAP, "remove", ThreadLocal.class);
    static final Field FIELD_THREAD_LOCALS = ThreadLocalUtils.getDeclaredField(Thread.class, "threadLocals");
    static final Field FIELD_INHERITABLE_THREAD_LOCALS = ThreadLocalUtils.getDeclaredField(Thread.class, "inheritableThreadLocals");
    static final Field FIELD_TABLE = ThreadLocalUtils.getDeclaredField(CLASS_THREAD_LOCAL_MAP, "table");

    ThreadLocalUtils() {
    }

    static Field getDeclaredField(Class<?> from, String name) {
        try {
            Field f = from.getDeclaredField(name);
            f.setAccessible(true);
            return f;
        }
        catch (SecurityException e) {
            throw new RuntimeException(String.format("Unable to access field '%s' on type '%s'.", name, from.getName()), e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(String.format("Field '%s' is not a declared field on type '%s'.", name, from.getName()), e);
        }
    }

    static Method getDeclaredMethod(Class<?> from, String name, Class<?> ... parameterTypes) {
        Method m = ReflectionUtils.findMethod(from, (String)name, (Class[])parameterTypes);
        if (m == null) {
            throw new RuntimeException("Unable to find method '" + name + "' on class '" + from + "' with types '" + StringUtils.arrayToCommaDelimitedString((Object[])parameterTypes) + "'.");
        }
        ReflectionUtils.makeAccessible((Method)m);
        return m;
    }

    static Class<?> classForName(String name) {
        try {
            return ClassUtils.getDefaultClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to load class '" + name + "'.", e);
        }
    }
}

