/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.aspect;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.springframework.config.java.aspect.RequiredMethodInvocationRegistry;

@Aspect
public class RequiredMethodInvocationTracker {
    private static final RequiredMethodInvocationRegistry invocationRegistry = new RequiredMethodInvocationRegistry();

    @Before(value="execution(@org.springframework.beans.factory.annotation.Required * *(..))")
    public void logRequiredMethodInvocation(JoinPoint jp) {
        Signature signature = jp.getSignature();
        RequiredMethodInvocationTracker.getInvocationRegistry().registerMethodInvocation(jp.getTarget(), signature.getDeclaringTypeName(), signature.getName());
    }

    public static RequiredMethodInvocationRegistry getInvocationRegistry() {
        return invocationRegistry;
    }
}

