/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote.jmxmp;

import com.sun.jmx.remote.opt.util.EnvHelp;
import com.sun.jmx.remote.socket.SocketConnection;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.generic.GenericConnector;

public class JMXMPConnector
extends GenericConnector
implements Serializable {
    private static final long serialVersionUID = 7098019344073706637L;
    private JMXServiceURL address;
    private transient Map env;
    private static final String protocolName = "jmxmp";

    public JMXMPConnector(JMXServiceURL jMXServiceURL) throws IOException {
        this(jMXServiceURL, null);
    }

    public JMXMPConnector(JMXServiceURL jMXServiceURL, Map map) throws IOException {
        super(map);
        this.env = new HashMap(map == null ? Collections.EMPTY_MAP : map);
        this.address = jMXServiceURL;
        this.validateAddress();
    }

    private void validateAddress() throws IOException {
        if (this.address == null) {
            throw new IllegalArgumentException("JMXServiceURL must not be null");
        }
        if (!protocolName.equalsIgnoreCase(this.address.getProtocol())) {
            throw new MalformedURLException("Unknown protocol: " + this.address.getProtocol());
        }
    }

    public void connect(Map map) throws IOException {
        this.validateAddress();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (this.env != null) {
            hashMap.putAll(this.env);
        }
        if (map != null) {
            EnvHelp.checkAttributes(map);
            hashMap.putAll(map);
        }
        ClassLoader classLoader = EnvHelp.resolveClientClassLoader(hashMap);
        hashMap.put("jmx.remote.default.class.loader", classLoader);
        if (!hashMap.containsKey("jmx.remote.message.connection")) {
            SocketConnection socketConnection = new SocketConnection(this.address.getHost(), this.address.getPort());
            hashMap.put("jmx.remote.message.connection", socketConnection);
        }
        super.connect(hashMap);
    }

    public String toString() {
        return this.getClass().getName() + ": JMXServiceURL=" + this.address;
    }
}

