/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.opt.util;

import com.sun.jmx.remote.opt.util.ClassLogger;
import java.util.ArrayList;

class JobExecutor
extends Thread {
    private Runnable job = null;
    private int[] lock = new int[0];
    private boolean terminated = false;
    private static int poolSize = 20;
    private static ArrayList waitingList = new ArrayList(poolSize);
    private static long counter = 0L;
    private static long waitingTime = 300000L;
    private static final ThreadGroup tgroup = new ThreadGroup("Job_Executor");
    private static final String tname = "Job_Executor";
    private static final ClassLogger logger = new ClassLogger("com.sun.jmx.remote.opt.util", "JobExecutor");

    private JobExecutor(Runnable runnable) {
        super(tgroup, tname + counter++);
        this.setDaemon(true);
        this.job = runnable;
    }

    public static void setPoolSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative size.");
        }
        poolSize = n;
    }

    public static int getPoolSize() {
        return poolSize;
    }

    public static void setWaitingTime(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative waiting time.");
        }
        waitingTime = l;
    }

    public static long getWaitingTime() {
        return waitingTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        while (true) {
            if (this.job != null) {
                try {
                    this.job.run();
                }
                catch (Exception exception) {
                    if (logger.warningOn()) {
                        logger.warning("run", "Got an unexpected exception.", exception);
                    }
                }
                finally {
                    this.job = null;
                }
            }
            int[] nArray = this.lock;
            // MONITORENTER : this.lock
            ArrayList arrayList = waitingList;
            // MONITORENTER : arrayList
            if (waitingList.size() >= poolSize) {
                this.terminated = true;
                // MONITOREXIT : arrayList
                // MONITOREXIT : nArray
                return;
            }
            waitingList.add(this);
            // MONITOREXIT : arrayList
            long l = waitingTime;
            long l2 = System.currentTimeMillis();
            while (this.job == null && l > 0L) {
                try {
                    this.lock.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    this.interrupted();
                }
                l = waitingTime - (System.currentTimeMillis() - l2);
            }
            ArrayList arrayList2 = waitingList;
            // MONITORENTER : arrayList2
            boolean bl = waitingList.remove(this);
            // MONITOREXIT : arrayList2
            if (bl) {
                this.terminated = true;
                // MONITOREXIT : nArray
                return;
            }
            while (this.job == null) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    this.interrupted();
                }
            }
            // MONITOREXIT : nArray
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void handoff(Runnable runnable) {
        JobExecutor jobExecutor = null;
        Object object = waitingList;
        // MONITORENTER : object
        if (waitingList.size() > 0) {
            jobExecutor = (JobExecutor)waitingList.remove(0);
        }
        // MONITOREXIT : object
        if (jobExecutor != null) {
            object = jobExecutor.lock;
            // MONITORENTER : jobExecutor.lock
            if (!jobExecutor.terminated) {
                jobExecutor.job = runnable;
                jobExecutor.lock.notify();
            } else {
                jobExecutor = null;
            }
            // MONITOREXIT : object
        }
        if (jobExecutor != null) return;
        jobExecutor = new JobExecutor(runnable);
        jobExecutor.start();
    }
}

