/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.opt.security;

import com.sun.jmx.remote.generic.ProfileClient;
import com.sun.jmx.remote.opt.security.TLSServerHandler;
import com.sun.jmx.remote.opt.util.ClassLogger;
import com.sun.jmx.remote.socket.SocketConnectionIf;
import java.io.IOException;
import java.net.Socket;
import java.util.Map;
import java.util.StringTokenizer;
import javax.management.remote.generic.MessageConnection;
import javax.management.remote.message.ProfileMessage;
import javax.management.remote.message.TLSMessage;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class TLSClientHandler
implements ProfileClient {
    protected SSLSocket ts = null;
    private boolean completed = false;
    private Map env = null;
    private MessageConnection mc = null;
    private String profile = null;
    private static final ClassLogger logger = new ClassLogger("javax.management.remote.misc", "TLSClientHandler");

    public TLSClientHandler(String string, Map map) {
        this.profile = string;
        this.env = map;
    }

    public void initialize(MessageConnection messageConnection) throws IOException {
        int n;
        String[] stringArray;
        int n2;
        String[] stringArray2;
        String string;
        this.mc = messageConnection;
        Socket socket = null;
        if (!(messageConnection instanceof SocketConnectionIf)) {
            throw new IOException("Not an instance of SocketConnectionIf");
        }
        socket = ((SocketConnectionIf)((Object)messageConnection)).getSocket();
        SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)this.env.get("jmx.remote.tls.socket.factory");
        if (sSLSocketFactory == null) {
            sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
        String string2 = socket.getInetAddress().getHostName();
        int n3 = socket.getPort();
        if (logger.traceOn()) {
            logger.trace("initialize", "TLS: Hostname = " + string2);
            logger.trace("initialize", "TLS: Port = " + n3);
        }
        this.ts = (SSLSocket)sSLSocketFactory.createSocket(socket, string2, n3, true);
        this.ts.setUseClientMode(true);
        if (logger.traceOn()) {
            logger.trace("initialize", "TLS: Socket Client Mode = " + this.ts.getUseClientMode());
        }
        if (TLSServerHandler.bundledJSSE) {
            string = (String)this.env.get("jmx.remote.tls.enabled.protocols");
            if (string != null) {
                stringArray2 = new StringTokenizer(string, " ");
                n2 = stringArray2.countTokens();
                stringArray = new String[n2];
                for (n = 0; n < n2; ++n) {
                    stringArray[n] = stringArray2.nextToken();
                }
                TLSServerHandler.setEnabledProtocols(this.ts, stringArray);
            }
            if (logger.traceOn()) {
                logger.trace("initialize", "TLS: Enabled Protocols");
                stringArray2 = TLSServerHandler.getEnabledProtocols(this.ts);
                if (stringArray2 != null) {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < stringArray2.length; ++i) {
                        stringBuffer.append(stringArray2[i]);
                        if (i + 1 >= stringArray2.length) continue;
                        stringBuffer.append(", ");
                    }
                    logger.trace("initialize", "TLS: [" + stringBuffer + "]");
                } else {
                    logger.trace("initialize", "TLS: []");
                }
            }
        }
        if ((string = (String)this.env.get("jmx.remote.tls.enabled.cipher.suites")) != null) {
            stringArray2 = new StringTokenizer(string, " ");
            n2 = stringArray2.countTokens();
            stringArray = new String[n2];
            for (n = 0; n < n2; ++n) {
                stringArray[n] = stringArray2.nextToken();
            }
            this.ts.setEnabledCipherSuites(stringArray);
        }
        if (logger.traceOn()) {
            logger.trace("initialize", "TLS: Enabled Cipher Suites");
            stringArray2 = this.ts.getEnabledCipherSuites();
            if (stringArray2 != null) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < stringArray2.length; ++i) {
                    stringBuffer.append(stringArray2[i]);
                    if (i + 1 >= stringArray2.length) continue;
                    stringBuffer.append(", ");
                }
                logger.trace("initialize", "TLS: [" + stringBuffer + "]");
            } else {
                logger.trace("initialize", "TLS: []");
            }
        }
    }

    public ProfileMessage produceMessage() throws IOException {
        TLSMessage tLSMessage = new TLSMessage(1);
        if (logger.traceOn()) {
            logger.trace("produceMessage", ">>>>> TLS client message <<<<<");
            logger.trace("produceMessage", "Profile Name : " + tLSMessage.getProfileName());
            logger.trace("produceMessage", "Status : " + tLSMessage.getStatus());
        }
        return tLSMessage;
    }

    public void consumeMessage(ProfileMessage profileMessage) throws IOException {
        if (!(profileMessage instanceof TLSMessage)) {
            throw new IOException("Unexpected profile message type: " + profileMessage.getClass().getName());
        }
        TLSMessage tLSMessage = (TLSMessage)profileMessage;
        if (logger.traceOn()) {
            logger.trace("consumeMessage", ">>>>> TLS server message <<<<<");
            logger.trace("consumeMessage", "Profile Name : " + tLSMessage.getProfileName());
            logger.trace("consumeMessage", "Status : " + tLSMessage.getStatus());
        }
        if (tLSMessage.getStatus() != 2) {
            throw new IOException("Unexpected TLS status [" + tLSMessage.getStatus() + "]");
        }
        this.completed = true;
    }

    public boolean isComplete() {
        return this.completed;
    }

    public void activate() throws IOException {
        if (logger.traceOn()) {
            logger.trace("activate", ">>>>> TLS handshake <<<<<");
            logger.trace("activate", "TLS: Start TLS Handshake");
        }
        this.ts.startHandshake();
        if (logger.traceOn()) {
            SSLSession sSLSession = this.ts.getSession();
            if (sSLSession != null) {
                logger.trace("activate", "TLS: getCipherSuite = " + sSLSession.getCipherSuite());
                logger.trace("activate", "TLS: getPeerHost = " + sSLSession.getPeerHost());
                if (TLSServerHandler.bundledJSSE) {
                    logger.trace("activate", "TLS: getProtocol = " + TLSServerHandler.getProtocol(sSLSession));
                }
            }
            logger.trace("activate", "TLS: Finish TLS Handshake");
        }
        ((SocketConnectionIf)((Object)this.mc)).setSocket(this.ts);
    }

    public void terminate() throws IOException {
    }

    public String getName() {
        return this.profile;
    }
}

