/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.proxy;

import com.jamonapi.utils.AppMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SQLDeArger {
    private int parseSize;
    private StringBuffer parsedSQL = new StringBuffer();
    private char[] sqlChars;
    private String sqlToParse;
    private int delimCounter = 0;
    private int currentCharNum = 0;
    private boolean isInString = false;
    private char delim;
    private int totalDelims;
    private boolean firstToken = true;
    private String sqlType;
    private List matchStrings;
    private String[] matches;
    private static Map sqlTypes = AppMap.createInstance();

    public SQLDeArger(String sql) {
        this(sql, null);
    }

    public SQLDeArger(String sql, List matchStrings) {
        this.sqlToParse = sql.trim() + " ";
        this.parseSize = this.sqlToParse.length() - 1;
        this.sqlChars = this.sqlToParse.toCharArray();
        this.setMatchStrings(matchStrings);
        this.parse();
    }

    private SQLDeArger parse() {
        while (this.hasTokens()) {
            String token = this.getNextToken();
            if (this.firstToken) {
                this.setSQLType(token);
                this.firstToken = false;
            }
            token = this.isFloatString(token) || this.isQuotedString(token) ? "?" : token;
            this.parsedSQL.append(token);
        }
        this.parseMatches();
        return this;
    }

    public String getParsedSQL() {
        return this.parsedSQL.toString();
    }

    public String getSQLToParse() {
        return this.sqlToParse;
    }

    public String getSQLType() {
        return this.sqlType;
    }

    public String[] getMatches() {
        return this.matches;
    }

    public boolean hasMatches() {
        return this.matches != null && this.matches.length != 0;
    }

    public int getNumMatches() {
        return this.hasMatches() ? this.matches.length : 0;
    }

    int getNumAll() {
        return 3 + this.getNumMatches();
    }

    String[][] getAll() {
        int size = this.getNumAll();
        String[][] allData = new String[size][];
        int j = 0;
        for (int i = 0; i < size; ++i) {
            allData[i] = new String[3];
            allData[i][1] = this.getSQLToParse();
            allData[i][2] = "ms.";
            allData[i][0] = i == 0 ? "All" : (i == 1 ? this.getSQLType() : (i == 2 ? this.getParsedSQL() : this.matches[j++]));
        }
        return allData;
    }

    public void addMatchString(String matchString) {
        this.matchStrings.add(matchString);
    }

    private void parseMatches() {
        if (this.matchStrings != null) {
            String sql = this.getParsedSQL();
            ArrayList<String> matchesList = new ArrayList<String>();
            Iterator iter = this.matchStrings.iterator();
            while (iter.hasNext()) {
                Object matchObj = iter.next();
                String matchStr = matchObj == null ? null : matchObj.toString();
                if (sql.indexOf(matchStr) <= 0) continue;
                matchesList.add(matchStr);
            }
            this.matches = matchesList.toArray(new String[0]);
        }
    }

    void setMatchStrings(List matchStrings) {
        this.matchStrings = matchStrings;
    }

    public static void putSQLType(String type) {
        sqlTypes.put(type, type);
    }

    private void setSQLType(String type) {
        this.sqlType = (String)sqlTypes.get(type);
        if (this.sqlType == null) {
            this.sqlType = "other";
        }
    }

    private boolean hasTokens() {
        return this.currentCharNum < this.parseSize;
    }

    private String getNextToken() {
        int start = this.currentCharNum;
        int end = 0;
        while (end == 0 && this.currentCharNum < this.parseSize) {
            this.setStringDelim();
            if (this.isWordBoundary(this.getCurrentChar(), this.getNextChar())) {
                end = this.currentCharNum + 1;
            }
            ++this.currentCharNum;
        }
        if (end > 0) {
            return this.sqlToParse.substring(start, end);
        }
        return null;
    }

    private boolean isPunctuation(char ch) {
        return !this.isInString() && !Character.isLetterOrDigit(ch);
    }

    private boolean isWordBoundary(char currentCh, char nextCh) {
        return this.isPunctuation(currentCh) && Character.isLetterOrDigit(nextCh) || !this.isInString() && (Character.isWhitespace(nextCh) || !Character.isLetterOrDigit(nextCh));
    }

    private boolean isInString() {
        return this.isInString;
    }

    private void setIsInString(boolean isInString) {
        this.isInString = isInString;
    }

    private void setStringDelim(char delim) {
        this.delim = delim;
    }

    private char getStringDelim() {
        return this.delim;
    }

    private char getCurrentChar() {
        return this.sqlChars[this.currentCharNum];
    }

    private char getNextChar() {
        return this.sqlChars[this.currentCharNum + 1];
    }

    private void setStringDelim() {
        boolean isDelim;
        boolean bl = isDelim = this.isInString() && this.getCurrentChar() == this.getStringDelim();
        if (isDelim) {
            ++this.totalDelims;
        }
        if (!(this.isInString() || this.getCurrentChar() != '\'' && this.getCurrentChar() != '\"')) {
            ++this.delimCounter;
            ++this.totalDelims;
        } else if (this.isInString() && this.getCurrentChar() == this.getStringDelim() && this.getNextChar() != this.getStringDelim() && this.totalDelims % 2 == 0) {
            --this.delimCounter;
        }
        if (!this.isInString() && this.delimCounter == 1) {
            this.setStringDelim(this.getCurrentChar());
            this.setIsInString(true);
        } else if (this.isInString() && this.delimCounter == 0) {
            this.setIsInString(false);
        }
    }

    private boolean isFloatString(String str) {
        return str != null && Character.isDigit(str.charAt(0));
    }

    private boolean isQuotedString(String str) {
        if (str == null || "".equals(str.trim())) {
            return false;
        }
        char first = str.charAt(0);
        char last = str.charAt(str.length() - 1);
        return (first == '\'' || first == '\"') && first == last;
    }

    private static void printDebugInfo(String sql) {
        ArrayList<String> matches = new ArrayList<String>();
        matches.add("employees");
        matches.add("dependents");
        matches.add("orders");
        SQLDeArger s = new SQLDeArger(sql, matches);
        System.out.println("\nSQL=" + sql);
        System.out.println("ParsedSQL=" + s.getParsedSQL());
        System.out.println("SQLType=" + s.getSQLType());
        if (s.hasMatches()) {
            System.out.println("String Matches=");
            String[][] m = s.getAll();
            for (int i = 0; i < m.length; ++i) {
                System.out.println("all array[" + i + "]=" + m[i][0]);
                System.out.println("all array original [" + i + "]=" + m[i][1]);
            }
        }
    }

    public static void main(String[] args) {
        SQLDeArger.printDebugInfo("select col0, 'mindy', 'mindy''s', 'mindy''s''''', col2, convert('steve',100, 0xff, 100.0),* from table where salary>=100000 or salary<=200000 or name like 'steve%' and name in ('mindy','steve') and short= 20 or sand='no sand' or short=30 and sand='no sand' and sand='no sand' or salary in (select max(salary/2),100 from emps group by name having count(*)>5)");
        SQLDeArger.printDebugInfo("select ?,*,? from table where name like ?");
        SQLDeArger.printDebugInfo("select 'mindy', \"mindy\" from table where name like 'mindy'");
        SQLDeArger.printDebugInfo("     delete from table where  key name like          'mindy%'   ");
        SQLDeArger.printDebugInfo("myproc");
        SQLDeArger.printDebugInfo("exec myproc");
        SQLDeArger.printDebugInfo("select * from employees as e, customers as c, dependents as d where e.id=c.id and c.id=d.id and e.name in (select * from favorite where name like 'j%' and salary > 50000)");
        SQLDeArger.printDebugInfo("select * from employees as e, customers as c, dependents as d where e.id=c.id and c.id=d.id and e.name not in ('steve','souza','jeff','beck') and salary in (100000,20000, 50000) and age!=50");
        SQLDeArger.printDebugInfo("select 10_name_10, name_10_name,* from employees where age<50 and age!=10.0 and age!=-50.0 and age < 0xFF and age < 0x0123456789aAbBcCdDeEfF and age<+10E09");
        SQLDeArger.printDebugInfo("select 10/22/06, date102206, m10/d22/y06, 10name, $10_name, _10_name, 10_name_10, name_10_na1010me,* from employees where age<50 and age!=10.0 and age!=-50.0 and age < 0xFF and age < 0x0123456789aAbBcCdDeEfF and age<+10E09 and age<1.72E3F");
        SQLDeArger.printDebugInfo("pageHits 'ssouza' jamon mb 100.5:pageHits jamon:pagehits.ssouza");
    }

    static {
        sqlTypes.put("select", "select");
        sqlTypes.put("update", "update");
        sqlTypes.put("delete", "delete");
        sqlTypes.put("insert", "insert");
        sqlTypes.put("truncate", "truncate");
        sqlTypes.put("exec", "exec");
        sqlTypes.put("create", "create");
        sqlTypes.put("drop", "drop");
        sqlTypes.put("alter", "alter");
        sqlTypes.put("commit", "commit");
        sqlTypes.put("rollback", "rollback");
        sqlTypes.put("save", "save");
        sqlTypes.put("grant", "grant");
        sqlTypes.put("revoke", "revoke");
    }
}

