# Security Policy

## Supported Versions

| Version | Supported          |
| ------- | ------------------ |
| 2.x.x   | :white_check_mark: |
| 3.0.x-alpha   | :x:                |


## Reporting a Vulnerability

If you believe you have found a security vulnerability in our project, we encourage you to let us know right away. 
We will investigate all legitimate reports and do our best to quickly fix the problem. 

Before reporting though, please review our security policy below.

### How to Report

To report a security vulnerability, please use GitHub's [private vulnerability reporting](https://docs.github.com/en/code-security/security-advisories/guidance-on-reporting-and-writing-information-about-vulnerabilities/privately-reporting-a-security-vulnerability) feature. If possible, please include as much information as possible. 
This may include steps to reproduce, impact of the vulnerability, and anything else you believe would help us understand the problem.
**Please do not include any sensitive or personal information in your report**.

### What to Expect

When you report a vulnerability, here's what you can expect:

- **Acknowledgement**: We will acknowledge your email within 48 hours, and you'll receive a more detailed response to your email within 72 hours indicating the next steps in handling your report.

- **Updates**: After the initial reply to your report, our team will keep you informed of the progress being made towards a fix and full announcement. These updates will be sent at least once a week.

- **Confidentiality**: We will maintain strict confidentiality of your report until the security issue is resolved.

- **Issue Resolution**: If the issue is confirmed, we will release a patch as soon as possible depending on complexity of the fix.

- **Recognition**: We recognize and appreciate every individual who helps us identify and fix vulnerabilities in our project. While we do not currently have a bounty program, we would be happy to publicly acknowledge your responsible disclosure.

We strive to make Wails safe for everyone, and we greatly appreciate the assistance of security researchers and users in helping us identify and fix vulnerabilities. Thank you for your contribution to the security of this project.
