
<!--

*********************************************************************
*               PLEASE READ BEFORE SUBMITTING YOUR PR               *
*     YOUR PR MAY BE REJECTED IF IT DOES NOT FOLLOW THESE STEPS     *
*********************************************************************

- *DO NOT* submit PRs for v3 alpha enhancements, unless you have opened a post on the discord channel.
  All enhancements must be discussed first.
  The feedback guide for v3 is here: https://v3alpha.wails.io/getting-started/feedback/

- Before submitting your PR, please ensure you have created and linked the PR to an issue.
- If a relevant issue already exists, please reference it in your PR by including `Fixes #<issue number>` in your PR description.
- Please fill in the checklists.

-->

# Description

Please include a summary of the change and which issue is fixed. Please also include relevant motivation and context. List any dependencies that are required for this change.

Fixes # (issue)

## Type of change
  
Please select the option that is relevant.

- [ ] Bug fix (non-breaking change which fixes an issue)
- [ ] New feature (non-breaking change which adds functionality)
- [ ] Breaking change (fix or feature that would cause existing functionality to not work as expected)
- [ ] This change requires a documentation update

# How Has This Been Tested?
  
Please describe the tests that you ran to verify your changes. Provide instructions so we can reproduce. Please also list any relevant details for your test configuration using `wails doctor`.

- [ ] Windows
- [ ] macOS
- [ ] Linux
      
If you checked Linux, please specify the distro and version.
  
## Test Configuration

Please paste the output of `wails doctor`. If you are unable to run this command, please describe your environment in as much detail as possible.

# Checklist:

- [ ] I have updated `website/src/pages/changelog.mdx` with details of this PR
- [ ] My code follows the general coding style of this project
- [ ] I have performed a self-review of my own code
- [ ] I have commented my code, particularly in hard-to-understand areas
- [ ] I have made corresponding changes to the documentation
- [ ] My changes generate no new warnings
- [ ] I have added tests that prove my fix is effective or that my feature works
- [ ] New and existing unit tests pass locally with my changes
