# Urdu Font Comparator 


This project is about an Android application (available on [Google Play](https://play.google.com/store/apps/details?id=com.androidistan.urdufontcomparator)) which allows users to explore various Urdu Fonts, eventually helping them in choosing the right one. This project is additionally intended to make users appreciate why [Nasta'liq](https://en.wikipedia.org/wiki/Nasta%CA%BFl%C4%ABq_script) script should be a natural choice for Urdu content on web and mobile devices. I also wrote a [blog post](http://wahibhaq.com/blog/introducing-urdu-font-comparator-app/) describing how I ended up working on this project.

<br>

## Description

<img src="https://wahibhaq.github.io/img/projects/urdu-font-comparator-release-icon.png" width="100" height="100" align="center"> 

The Android application offers following features: 

* Explore various Urdu Fonts available and pick anyone of them
* Visually see how sample text looks like in each font style
* Adjust font size using the slider 
* Swipe the sample text area to switch fonts more conveniently
* See details of each font which provides important pointers about that font
* Give feedback via rating which eventually helps other users to get an idea of popular fonts
* More importantly, see and appreciate why [Nasta'liq](https://en.wikipedia.org/wiki/Nasta%CA%BFl%C4%ABq_script) script should be a natural choice for Urdu content on mobile devices. 
* Application (at point of writing) includes 9 Fonts in total containing 6 from Nasta'liq, 2 from Naskh and 1 from Riqa script.

<br>

<img src="https://media.giphy.com/media/xUOrvYu2MF4xXWGimQ/giphy.gif" width="250" height="450" align="middle"> 


<br>

<img src="https://wahibhaq.github.io/img/projects/urdu-app-screenshot-home.png" width="200" height="350" align="middle"> &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 
<img src="https://wahibhaq.github.io/img/projects/urdu-app-screenshot-picker.png" width="200" height="350" align="middle"> 
&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 
<img src="https://wahibhaq.github.io/img/projects/urdu-app-screenshot-font-info.png" width="200" height="350" align="middle">

<br>


## Motivation

<img src="https://i.imgur.com/LlKatq4.jpg" width="600" height="300" align="middle" alt="Source: Dawn Images">

Credits: [Dawn](http://herald.dawn.com/news/1153737/the-case-for-urdu-as-pakistans-official-language)

<br>

I wanted to play with Urdu fonts for a while but was still not getting a starting point or a solid motivation to do it. This idea originated when I read the news about a new and much improved font, [Meher Nasta'liq](http://csalt.itu.edu.pk/urdufont/) launched by [Center for Speech and Language Technologies (CSaLT)](http://csalt.itu.edu.pk/) lab at [International Technical University (ITU)](http://itu.edu.pk/), Lahore (Pakistan). The website claims it to be a step towards advanced Urdu Typography and a font which serves the need of modern mobile applications. Even Dawn covered a [story](https://www.dawn.com/news/1313737) about it being a Calligraphy-based Urdu font for the Internet. It was enough to catch my attention and I wanted to try it out and see how it is different from other fonts, especially Jameel Noori Nastaleeq Font, which is considered to be the best so far. Then once I started thinking about it, I realized that there is no app or resource where I can see how Urdu text looks like rendered in different fonts (there are a lot actually!).

As mentioned, I started this project to address a problem I was facing but in a broader picture, I am quite hopeful that it will encourage developers to create apps with Urdu content. Additionally, I didn't find any resource which addresses questions like why Urdu has a limited reach when it comes to Internet or Mobile devices and technical comparison of Naskh and Nasta'liq scripts. My goal is also to convert this research into an information source which provides answers for those who are equally concerned and interested to dig deeper in this area.

## Background

Long story short, it can assist you in making a better decision on choosing the right Urdu font for your Android app or mobile app in general. The font is always a key element of the UI which impacts user's first impression of the app. It is believed that choice and attractiveness of the font makes the application visually appealing. The beauty, aesthetics and size of a font are one of the key factors. The choice of font matters a lot because it makes the text more natural to read and fairly easy to understand.

<img src="https://i.imgur.com/9nw5ttS.png" width="500" height="200" align="middle">

Credits: [Rekhta](https://rekhta.org/couplets/saliiqe-se-havaaon-men-jo-khushbuu-ghol-sakte-hain-unknown-couplets?lang=ur)

<br><br>

Urdu is my mother tongue, lingua franca as well as the national language of Pakistan and widely spoken in 6 countries by [60+ million people](http://mentalfloss.com/article/64594/proportional-map-worlds-largest-languages) but still Urdu as a language has not been successfully integrated with what we know as "[Digital Age](https://en.wikipedia.org/wiki/Information_Age)". A significant number of Urdu speakers aren't technologically active, especially those residing in India and Pakistan due to poor economic conditions of the demographic. Among those active, majority of whom are Millennials don't write Urdu at all and are comfortable with using Roman Urdu as a medium of communication. 

I, myself, started using Urdu on Whatsapp and Messenger roughly 2 years ago after installing [SwiftKey Keyboard](https://play.google.com/store/apps/details?id=com.touchtype.swiftkey&hl=en) on my personal phone. It took like 3-4 months of daily usage before I became comfortable and developed fluent writing speed. Family and Friends poked fun and found it odd but I continued using it. Many of them later joined me after my constant encouragement. My International friends find Urdu script  quite fascinating and it's a shame that unlike every other countries, we don't write in our native language in daily lives. Many of us only realize it once we start living outside Pakistan.

> I am always sorry when any language is lost, because languages are the pedigrees of nations. ~ Samuel Johnson 


<img src="https://i.imgur.com/UpAfjQO.jpg" width="600" height="300" align="middle" alt="Source: Dawn Images">

Credits: [Dawn](http://herald.dawn.com/news/1153737/the-case-for-urdu-as-pakistans-official-language)

<br>

### [Naskh](https://en.wikipedia.org/wiki/Naskh_(script)) vs [Nasta'liq](https://en.wikipedia.org/wiki/Nasta%CA%BFl%C4%ABq_script)

Urdu as a language has an Indo-Aryan base and is written from right to left like Arabic or Farsi. According to [linguist-historians](https://www.wdl.org/en/item/9700/), it started evolving from Farsi and Arabic contacts during the invasions of the Indian subcontinent by Persian and Turkic forces from the 11th century onward.
By and large, Arabic today is written in [Naskh](https://en.wikipedia.org/wiki/Naskh_(script)) and subsequently the Urdu text you see on Web is also predominantly in Naskh script. Urdu is not a child of Arabic but somehow Naskh was accepted as de facto style for Urdu on Internet. Urdu is typically written in a Nasta'liq style i.e. the connected letters in a word tend to follow a sloping baseline. The difference between Nasta'liq and Naskh is much more than just a different style and Nasta'liq is deeply connected to feelings of origin and pride of Urdu speakers (at least for those who care). Nasta'liq, based on a century-old calligraphic tradition, is considered one of the most beautiful scripts on the planet and also known as “the bride of calligraphy”. 

I would ignore geo-political affiliation for now but I can confidently say that the past two or three generations of Urdu readers and writers grew up associating Nasta'liq and Urdu almost exclusively with each other. Nasta'liq was the default script when reading Urdu books in schools. Therefore, our generation is so used to reading Urdu in Nasta'liq that we can't even read properly when written in Naskh, but due to the limited use of Nastal'iq, we are forced to read Urdu in Naskh on digital devices. According to Nina Stoessinger in her article on "[Deeper into Type](https://themanual.org/read/issues/3/nina-stoessinger/article)", Reading is a fragile task and it requires sustained focus and is easily interrupted. In this context, the goal of typography must be to reduce irritation as much as possible because otherwise reader will more likely abandon the piece. If we want to make text in Urdu less demanding and more attractive, we need to make it easy to read—not just on the semantic level of the text but also on the formal level of typography. 

[Ali Eteraz](https://twitter.com/eteraz) has written an awesome article on this topic titled, [The Death of the Urdu Script
](https://medium.com/@eteraz/the-death-of-the-urdu-script-9ce935435d90). Ali's article created a good amount of splash and it touched the very sensitive point regarding the Urdu script in online world. Here is an example of Nasta'liq compared with the more common Naskh script.

![Naskh vs Nata'liq](https://cdn-images-1.medium.com/max/1600/0*9Cxd8PX0UX1WiU8b.jpeg)


The complexity of Nasta'liq makes it one of the world's most challenging writing styles. It should be immediately obvious why Naskh is easier to implement than Nasta'liq. Ali says “With its straightness and angularity, Naskh is simply easier to code, because unlike Nasta'liq, it doesn’t move vertically and doesn’t have dots adhering to a strict pattern.”
The difficulties in implementing Nasta'liq mean that most software companies have simply opted to implement Naskh in hopes that Urdu speakers will switch to using Naskh. This has not worked the way everyone might have anticipated. Apparently Naskh is so abhorrent to Urdu speakers that they prefer to switch to using the Roman script instead of Naskh on the Web and for texting and this is where things go wrong.

Nasta'liq occupies a special place in Urdu, and decades of attempts from press typesetting to moder-day Web have tried to squeeze Urdu into Naskh, but not with the same success as they have had with Farsi. Urdu people have managed to have a way to print Nastaleeq using technology bridges - discarding character typesetting for stencil-based presses, and in the modern day, using images instead of text. That hurts search, SEO and other text-oriented pursuits. While reading Urdu in Nasta'liq script, we don't actually read the letters, we are reading beautiful groups of letters that allow us to read very fast and recognizing the combination of characters (glyph in OTF). It is similar to the recognition of a character in Chinese that expresses a thought and not a letter. When those well-recognized Nasta'liq combinations do not appear to the reader, he/she is disoriented and does not like the printing of it.

#### This is how both scripts look like on a mobile screen

Nasta'liq on [Daily Pakistan](http://dailypakistan.com.pk/latest) website 
&nbsp; &nbsp; &nbsp;&nbsp; &nbsp;
Naskh on [BBC Urdu](http://www.bbc.com/urdu/world) website  <br> <br>
<img src="https://i.imgur.com/ned1c7q.png" width="220" height="400" align="left"> &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;
<img src="https://i.imgur.com/lFUGYu0.png" width="220" height="400" align="center">

<br>

#### A brief overview of both scripts:

#####  Naskh 
Naskh though cursive is linear in nature. Each letter joins to the next moving from right to left. The glyphs change shape according to the place they occupy within the word. Strictly defined by norms laid down by tradition, the visual beauty of Naskh lies in the seamless manner in which each letter joins to the next letter to create a text which is as attractive as a visual drawing.

#####  Nasta'liq 
Nastaa'liq is one of the most complex scripts to design. Nasta'liq is written on a slanting baseline where the longer a word is, the taller the word becomes. Unlike Naskh which is linear in nature, Nastaa'liq moves both from right to left and vertically from top to bottom with the “nukte” or dots conforming to a strict placement order. Nasta'liq demands strict conformity with a specific grammar which has been honed and fine-tuned over the centuries. 

![Nasta'liq script representation](https://i.imgur.com/Ds8m2xD.png)

It's complexity also makes it one of the most difficult scripts to render using a computer font. Its right-to-left direction, vertical nature, and context-specific shaping provide a challenge to any font rendering engine and make it much more difficult to render than the flat (Naskh) Arabic script that it is based on. As a result, font developers have long struggled to produce a font with the correct shaping but at the same time avoid overlapping of dots and diacritics.

If you are curious to read and know more about the history and technicalities of the Urdu Typography then do explore this beautifully illustrated [Design Student's Guide to Urdu Type](https://issuu.com/shumylehaider/docs/a_design_student_s_guide_to_urdu_ty) from [Shumyle](https://www.behance.net/shumyle72).


## Status of Urdu on Smartphones

### Nasta'liq support

##### Windows

Nasta'liq became part of Windows 8 with introduction of [Urdu Typesetting](http://archives.miloush.net/michkap/archive/2011/11/16/10237715.html), a new member of the Arabic script font family. It was supposedly first widely available Unicode font to support Nasta'liq. Thanks to [Michael S. Kaplan and his team](http://archives.miloush.net/michkap/archive/2013/10/09/10455209.html) for this.  

##### iOS

[Mudassir Azeemi](https://twitter.com/maxeemi) is another enthusiast with a similar [mission](https://medium.com/@mmudassir/the-revival-of-the-urdu-script-734eeeffef5d), who also wrote a [letter to Tim Cook](https://medium.com/@mmudassir/an-open-letter-to-tim-cook-and-jonathan-ive-be38cf88d8ee) back in 2014 to request for Nasta'liq support in iOS. He was quite excited to inform us that Apple finally included Nasta'liq support in [iOS 11](https://www.apple.com/ios/ios-11-preview/) beta and we all hope to see the update being released. 

Update (12.09.2017): Apple has officially adopted Nasta'liq on iOS devices and it is a Big News! Mudassir already [shared](https://medium.com/@mmudassir/thank-you-شکریہ-مہربانی-tim-cook-for-nastaleeq-2c5e36efef6e) his excitement :)

##### Android

Android started offering Urdu from [Marshmallow (Oct, 2015)](https://www.android.com/intl/en_in/versions/marshmallow-6-0/features/#marshmallow-features-1-body) and to my knowledge (at the time of writing this) it still does not support Nasta'liq natively for Urdu language.

##### Urdu Fonts

Interestingly, promising efforts are underway in terms of Urdu Fonts being developed according to the needs of modern web publishing and mobile applications. We always needed Fonts which allow electronic communication in Urdu using existing software (Google Chrome, Mozila, IE and Safari) which support OTF specifications but without any need to install plug-ins.

Other desirable features include :

  * Faster rendering speed
  * Optimal Font file size
  * Desirable look according to National Calligraphic Standards
  * Aaraab and marks support
  * Appropriate Kashida support and reduced line height.
  
[Mehr Nastaleeq](http://csalt.itu.edu.pk/urdufont/) Font is a very good example of a font which fulfills this requirement which was [launched](http://www.dawn.com/news/1313737) and made available for use in Feb 2017. Mehr font also became a reason why I wanted to develop such an Android app in first place to validate and see how it makes the Urdu text looks beautiful. In this application (at point of writing), I have included 9 Fonts in total containing 6 from Nasta'liq, 2 from Naskh and 1 from Riqa script. This was a concious decision to allow users to get a flavour of different options available but numbers are clear indication of my biases towards Nasta'liq for all good reasons. 

My biggest challenge in searching and selecting the right Fonts was that there is no one resource where I could find them easily. All of this information about Fonts is scattered. Then, even if you are successful in finding a url to download, there is no description available about the purpose/features of respective Font or the creator. I genuinely struggled in finding the License information about most of the Fonts which I wanted to include and use. To save effort for other interested users, I have listed Licenses of all fonts (those included in application) in a separate [file](https://github.com/wahibhaq/urdu-font-comparator-app/blob/master/FONT_LICENSES.md) in this repo. I just wanted to ensure that concerned people/organizations should get their due acknowledgement. 


#### Problems and Proposed Solutions

Coming back to the topic, I feel like there are several obstacles which exist today to full integration of Urdu in it's right typeface on mobile devices. First, we only have handful of websites such as [BBC-Urdu](http://www.bbc.co.uk/urdu/) or [Rekhta.org](https://rekhta.org/?lang=ur) which are entirely in Urdu and mobile apps are almost non-existent. Most of them tend to publish images instead of text which is highly non-productive. So there is an impression that market doesn't exist and users don't see any value in it. Second, there's only a small chunk of websites (e.g [Jang News](https://jang.com.pk/)) which publish content in Nasta'liq which is Urdu’s default writing style. Third, Google Translator performs extremely poor with English to Urdu translation, reducing reach to non-Urdu readers. Fourth, there is a critical need to encourage our friends, family and especially millennials to start using Urdu as a communication medium in written form and take pride in it.  

Lastly and most importantly, the world's most daunting Urdu script problem as we know it can be solved by providing the Nasta'liq font in all the popular Operating Systems of this brave new world. *Yes, Google I am talking to you*. As Mudassir has rightly put it, in order to write in Nasta'liq, Google will need to tie in the Nasta'liq font with the Unicode, relate it to Urdu and get rid of that Naskh typeface. There are some hacks to install Custom Urdu Fonts on Android/iOS devices but those are *hacks* which might work on one device but won't work on another and not every user has a will and technical know-how of following those instructions. OSes can revive the Urdu language’s true identity on the internet, without pulling too many hair because the hair-loss problem is still the toughest problem to crack so far. 

I personally believe in order to make Google and other big players genuinely interested in doing their part, we first have to make them believe that Urdu as a language can no longer be ignored anymore considering it’s use by tens of millions and massive reach. The more we start using and publishing mobile apps with Urdu content, the more it will get the deserving attention. Local IT industry and governing bodies can then push through various channels with more confidence and substance. 

### Apps on Google Play in Urdu content

I started a research to find out Android apps which fulfill following criteria:

* Entire content is in Urdu
* Customized for [RTL](https://developer.android.com/about/versions/jelly-bean.html#42-native-rtl) (Right-to-left) layout mirroring
* Using a Nasta'liq font

It's an ongoing study and I will keep updating this section in future. Honestly, there aren't many apps which fulfill these criteria and that's exactly why it's important to highlight and encourage other apps creators. 

> Note: Right now, my app is also not configured for RTL layout mirroring in it's true sense and not all content is in Urdu but I will surely try to address both of these topics as an improvement in next update.

<br>

#### Hall of Fame

##### [Pencil News](http://www.pencil.pk/home)

One app which I would like to mention is Pencil News. It allows users to read news on an Urdu-based interface in authentic “Nasta'liq Urdu” font.

Pencil app fulfills the criteria mentioned above and have done a pretty good job with their app. It was also covered by [TechJuice](https://www.techjuice.pk/pencil-news-is-a-cool-urdu-news-application/) and you can also download it from [here](https://play.google.com/store/apps/details?id=com.pencil.news.android).

I am attaching some of the screenshots to give an idea how it should be done. 


<img src="https://i.imgur.com/oHPwhsh.png" width="200" height="400" align="center"> 
<img src="https://i.imgur.com/WEpKcY9.png" width="200" height="400" align="center">

<br>

#### Honorary Mentions

##### [BYKEA بائیکیا](https://play.google.com/store/apps/details?id=com.bykea.pk&hl=en)

BYKEA is an all in one app for transportation, delivery and payment services. It has incorporated Urdu along with English. 

##### [CricName](https://play.google.com/store/apps/details?id=com.cricnama&rdid=com.cricnama) 

CricName is a Cricket-oriented Android App in Urdu which keeps users up to date with standout coverage of the game. It has certain missing elements like RTL mirroring and not using one of the Nasta'liq font.

##### [Nastaleeq Chrome Extension](https://chrome.google.com/webstore/detail/nastaleeq/oddbjmjgpaofommagnbfednbdifaakfb?hl=en)

A bit unrelated but I recently found out about this Chrome extension and felt need to mention it here. It does solve the problem as far as browsing and reading Urdu content on Chrome is concerned. Cherry on the top, it also uses "Mehr Nastaleeq" Font.


<br> <br>

## How can I contribute?

Nothing special, just fork and create a PR with your contributions. Later, I plan to define a certain criteria for those who want to include a new font in the app. 

I tried my best to keep my research legitimate and only include information for which I found authentic resources. I have also shared my point of views on how I see the problems and my perspective which is open for debate and questioning. I am more than happy to receive constructive feedback on what I have written here or areas where you think I can improve. 

## Who else contributed in this project?

It is a very personal project which I formally kicked off in Feb 2017. I was also super motivated because one of my 2017 New Year's goals was to develop my own Android app from scratch and get it published on Google Play. This idea seemed like a good way to achieve this goal.

It wouldn't have been possible without the assistance of [Zeeshan Shabbir](https://github.com/ZeeshanShabbir), who voluntarily jumped in and always did any task I asked of him with a smile. I hope he also learned a thing or two during this experience. So, overall, many people helped me in some way or another during this project and I'm thankful to all of them. I have tried to mention all of them in [Contributors list](https://github.com/wahibhaq/urdu-font-comparator-app/blob/master/CONTRIBUTORS.md);

## Where can I get more help, if I need it?

You can contact me at wahib.myapps@gmail.com or tweet me at [@wahibhaq](https://twitter.com/wahibhaq).
