/**
 * @author Yosuke Ota
 */
'use strict'

const { RuleTester, ESLint } = require('../../eslint-compat')
const semver = require('semver')
const rule = require('../../../lib/rules/func-call-spacing')

const tester = new RuleTester({
  languageOptions: { parser: require('vue-eslint-parser'), ecmaVersion: 2020 }
})

tester.run('func-call-spacing', rule, {
  valid: [
    `
    <template>
      <div :foo="foo()" />
    </template>
    `,
    {
      code: `
      <template>
        <div :foo="foo ()" />
      </template>
      `,
      options: ['always']
    },
    `
    <template>
      <div :[foo()]="value" />
    </template>
    `,
    {
      code: `
      <template>
        <div :[foo()]="value" />
      </template>
      `,
      options: ['always']
    },
    // CSS vars injection
    `
    <style>
    .text {
      color: v-bind('foo()')
    }
    </style>`
  ],
  invalid: [
    {
      code: `
      <template>
        <div :foo="foo ()" />
      </template>
      `,
      output: `
      <template>
        <div :foo="foo()" />
      </template>
      `,
      errors: [
        {
          message: semver.lt(ESLint.version, '7.0.0')
            ? 'Unexpected newline between function name and paren.'
            : 'Unexpected whitespace between function name and paren.',
          line: 3
        }
      ]
    },
    {
      code: `
      <template>
        <div :foo="foo()" />
      </template>
      `,
      output: `
      <template>
        <div :foo="foo ()" />
      </template>
      `,
      options: ['always'],
      errors: [
        {
          message: 'Missing space between function name and paren.',
          line: 3
        }
      ]
    },

    // CSS vars injection
    {
      code: `
      <style>
      .text {
        color: v-bind('foo ()')
      }
      </style>`,
      output: `
      <style>
      .text {
        color: v-bind('foo()')
      }
      </style>`,
      errors: [
        {
          message: semver.lt(ESLint.version, '7.0.0')
            ? 'Unexpected newline between function name and paren.'
            : 'Unexpected whitespace between function name and paren.',
          line: 4
        }
      ]
    }
  ]
})
