---
pageClass: rule-details
sidebarDepth: 0
title: vue/prefer-template
description: Require template literals instead of string concatenation in `<template>`
since: v7.0.0
---

# vue/prefer-template

> Require template literals instead of string concatenation in `<template>`

- :wrench: The `--fix` option on the [command line](https://eslint.org/docs/user-guide/command-line-interface#fix-problems) can automatically fix some of the problems reported by this rule.

This rule is the same rule as core [prefer-template] rule but it applies to the expressions in `<template>`.

## :books: Further Reading

- [prefer-template]

[prefer-template]: https://eslint.org/docs/rules/prefer-template

## :rocket: Version

This rule was introduced in eslint-plugin-vue v7.0.0

## :mag: Implementation

- [Rule source](https://github.com/vuejs/eslint-plugin-vue/blob/master/lib/rules/prefer-template.js)
- [Test source](https://github.com/vuejs/eslint-plugin-vue/blob/master/tests/lib/rules/prefer-template.js)

<sup>Taken with ❤️ [from ESLint core](https://eslint.org/docs/latest/rules/prefer-template)</sup>
