---
pageClass: rule-details
sidebarDepth: 0
title: vue/object-shorthand
description: Require or disallow method and property shorthand syntax for object literals in `<template>`
since: v8.4.0
---

# vue/object-shorthand

> Require or disallow method and property shorthand syntax for object literals in `<template>`

- :wrench: The `--fix` option on the [command line](https://eslint.org/docs/user-guide/command-line-interface#fix-problems) can automatically fix some of the problems reported by this rule.

This rule is the same rule as core [object-shorthand] rule but it applies to the expressions in `<template>`.

## :books: Further Reading

- [object-shorthand]

[object-shorthand]: https://eslint.org/docs/rules/object-shorthand

## :rocket: Version

This rule was introduced in eslint-plugin-vue v8.4.0

## :mag: Implementation

- [Rule source](https://github.com/vuejs/eslint-plugin-vue/blob/master/lib/rules/object-shorthand.js)
- [Test source](https://github.com/vuejs/eslint-plugin-vue/blob/master/tests/lib/rules/object-shorthand.js)

<sup>Taken with ❤️ [from ESLint core](https://eslint.org/docs/latest/rules/object-shorthand)</sup>
