---
pageClass: rule-details
sidebarDepth: 0
title: vue/no-loss-of-precision
description: Disallow literal numbers that lose precision in `<template>`
since: v8.0.0
---

# vue/no-loss-of-precision

> Disallow literal numbers that lose precision in `<template>`

This rule is the same rule as core [no-loss-of-precision] rule but it applies to the expressions in `<template>`.

:::warning
You must be using ESLint v7.1.0 or later to use this rule.
:::

## :books: Further Reading

- [no-loss-of-precision]

[no-loss-of-precision]: https://eslint.org/docs/rules/no-loss-of-precision

## :rocket: Version

This rule was introduced in eslint-plugin-vue v8.0.0

## :mag: Implementation

- [Rule source](https://github.com/vuejs/eslint-plugin-vue/blob/master/lib/rules/no-loss-of-precision.js)
- [Test source](https://github.com/vuejs/eslint-plugin-vue/blob/master/tests/lib/rules/no-loss-of-precision.js)

<sup>Taken with ❤️ [from ESLint core](https://eslint.org/docs/latest/rules/no-loss-of-precision)</sup>
