---
pageClass: rule-details
sidebarDepth: 0
title: vue/no-console
description: Disallow the use of `console` in `<template>`
since: v9.15.0
---

# vue/no-console

> Disallow the use of `console` in `<template>`

- :bulb: Some problems reported by this rule are manually fixable by editor [suggestions](https://eslint.org/docs/developer-guide/working-with-rules#providing-suggestions).

## :book: Rule Details

This rule is the same rule as core [no-console] rule but it applies to the expressions in `<template>`.

## :books: Further Reading

- [no-console]

[no-console]: https://eslint.org/docs/latest/rules/no-console

## :rocket: Version

This rule was introduced in eslint-plugin-vue v9.15.0

## :mag: Implementation

- [Rule source](https://github.com/vuejs/eslint-plugin-vue/blob/master/lib/rules/no-console.js)
- [Test source](https://github.com/vuejs/eslint-plugin-vue/blob/master/tests/lib/rules/no-console.js)

<sup>Taken with ❤️ [from ESLint core](https://eslint.org/docs/latest/rules/no-console)</sup>
