---
sidebarDepth: 0
pageClass: rule-list
---

# Available rules

<!-- This file is automatically generated in tools/update-docs-rules-index.js, do not change! -->

::: tip Legend
  :wrench: Indicates that the rule is fixable, and using `--fix` option on the [command line](https://eslint.org/docs/user-guide/command-line-interface#fix-problems) can automatically fix some of the reported problems.

  :bulb: Indicates that some problems reported by the rule are manually fixable by editor [suggestions](https://eslint.org/docs/developer-guide/working-with-rules#providing-suggestions).
:::

Mark indicating rule type:

- <span class="emoji">:warning:</span> Possible Problems: These rules relate to possible logic errors in code.
- :hammer: Suggestions: These rules suggest alternate ways of doing things.
- :lipstick: Layout & Formatting: These rules care about how the code looks rather than how it executes.

## Base Rules (Enabling Correct ESLint Parsing)

Rules in this category are enabled for all presets provided by eslint-plugin-vue.

<rules-table>

| Rule ID | Description |    |    |
|:--------|:------------|:--:|:--:|
| [vue/comment-directive] | support comment-directives in `<template>` |  | :warning: |
| [vue/jsx-uses-vars] | prevent variables used in JSX to be marked as unused |  | :warning: |

</rules-table>

## Priority A: Essential (Error Prevention)

- :three: Indicates that the rule is for Vue 3 and is included in all of `"plugin:vue/vue3-essential"`, `*.configs["flat/essential"]`, `"plugin:vue/vue3-strongly-recommended"`, `*.configs["flat/strongly-recommended"]`, `"plugin:vue/vue3-recommended"` and `*.configs["flat/recommended"]` presets.
- :two: Indicates that the rule is for Vue 2 and is included in all of `"plugin:vue/essential"`,`*.configs["flat/vue2-essential"]`, `"plugin:vue/strongly-recommended"`,`*.configs["flat/vue2-strongly-recommended"]` and `"plugin:vue/recommended"`,`*.configs["flat/vue2-recommended"]` presets.

<rules-table>

| Rule ID | Description |    |    |
|:--------|:------------|:--:|:--:|
| [vue/multi-word-component-names] | require component names to be always multi-word |  | :three::two::hammer: |
| [vue/no-arrow-functions-in-watch] | disallow using arrow functions to define watcher |  | :three::two::warning: |
| [vue/no-async-in-computed-properties] | disallow asynchronous actions in computed properties |  | :three::two::warning: |
| [vue/no-child-content] | disallow element's child contents which would be overwritten by a directive like `v-html` or `v-text` | :bulb: | :three::two::warning: |
| [vue/no-computed-properties-in-data] | disallow accessing computed properties in `data` |  | :three::two::warning: |
| [vue/no-custom-modifiers-on-v-model] | disallow custom modifiers on v-model used on the component |  | :two::warning: |
| [vue/no-deprecated-data-object-declaration] | disallow using deprecated object declaration on data (in Vue.js 3.0.0+) | :wrench: | :three::warning: |
| [vue/no-deprecated-destroyed-lifecycle] | disallow using deprecated `destroyed` and `beforeDestroy` lifecycle hooks (in Vue.js 3.0.0+) | :wrench: | :three::warning: |
| [vue/no-deprecated-dollar-listeners-api] | disallow using deprecated `$listeners` (in Vue.js 3.0.0+) |  | :three::warning: |
| [vue/no-deprecated-dollar-scopedslots-api] | disallow using deprecated `$scopedSlots` (in Vue.js 3.0.0+) | :wrench: | :three::warning: |
| [vue/no-deprecated-events-api] | disallow using deprecated events api (in Vue.js 3.0.0+) |  | :three::warning: |
| [vue/no-deprecated-filter] | disallow using deprecated filters syntax (in Vue.js 3.0.0+) |  | :three::warning: |
| [vue/no-deprecated-functional-template] | disallow using deprecated the `functional` template (in Vue.js 3.0.0+) |  | :three::warning: |
| [vue/no-deprecated-html-element-is] | disallow using deprecated the `is` attribute on HTML elements (in Vue.js 3.0.0+) |  | :three::warning: |
| [vue/no-deprecated-inline-template] | disallow using deprecated `inline-template` attribute (in Vue.js 3.0.0+) |  | :three::warning: |
| [vue/no-deprecated-props-default-this] | disallow deprecated `this` access in props default function (in Vue.js 3.0.0+) |  | :three::warning: |
| [vue/no-deprecated-router-link-tag-prop] | disallow using deprecated `tag` property on `RouterLink` (in Vue.js 3.0.0+) |  | :three::warning: |
| [vue/no-deprecated-scope-attribute] | disallow deprecated `scope` attribute (in Vue.js 2.5.0+) | :wrench: | :three::hammer: |
| [vue/no-deprecated-slot-attribute] | disallow deprecated `slot` attribute (in Vue.js 2.6.0+) | :wrench: | :three::hammer: |
| [vue/no-deprecated-slot-scope-attribute] | disallow deprecated `slot-scope` attribute (in Vue.js 2.6.0+) | :wrench: | :three::hammer: |
| [vue/no-deprecated-v-bind-sync] | disallow use of deprecated `.sync` modifier on `v-bind` directive (in Vue.js 3.0.0+) | :wrench: | :three::warning: |
| [vue/no-deprecated-v-is] | disallow deprecated `v-is` directive (in Vue.js 3.1.0+) |  | :three::hammer: |
| [vue/no-deprecated-v-on-native-modifier] | disallow using deprecated `.native` modifiers (in Vue.js 3.0.0+) |  | :three::warning: |
| [vue/no-deprecated-v-on-number-modifiers] | disallow using deprecated number (keycode) modifiers (in Vue.js 3.0.0+) | :wrench: | :three::warning: |
| [vue/no-deprecated-vue-config-keycodes] | disallow using deprecated `Vue.config.keyCodes` (in Vue.js 3.0.0+) |  | :three::warning: |
| [vue/no-dupe-keys] | disallow duplication of field names |  | :three::two::warning: |
| [vue/no-dupe-v-else-if] | disallow duplicate conditions in `v-if` / `v-else-if` chains |  | :three::two::warning: |
| [vue/no-duplicate-attributes] | disallow duplication of attributes |  | :three::two::warning: |
| [vue/no-export-in-script-setup] | disallow `export` in `<script setup>` |  | :three::two::warning: |
| [vue/no-expose-after-await] | disallow asynchronously registered `expose` |  | :three::warning: |
| [vue/no-lifecycle-after-await] | disallow asynchronously registered lifecycle hooks |  | :three::hammer: |
| [vue/no-multiple-template-root] | disallow adding multiple root nodes to the template |  | :two::warning: |
| [vue/no-mutating-props] | disallow mutation of component props |  | :three::two::hammer: |
| [vue/no-parsing-error] | disallow parsing errors in `<template>` |  | :three::two::warning: |
| [vue/no-ref-as-operand] | disallow use of value wrapped by `ref()` (Composition API) as an operand | :wrench: | :three::two::hammer: |
| [vue/no-reserved-component-names] | disallow the use of reserved names in component definitions |  | :three::two::hammer: |
| [vue/no-reserved-keys] | disallow overwriting reserved keys |  | :three::two::hammer: |
| [vue/no-reserved-props] | disallow reserved names in props |  | :three::two::warning: |
| [vue/no-shared-component-data] | enforce component's data property to be a function | :wrench: | :three::two::warning: |
| [vue/no-side-effects-in-computed-properties] | disallow side effects in computed properties |  | :three::two::warning: |
| [vue/no-template-key] | disallow `key` attribute on `<template>` |  | :three::two::warning: |
| [vue/no-textarea-mustache] | disallow mustaches in `<textarea>` |  | :three::two::warning: |
| [vue/no-unused-components] | disallow registering components that are not used inside templates |  | :three::two::hammer: |
| [vue/no-unused-vars] | disallow unused variable definitions of v-for directives or scope attributes | :bulb: | :three::two::hammer: |
| [vue/no-use-computed-property-like-method] | disallow use computed property like method |  | :three::two::warning: |
| [vue/no-use-v-if-with-v-for] | disallow using `v-if` on the same element as `v-for` |  | :three::two::hammer: |
| [vue/no-useless-template-attributes] | disallow useless attribute on `<template>` |  | :three::two::warning: |
| [vue/no-v-for-template-key-on-child] | disallow key of `<template v-for>` placed on child elements |  | :three::warning: |
| [vue/no-v-for-template-key] | disallow `key` attribute on `<template v-for>` |  | :two::warning: |
| [vue/no-v-model-argument] | disallow adding an argument to `v-model` used in custom component |  | :two::warning: |
| [vue/no-v-text-v-html-on-component] | disallow v-text / v-html on component |  | :three::two::warning: |
| [vue/no-watch-after-await] | disallow asynchronously registered `watch` |  | :three::hammer: |
| [vue/prefer-import-from-vue] | enforce import from 'vue' instead of import from '@vue/*' | :wrench: | :three::hammer: |
| [vue/require-component-is] | require `v-bind:is` of `<component>` elements |  | :three::two::warning: |
| [vue/require-prop-type-constructor] | require prop type to be a constructor | :wrench: | :three::two::hammer: |
| [vue/require-render-return] | enforce render function to always return value |  | :three::two::warning: |
| [vue/require-slots-as-functions] | enforce properties of `$slots` to be used as a function |  | :three::warning: |
| [vue/require-toggle-inside-transition] | require control the display of the content inside `<transition>` |  | :three::warning: |
| [vue/require-v-for-key] | require `v-bind:key` with `v-for` directives |  | :three::two::warning: |
| [vue/require-valid-default-prop] | enforce props default values to be valid |  | :three::two::hammer: |
| [vue/return-in-computed-property] | enforce that a return statement is present in computed property |  | :three::two::warning: |
| [vue/return-in-emits-validator] | enforce that a return statement is present in emits validator |  | :three::two::warning: |
| [vue/use-v-on-exact] | enforce usage of `exact` modifier on `v-on` |  | :three::two::hammer: |
| [vue/valid-attribute-name] | require valid attribute names |  | :three::two::warning: |
| [vue/valid-define-emits] | enforce valid `defineEmits` compiler macro |  | :three::two::warning: |
| [vue/valid-define-props] | enforce valid `defineProps` compiler macro |  | :three::two::warning: |
| [vue/valid-model-definition] | require valid keys in model option |  | :two::warning: |
| [vue/valid-next-tick] | enforce valid `nextTick` function calls | :wrench::bulb: | :three::two::warning: |
| [vue/valid-template-root] | enforce valid template root |  | :three::two::warning: |
| [vue/valid-v-bind-sync] | enforce valid `.sync` modifier on `v-bind` directives |  | :two::warning: |
| [vue/valid-v-bind] | enforce valid `v-bind` directives |  | :three::two::warning: |
| [vue/valid-v-cloak] | enforce valid `v-cloak` directives |  | :three::two::warning: |
| [vue/valid-v-else-if] | enforce valid `v-else-if` directives |  | :three::two::warning: |
| [vue/valid-v-else] | enforce valid `v-else` directives |  | :three::two::warning: |
| [vue/valid-v-for] | enforce valid `v-for` directives |  | :three::two::warning: |
| [vue/valid-v-html] | enforce valid `v-html` directives |  | :three::two::warning: |
| [vue/valid-v-if] | enforce valid `v-if` directives |  | :three::two::warning: |
| [vue/valid-v-is] | enforce valid `v-is` directives |  | :three::warning: |
| [vue/valid-v-memo] | enforce valid `v-memo` directives |  | :three::warning: |
| [vue/valid-v-model] | enforce valid `v-model` directives |  | :three::two::warning: |
| [vue/valid-v-on] | enforce valid `v-on` directives |  | :three::two::warning: |
| [vue/valid-v-once] | enforce valid `v-once` directives |  | :three::two::warning: |
| [vue/valid-v-pre] | enforce valid `v-pre` directives |  | :three::two::warning: |
| [vue/valid-v-show] | enforce valid `v-show` directives |  | :three::two::warning: |
| [vue/valid-v-slot] | enforce valid `v-slot` directives |  | :three::two::warning: |
| [vue/valid-v-text] | enforce valid `v-text` directives |  | :three::two::warning: |

</rules-table>

## Priority B: Strongly Recommended (Improving Readability)

- :three: Indicates that the rule is for Vue 3 and is included in all of `"plugin:vue/vue3-strongly-recommended"`, `*.configs["flat/strongly-recommended"]`, `"plugin:vue/vue3-recommended"` and `*.configs["flat/recommended"]` presets.
- :two: Indicates that the rule is for Vue 2 and is included in `"plugin:vue/strongly-recommended"`,`*.configs["flat/vue2-strongly-recommended"]` and `"plugin:vue/recommended"`,`*.configs["flat/vue2-recommended"]` presets.

<rules-table>

| Rule ID | Description |    |    |
|:--------|:------------|:--:|:--:|
| [vue/attribute-hyphenation] | enforce attribute naming style on custom components in template | :wrench: | :three::two::hammer: |
| [vue/component-definition-name-casing] | enforce specific casing for component definition name | :wrench: | :three::two::hammer: |
| [vue/first-attribute-linebreak] | enforce the location of first attribute | :wrench: | :three::two::lipstick: |
| [vue/html-closing-bracket-newline] | require or disallow a line break before tag's closing brackets | :wrench: | :three::two::lipstick: |
| [vue/html-closing-bracket-spacing] | require or disallow a space before tag's closing brackets | :wrench: | :three::two::lipstick: |
| [vue/html-end-tags] | enforce end tag style | :wrench: | :three::two::hammer: |
| [vue/html-indent] | enforce consistent indentation in `<template>` | :wrench: | :three::two::lipstick: |
| [vue/html-quotes] | enforce quotes style of HTML attributes | :wrench: | :three::two::lipstick: |
| [vue/html-self-closing] | enforce self-closing style | :wrench: | :three::two::lipstick: |
| [vue/max-attributes-per-line] | enforce the maximum number of attributes per line | :wrench: | :three::two::lipstick: |
| [vue/multiline-html-element-content-newline] | require a line break before and after the contents of a multiline element | :wrench: | :three::two::lipstick: |
| [vue/mustache-interpolation-spacing] | enforce unified spacing in mustache interpolations | :wrench: | :three::two::lipstick: |
| [vue/no-multi-spaces] | disallow multiple spaces | :wrench: | :three::two::lipstick: |
| [vue/no-spaces-around-equal-signs-in-attribute] | disallow spaces around equal signs in attribute | :wrench: | :three::two::lipstick: |
| [vue/no-template-shadow] | disallow variable declarations from shadowing variables declared in the outer scope |  | :three::two::hammer: |
| [vue/one-component-per-file] | enforce that each component should be in its own file |  | :three::two::hammer: |
| [vue/prop-name-casing] | enforce specific casing for the Prop name in Vue components |  | :three::two::hammer: |
| [vue/require-default-prop] | require default value for props |  | :three::two::hammer: |
| [vue/require-explicit-emits] | require `emits` option with name triggered by `$emit()` | :bulb: | :three::hammer: |
| [vue/require-prop-types] | require type definitions in props |  | :three::two::hammer: |
| [vue/singleline-html-element-content-newline] | require a line break before and after the contents of a singleline element | :wrench: | :three::two::lipstick: |
| [vue/v-bind-style] | enforce `v-bind` directive style | :wrench: | :three::two::hammer: |
| [vue/v-on-event-hyphenation] | enforce v-on event naming style on custom components in template | :wrench: | :three::hammer: |
| [vue/v-on-style] | enforce `v-on` directive style | :wrench: | :three::two::hammer: |
| [vue/v-slot-style] | enforce `v-slot` directive style | :wrench: | :three::two::hammer: |

</rules-table>

## Priority C: Recommended (Potentially Dangerous Patterns)

- :three: Indicates that the rule is for Vue 3 and is included in `"plugin:vue/vue3-recommended"` and `*.configs["flat/recommended"]` presets.
- :two: Indicates that the rule is for Vue 2 and is included in `"plugin:vue/recommended"`,`*.configs["flat/vue2-recommended"]` preset.

<rules-table>

| Rule ID | Description |    |    |
|:--------|:------------|:--:|:--:|
| [vue/attributes-order] | enforce order of attributes | :wrench: | :three::two::hammer: |
| [vue/component-tags-order] | enforce order of component top-level elements | :wrench::no_entry_sign: | :three::two::hammer: |
| [vue/no-lone-template] | disallow unnecessary `<template>` |  | :three::two::warning: |
| [vue/no-multiple-slot-args] | disallow passing multiple arguments to scoped slots |  | :three::two::warning: |
| [vue/no-v-html] | disallow use of v-html to prevent XSS attack |  | :three::two::hammer: |
| [vue/order-in-components] | enforce order of properties in components | :wrench::bulb: | :three::two::hammer: |
| [vue/this-in-template] | disallow usage of `this` in template | :wrench: | :three::two::hammer: |

</rules-table>

## Uncategorized

No preset enables the rules in this category.
Please enable each rule if you want.

For example:

```json
{
  "rules": {
    "vue/block-lang": "error"
  }
}
```

<rules-table>

| Rule ID | Description |    |    |
|:--------|:------------|:--:|:--:|
| [vue/block-lang] | disallow use other than available `lang` |  | :hammer: |
| [vue/block-order] | enforce order of component top-level elements | :wrench: | :hammer: |
| [vue/block-tag-newline] | enforce line breaks after opening and before closing block-level tags | :wrench: | :lipstick: |
| [vue/component-api-style] | enforce component API style |  | :hammer: |
| [vue/component-name-in-template-casing] | enforce specific casing for the component naming style in template | :wrench: | :hammer: |
| [vue/component-options-name-casing] | enforce the casing of component name in `components` options | :wrench::bulb: | :hammer: |
| [vue/custom-event-name-casing] | enforce specific casing for custom event name |  | :hammer: |
| [vue/define-emits-declaration] | enforce declaration style of `defineEmits` |  | :hammer: |
| [vue/define-macros-order] | enforce order of compiler macros (`defineProps`, `defineEmits`, etc.) | :wrench::bulb: | :lipstick: |
| [vue/define-props-declaration] | enforce declaration style of `defineProps` |  | :hammer: |
| [vue/enforce-style-attribute] | enforce or forbid the use of the `scoped` and `module` attributes in SFC top level style tags |  | :hammer: |
| [vue/html-button-has-type] | disallow usage of button without an explicit type attribute |  | :hammer: |
| [vue/html-comment-content-newline] | enforce unified line break in HTML comments | :wrench: | :lipstick: |
| [vue/html-comment-content-spacing] | enforce unified spacing in HTML comments | :wrench: | :lipstick: |
| [vue/html-comment-indent] | enforce consistent indentation in HTML comments | :wrench: | :lipstick: |
| [vue/match-component-file-name] | require component name property to match its file name | :bulb: | :hammer: |
| [vue/match-component-import-name] | require the registered component name to match the imported component name |  | :warning: |
| [vue/max-lines-per-block] | enforce maximum number of lines in Vue SFC blocks |  | :warning: |
| [vue/max-props] | enforce maximum number of props in Vue component |  | :warning: |
| [vue/max-template-depth] | enforce maximum depth of template |  | :warning: |
| [vue/new-line-between-multi-line-property] | enforce new lines between multi-line properties in Vue components | :wrench: | :lipstick: |
| [vue/next-tick-style] | enforce Promise or callback style in `nextTick` | :wrench: | :hammer: |
| [vue/no-bare-strings-in-template] | disallow the use of bare strings in `<template>` |  | :hammer: |
| [vue/no-boolean-default] | disallow boolean defaults |  | :hammer: |
| [vue/no-deprecated-delete-set] | disallow using deprecated `$delete` and `$set` (in Vue.js 3.0.0+) |  | :warning: |
| [vue/no-deprecated-model-definition] | disallow deprecated `model` definition (in Vue.js 3.0.0+) | :bulb: | :warning: |
| [vue/no-duplicate-attr-inheritance] | enforce `inheritAttrs` to be set to `false` when using `v-bind="$attrs"` |  | :hammer: |
| [vue/no-empty-component-block] | disallow the `<template>` `<script>` `<style>` block to be empty | :wrench: | :hammer: |
| [vue/no-multiple-objects-in-class] | disallow passing multiple objects in an array to class |  | :hammer: |
| [vue/no-potential-component-option-typo] | disallow a potential typo in your component property | :bulb: | :hammer: |
| [vue/no-ref-object-reactivity-loss] | disallow usages of ref objects that can lead to loss of reactivity |  | :warning: |
| [vue/no-required-prop-with-default] | enforce props with default values to be optional | :wrench::bulb: | :warning: |
| [vue/no-restricted-block] | disallow specific block |  | :hammer: |
| [vue/no-restricted-call-after-await] | disallow asynchronously called restricted methods |  | :hammer: |
| [vue/no-restricted-class] | disallow specific classes in Vue components |  | :warning: |
| [vue/no-restricted-component-names] | disallow specific component names | :bulb: | :hammer: |
| [vue/no-restricted-component-options] | disallow specific component option |  | :hammer: |
| [vue/no-restricted-custom-event] | disallow specific custom event | :bulb: | :hammer: |
| [vue/no-restricted-html-elements] | disallow specific HTML elements |  | :hammer: |
| [vue/no-restricted-props] | disallow specific props | :bulb: | :hammer: |
| [vue/no-restricted-static-attribute] | disallow specific attribute |  | :hammer: |
| [vue/no-restricted-v-bind] | disallow specific argument in `v-bind` |  | :hammer: |
| [vue/no-restricted-v-on] | disallow specific argument in `v-on` |  | :hammer: |
| [vue/no-root-v-if] | disallow `v-if` directives on root element |  | :hammer: |
| [vue/no-setup-props-reactivity-loss] | disallow usages that lose the reactivity of `props` passed to `setup` |  | :hammer: |
| [vue/no-static-inline-styles] | disallow static inline `style` attributes |  | :hammer: |
| [vue/no-template-target-blank] | disallow target="_blank" attribute without rel="noopener noreferrer" | :bulb: | :warning: |
| [vue/no-this-in-before-route-enter] | disallow `this` usage in a `beforeRouteEnter` method |  | :warning: |
| [vue/no-undef-components] | disallow use of undefined components in `<template>` |  | :hammer: |
| [vue/no-undef-properties] | disallow undefined properties |  | :hammer: |
| [vue/no-unsupported-features] | disallow unsupported Vue.js syntax on the specified version | :wrench: | :hammer: |
| [vue/no-unused-emit-declarations] | disallow unused emit declarations |  | :hammer: |
| [vue/no-unused-properties] | disallow unused properties |  | :hammer: |
| [vue/no-unused-refs] | disallow unused refs |  | :hammer: |
| [vue/no-use-v-else-with-v-for] | disallow using `v-else-if`/`v-else` on the same element as `v-for` |  | :hammer: |
| [vue/no-useless-mustaches] | disallow unnecessary mustache interpolations | :wrench: | :hammer: |
| [vue/no-useless-v-bind] | disallow unnecessary `v-bind` directives | :wrench: | :hammer: |
| [vue/no-v-text] | disallow use of v-text |  | :hammer: |
| [vue/padding-line-between-blocks] | require or disallow padding lines between blocks | :wrench: | :lipstick: |
| [vue/padding-line-between-tags] | require or disallow newlines between sibling tags in template | :wrench: | :lipstick: |
| [vue/padding-lines-in-component-definition] | require or disallow padding lines in component definition | :wrench: | :lipstick: |
| [vue/prefer-define-options] | enforce use of `defineOptions` instead of default export | :wrench: | :hammer: |
| [vue/prefer-prop-type-boolean-first] | enforce `Boolean` comes first in component prop types | :bulb: | :warning: |
| [vue/prefer-separate-static-class] | require static class names in template to be in a separate `class` attribute | :wrench: | :hammer: |
| [vue/prefer-true-attribute-shorthand] | require shorthand form attribute when `v-bind` value is `true` | :bulb: | :hammer: |
| [vue/prefer-use-template-ref] | require using `useTemplateRef` instead of `ref`/`shallowRef` for template refs |  | :hammer: |
| [vue/require-default-export] | require components to be the default export |  | :warning: |
| [vue/require-direct-export] | require the component to be directly exported |  | :hammer: |
| [vue/require-emit-validator] | require type definitions in emits | :bulb: | :hammer: |
| [vue/require-explicit-slots] | require slots to be explicitly defined |  | :warning: |
| [vue/require-expose] | require declare public properties using `expose` | :bulb: | :hammer: |
| [vue/require-macro-variable-name] | require a certain macro variable name | :bulb: | :hammer: |
| [vue/require-name-property] | require a name property in Vue components | :bulb: | :hammer: |
| [vue/require-prop-comment] | require props to have a comment |  | :hammer: |
| [vue/require-typed-object-prop] | enforce adding type declarations to object props | :bulb: | :hammer: |
| [vue/require-typed-ref] | require `ref` and `shallowRef` functions to be strongly typed |  | :hammer: |
| [vue/restricted-component-names] | enforce using only specific component names |  | :warning: |
| [vue/script-indent] | enforce consistent indentation in `<script>` | :wrench: | :lipstick: |
| [vue/slot-name-casing] | enforce specific casing for slot names |  | :hammer: |
| [vue/sort-keys] | enforce sort-keys in a manner that is compatible with order-in-components |  | :hammer: |
| [vue/static-class-names-order] | enforce static class names order | :wrench: | :hammer: |
| [vue/v-for-delimiter-style] | enforce `v-for` directive's delimiter style | :wrench: | :lipstick: |
| [vue/v-if-else-key] | require key attribute for conditionally rendered repeated components | :wrench: | :warning: |
| [vue/v-on-handler-style] | enforce writing style for handlers in `v-on` directives | :wrench: | :hammer: |
| [vue/valid-define-options] | enforce valid `defineOptions` compiler macro |  | :warning: |

</rules-table>

### Extension Rules

The following rules extend the rules provided by ESLint itself and apply them to the expressions in the `<template>`.

<rules-table>

| Rule ID | Description |    |    |
|:--------|:------------|:--:|:--:|
| [vue/array-bracket-newline] | Enforce linebreaks after opening and before closing array brackets in `<template>` | :wrench: | :lipstick: |
| [vue/array-bracket-spacing] | Enforce consistent spacing inside array brackets in `<template>` | :wrench: | :lipstick: |
| [vue/array-element-newline] | Enforce line breaks after each array element in `<template>` | :wrench: | :lipstick: |
| [vue/arrow-spacing] | Enforce consistent spacing before and after the arrow in arrow functions in `<template>` | :wrench: | :lipstick: |
| [vue/block-spacing] | Disallow or enforce spaces inside of blocks after opening block and before closing block in `<template>` | :wrench: | :lipstick: |
| [vue/brace-style] | Enforce consistent brace style for blocks in `<template>` | :wrench: | :lipstick: |
| [vue/camelcase] | Enforce camelcase naming convention in `<template>` |  | :hammer: |
| [vue/comma-dangle] | Require or disallow trailing commas in `<template>` | :wrench: | :lipstick: |
| [vue/comma-spacing] | Enforce consistent spacing before and after commas in `<template>` | :wrench: | :lipstick: |
| [vue/comma-style] | Enforce consistent comma style in `<template>` | :wrench: | :lipstick: |
| [vue/dot-location] | Enforce consistent newlines before and after dots in `<template>` | :wrench: | :lipstick: |
| [vue/dot-notation] | Enforce dot notation whenever possible in `<template>` | :wrench: | :hammer: |
| [vue/eqeqeq] | Require the use of `===` and `!==` in `<template>` | :wrench: | :hammer: |
| [vue/func-call-spacing] | Require or disallow spacing between function identifiers and their invocations in `<template>` | :wrench: | :lipstick: |
| [vue/key-spacing] | Enforce consistent spacing between property names and type annotations in types and interfaces in `<template>` | :wrench: | :lipstick: |
| [vue/keyword-spacing] | Enforce consistent spacing before and after keywords in `<template>` | :wrench: | :lipstick: |
| [vue/max-len] | enforce a maximum line length in `.vue` files |  | :lipstick: |
| [vue/multiline-ternary] | Enforce newlines between operands of ternary expressions in `<template>` | :wrench: | :lipstick: |
| [vue/no-console] | Disallow the use of `console` in `<template>` | :bulb: | :hammer: |
| [vue/no-constant-condition] | Disallow constant expressions in conditions in `<template>` |  | :warning: |
| [vue/no-empty-pattern] | Disallow empty destructuring patterns in `<template>` |  | :warning: |
| [vue/no-extra-parens] | Disallow unnecessary parentheses in `<template>` | :wrench: | :lipstick: |
| [vue/no-irregular-whitespace] | disallow irregular whitespace in `.vue` files |  | :warning: |
| [vue/no-loss-of-precision] | Disallow literal numbers that lose precision in `<template>` |  | :warning: |
| [vue/no-restricted-syntax] | Disallow specified syntax in `<template>` |  | :hammer: |
| [vue/no-sparse-arrays] | Disallow sparse arrays in `<template>` |  | :warning: |
| [vue/no-useless-concat] | Disallow unnecessary concatenation of literals or template literals in `<template>` |  | :hammer: |
| [vue/object-curly-newline] | Enforce consistent line breaks after opening and before closing braces in `<template>` | :wrench: | :lipstick: |
| [vue/object-curly-spacing] | Enforce consistent spacing inside braces in `<template>` | :wrench: | :lipstick: |
| [vue/object-property-newline] | Enforce placing object properties on separate lines in `<template>` | :wrench: | :lipstick: |
| [vue/object-shorthand] | Require or disallow method and property shorthand syntax for object literals in `<template>` | :wrench: | :hammer: |
| [vue/operator-linebreak] | Enforce consistent linebreak style for operators in `<template>` | :wrench: | :lipstick: |
| [vue/prefer-template] | Require template literals instead of string concatenation in `<template>` | :wrench: | :hammer: |
| [vue/quote-props] | Require quotes around object literal, type literal, interfaces and enums property names in `<template>` | :wrench: | :lipstick: |
| [vue/space-in-parens] | Enforce consistent spacing inside parentheses in `<template>` | :wrench: | :lipstick: |
| [vue/space-infix-ops] | Require spacing around infix operators in `<template>` | :wrench: | :lipstick: |
| [vue/space-unary-ops] | Enforce consistent spacing before or after unary operators in `<template>` | :wrench: | :lipstick: |
| [vue/template-curly-spacing] | Require or disallow spacing around embedded expressions of template strings in `<template>` | :wrench: | :lipstick: |

</rules-table>

## Deprecated

- :no_entry_sign: We're going to remove deprecated rules in the next major release. Please migrate to successor/new rules.
- :innocent: We don't fix bugs which are in deprecated rules since we don't have enough resources.

| Rule ID | Replaced by |
|:--------|:------------|
| [vue/component-tags-order] | [vue/block-order] |
| [vue/no-invalid-model-keys] | [vue/valid-model-definition] |
| [vue/no-ref-object-destructure] | [vue/no-ref-object-reactivity-loss] |
| [vue/no-setup-props-destructure] | [vue/no-setup-props-reactivity-loss] |
| [vue/script-setup-uses-vars] | (no replacement) |
| [vue/v-on-function-call] | [vue/v-on-handler-style] |

## Removed

- :no_entry: These rules have been removed in a previous major release, after they have been deprecated for a while.

| Rule ID | Replaced by | Deprecated in version  | Removed in version |
|:--------|:------------|:-----------------------|:-------------------|
| [vue/experimental-script-setup-vars] | (no replacement) | [v7.13.0] | [v9.0.0] |
| [vue/name-property-casing] | [vue/component-definition-name-casing] | [v7.0.0] | [v9.0.0] |
| [vue/no-confusing-v-for-v-if] | [vue/no-use-v-if-with-v-for] | [v5.0.0] | [v9.0.0] |
| [vue/no-unregistered-components] | [vue/no-undef-components] | [v8.4.0] | [v9.0.0] |

<!-- link definitions for rules -->

[vue/array-bracket-newline]: ./array-bracket-newline.md
[vue/array-bracket-spacing]: ./array-bracket-spacing.md
[vue/array-element-newline]: ./array-element-newline.md
[vue/arrow-spacing]: ./arrow-spacing.md
[vue/attribute-hyphenation]: ./attribute-hyphenation.md
[vue/attributes-order]: ./attributes-order.md
[vue/block-lang]: ./block-lang.md
[vue/block-order]: ./block-order.md
[vue/block-spacing]: ./block-spacing.md
[vue/block-tag-newline]: ./block-tag-newline.md
[vue/brace-style]: ./brace-style.md
[vue/camelcase]: ./camelcase.md
[vue/comma-dangle]: ./comma-dangle.md
[vue/comma-spacing]: ./comma-spacing.md
[vue/comma-style]: ./comma-style.md
[vue/comment-directive]: ./comment-directive.md
[vue/component-api-style]: ./component-api-style.md
[vue/component-definition-name-casing]: ./component-definition-name-casing.md
[vue/component-name-in-template-casing]: ./component-name-in-template-casing.md
[vue/component-options-name-casing]: ./component-options-name-casing.md
[vue/component-tags-order]: ./component-tags-order.md
[vue/custom-event-name-casing]: ./custom-event-name-casing.md
[vue/define-emits-declaration]: ./define-emits-declaration.md
[vue/define-macros-order]: ./define-macros-order.md
[vue/define-props-declaration]: ./define-props-declaration.md
[vue/dot-location]: ./dot-location.md
[vue/dot-notation]: ./dot-notation.md
[vue/enforce-style-attribute]: ./enforce-style-attribute.md
[vue/eqeqeq]: ./eqeqeq.md
[vue/first-attribute-linebreak]: ./first-attribute-linebreak.md
[vue/func-call-spacing]: ./func-call-spacing.md
[vue/html-button-has-type]: ./html-button-has-type.md
[vue/html-closing-bracket-newline]: ./html-closing-bracket-newline.md
[vue/html-closing-bracket-spacing]: ./html-closing-bracket-spacing.md
[vue/html-comment-content-newline]: ./html-comment-content-newline.md
[vue/html-comment-content-spacing]: ./html-comment-content-spacing.md
[vue/html-comment-indent]: ./html-comment-indent.md
[vue/html-end-tags]: ./html-end-tags.md
[vue/html-indent]: ./html-indent.md
[vue/html-quotes]: ./html-quotes.md
[vue/html-self-closing]: ./html-self-closing.md
[vue/jsx-uses-vars]: ./jsx-uses-vars.md
[vue/key-spacing]: ./key-spacing.md
[vue/keyword-spacing]: ./keyword-spacing.md
[vue/match-component-file-name]: ./match-component-file-name.md
[vue/match-component-import-name]: ./match-component-import-name.md
[vue/max-attributes-per-line]: ./max-attributes-per-line.md
[vue/max-len]: ./max-len.md
[vue/max-lines-per-block]: ./max-lines-per-block.md
[vue/max-props]: ./max-props.md
[vue/max-template-depth]: ./max-template-depth.md
[vue/multi-word-component-names]: ./multi-word-component-names.md
[vue/multiline-html-element-content-newline]: ./multiline-html-element-content-newline.md
[vue/multiline-ternary]: ./multiline-ternary.md
[vue/mustache-interpolation-spacing]: ./mustache-interpolation-spacing.md
[vue/new-line-between-multi-line-property]: ./new-line-between-multi-line-property.md
[vue/next-tick-style]: ./next-tick-style.md
[vue/no-arrow-functions-in-watch]: ./no-arrow-functions-in-watch.md
[vue/no-async-in-computed-properties]: ./no-async-in-computed-properties.md
[vue/no-bare-strings-in-template]: ./no-bare-strings-in-template.md
[vue/no-boolean-default]: ./no-boolean-default.md
[vue/no-child-content]: ./no-child-content.md
[vue/no-computed-properties-in-data]: ./no-computed-properties-in-data.md
[vue/no-console]: ./no-console.md
[vue/no-constant-condition]: ./no-constant-condition.md
[vue/no-custom-modifiers-on-v-model]: ./no-custom-modifiers-on-v-model.md
[vue/no-deprecated-data-object-declaration]: ./no-deprecated-data-object-declaration.md
[vue/no-deprecated-delete-set]: ./no-deprecated-delete-set.md
[vue/no-deprecated-destroyed-lifecycle]: ./no-deprecated-destroyed-lifecycle.md
[vue/no-deprecated-dollar-listeners-api]: ./no-deprecated-dollar-listeners-api.md
[vue/no-deprecated-dollar-scopedslots-api]: ./no-deprecated-dollar-scopedslots-api.md
[vue/no-deprecated-events-api]: ./no-deprecated-events-api.md
[vue/no-deprecated-filter]: ./no-deprecated-filter.md
[vue/no-deprecated-functional-template]: ./no-deprecated-functional-template.md
[vue/no-deprecated-html-element-is]: ./no-deprecated-html-element-is.md
[vue/no-deprecated-inline-template]: ./no-deprecated-inline-template.md
[vue/no-deprecated-model-definition]: ./no-deprecated-model-definition.md
[vue/no-deprecated-props-default-this]: ./no-deprecated-props-default-this.md
[vue/no-deprecated-router-link-tag-prop]: ./no-deprecated-router-link-tag-prop.md
[vue/no-deprecated-scope-attribute]: ./no-deprecated-scope-attribute.md
[vue/no-deprecated-slot-attribute]: ./no-deprecated-slot-attribute.md
[vue/no-deprecated-slot-scope-attribute]: ./no-deprecated-slot-scope-attribute.md
[vue/no-deprecated-v-bind-sync]: ./no-deprecated-v-bind-sync.md
[vue/no-deprecated-v-is]: ./no-deprecated-v-is.md
[vue/no-deprecated-v-on-native-modifier]: ./no-deprecated-v-on-native-modifier.md
[vue/no-deprecated-v-on-number-modifiers]: ./no-deprecated-v-on-number-modifiers.md
[vue/no-deprecated-vue-config-keycodes]: ./no-deprecated-vue-config-keycodes.md
[vue/no-dupe-keys]: ./no-dupe-keys.md
[vue/no-dupe-v-else-if]: ./no-dupe-v-else-if.md
[vue/no-duplicate-attr-inheritance]: ./no-duplicate-attr-inheritance.md
[vue/no-duplicate-attributes]: ./no-duplicate-attributes.md
[vue/no-empty-component-block]: ./no-empty-component-block.md
[vue/no-empty-pattern]: ./no-empty-pattern.md
[vue/no-export-in-script-setup]: ./no-export-in-script-setup.md
[vue/no-expose-after-await]: ./no-expose-after-await.md
[vue/no-extra-parens]: ./no-extra-parens.md
[vue/no-invalid-model-keys]: ./no-invalid-model-keys.md
[vue/no-irregular-whitespace]: ./no-irregular-whitespace.md
[vue/no-lifecycle-after-await]: ./no-lifecycle-after-await.md
[vue/no-lone-template]: ./no-lone-template.md
[vue/no-loss-of-precision]: ./no-loss-of-precision.md
[vue/no-multi-spaces]: ./no-multi-spaces.md
[vue/no-multiple-objects-in-class]: ./no-multiple-objects-in-class.md
[vue/no-multiple-slot-args]: ./no-multiple-slot-args.md
[vue/no-multiple-template-root]: ./no-multiple-template-root.md
[vue/no-mutating-props]: ./no-mutating-props.md
[vue/no-parsing-error]: ./no-parsing-error.md
[vue/no-potential-component-option-typo]: ./no-potential-component-option-typo.md
[vue/no-ref-as-operand]: ./no-ref-as-operand.md
[vue/no-ref-object-destructure]: ./no-ref-object-destructure.md
[vue/no-ref-object-reactivity-loss]: ./no-ref-object-reactivity-loss.md
[vue/no-required-prop-with-default]: ./no-required-prop-with-default.md
[vue/no-reserved-component-names]: ./no-reserved-component-names.md
[vue/no-reserved-keys]: ./no-reserved-keys.md
[vue/no-reserved-props]: ./no-reserved-props.md
[vue/no-restricted-block]: ./no-restricted-block.md
[vue/no-restricted-call-after-await]: ./no-restricted-call-after-await.md
[vue/no-restricted-class]: ./no-restricted-class.md
[vue/no-restricted-component-names]: ./no-restricted-component-names.md
[vue/no-restricted-component-options]: ./no-restricted-component-options.md
[vue/no-restricted-custom-event]: ./no-restricted-custom-event.md
[vue/no-restricted-html-elements]: ./no-restricted-html-elements.md
[vue/no-restricted-props]: ./no-restricted-props.md
[vue/no-restricted-static-attribute]: ./no-restricted-static-attribute.md
[vue/no-restricted-syntax]: ./no-restricted-syntax.md
[vue/no-restricted-v-bind]: ./no-restricted-v-bind.md
[vue/no-restricted-v-on]: ./no-restricted-v-on.md
[vue/no-root-v-if]: ./no-root-v-if.md
[vue/no-setup-props-destructure]: ./no-setup-props-destructure.md
[vue/no-setup-props-reactivity-loss]: ./no-setup-props-reactivity-loss.md
[vue/no-shared-component-data]: ./no-shared-component-data.md
[vue/no-side-effects-in-computed-properties]: ./no-side-effects-in-computed-properties.md
[vue/no-spaces-around-equal-signs-in-attribute]: ./no-spaces-around-equal-signs-in-attribute.md
[vue/no-sparse-arrays]: ./no-sparse-arrays.md
[vue/no-static-inline-styles]: ./no-static-inline-styles.md
[vue/no-template-key]: ./no-template-key.md
[vue/no-template-shadow]: ./no-template-shadow.md
[vue/no-template-target-blank]: ./no-template-target-blank.md
[vue/no-textarea-mustache]: ./no-textarea-mustache.md
[vue/no-this-in-before-route-enter]: ./no-this-in-before-route-enter.md
[vue/no-undef-components]: ./no-undef-components.md
[vue/no-undef-properties]: ./no-undef-properties.md
[vue/no-unsupported-features]: ./no-unsupported-features.md
[vue/no-unused-components]: ./no-unused-components.md
[vue/no-unused-emit-declarations]: ./no-unused-emit-declarations.md
[vue/no-unused-properties]: ./no-unused-properties.md
[vue/no-unused-refs]: ./no-unused-refs.md
[vue/no-unused-vars]: ./no-unused-vars.md
[vue/no-use-computed-property-like-method]: ./no-use-computed-property-like-method.md
[vue/no-use-v-else-with-v-for]: ./no-use-v-else-with-v-for.md
[vue/no-use-v-if-with-v-for]: ./no-use-v-if-with-v-for.md
[vue/no-useless-concat]: ./no-useless-concat.md
[vue/no-useless-mustaches]: ./no-useless-mustaches.md
[vue/no-useless-template-attributes]: ./no-useless-template-attributes.md
[vue/no-useless-v-bind]: ./no-useless-v-bind.md
[vue/no-v-for-template-key-on-child]: ./no-v-for-template-key-on-child.md
[vue/no-v-for-template-key]: ./no-v-for-template-key.md
[vue/no-v-html]: ./no-v-html.md
[vue/no-v-model-argument]: ./no-v-model-argument.md
[vue/no-v-text-v-html-on-component]: ./no-v-text-v-html-on-component.md
[vue/no-v-text]: ./no-v-text.md
[vue/no-watch-after-await]: ./no-watch-after-await.md
[vue/object-curly-newline]: ./object-curly-newline.md
[vue/object-curly-spacing]: ./object-curly-spacing.md
[vue/object-property-newline]: ./object-property-newline.md
[vue/object-shorthand]: ./object-shorthand.md
[vue/one-component-per-file]: ./one-component-per-file.md
[vue/operator-linebreak]: ./operator-linebreak.md
[vue/order-in-components]: ./order-in-components.md
[vue/padding-line-between-blocks]: ./padding-line-between-blocks.md
[vue/padding-line-between-tags]: ./padding-line-between-tags.md
[vue/padding-lines-in-component-definition]: ./padding-lines-in-component-definition.md
[vue/prefer-define-options]: ./prefer-define-options.md
[vue/prefer-import-from-vue]: ./prefer-import-from-vue.md
[vue/prefer-prop-type-boolean-first]: ./prefer-prop-type-boolean-first.md
[vue/prefer-separate-static-class]: ./prefer-separate-static-class.md
[vue/prefer-template]: ./prefer-template.md
[vue/prefer-true-attribute-shorthand]: ./prefer-true-attribute-shorthand.md
[vue/prefer-use-template-ref]: ./prefer-use-template-ref.md
[vue/prop-name-casing]: ./prop-name-casing.md
[vue/quote-props]: ./quote-props.md
[vue/require-component-is]: ./require-component-is.md
[vue/require-default-export]: ./require-default-export.md
[vue/require-default-prop]: ./require-default-prop.md
[vue/require-direct-export]: ./require-direct-export.md
[vue/require-emit-validator]: ./require-emit-validator.md
[vue/require-explicit-emits]: ./require-explicit-emits.md
[vue/require-explicit-slots]: ./require-explicit-slots.md
[vue/require-expose]: ./require-expose.md
[vue/require-macro-variable-name]: ./require-macro-variable-name.md
[vue/require-name-property]: ./require-name-property.md
[vue/require-prop-comment]: ./require-prop-comment.md
[vue/require-prop-type-constructor]: ./require-prop-type-constructor.md
[vue/require-prop-types]: ./require-prop-types.md
[vue/require-render-return]: ./require-render-return.md
[vue/require-slots-as-functions]: ./require-slots-as-functions.md
[vue/require-toggle-inside-transition]: ./require-toggle-inside-transition.md
[vue/require-typed-object-prop]: ./require-typed-object-prop.md
[vue/require-typed-ref]: ./require-typed-ref.md
[vue/require-v-for-key]: ./require-v-for-key.md
[vue/require-valid-default-prop]: ./require-valid-default-prop.md
[vue/restricted-component-names]: ./restricted-component-names.md
[vue/return-in-computed-property]: ./return-in-computed-property.md
[vue/return-in-emits-validator]: ./return-in-emits-validator.md
[vue/script-indent]: ./script-indent.md
[vue/script-setup-uses-vars]: ./script-setup-uses-vars.md
[vue/singleline-html-element-content-newline]: ./singleline-html-element-content-newline.md
[vue/slot-name-casing]: ./slot-name-casing.md
[vue/sort-keys]: ./sort-keys.md
[vue/space-in-parens]: ./space-in-parens.md
[vue/space-infix-ops]: ./space-infix-ops.md
[vue/space-unary-ops]: ./space-unary-ops.md
[vue/static-class-names-order]: ./static-class-names-order.md
[vue/template-curly-spacing]: ./template-curly-spacing.md
[vue/this-in-template]: ./this-in-template.md
[vue/use-v-on-exact]: ./use-v-on-exact.md
[vue/v-bind-style]: ./v-bind-style.md
[vue/v-for-delimiter-style]: ./v-for-delimiter-style.md
[vue/v-if-else-key]: ./v-if-else-key.md
[vue/v-on-event-hyphenation]: ./v-on-event-hyphenation.md
[vue/v-on-function-call]: ./v-on-function-call.md
[vue/v-on-handler-style]: ./v-on-handler-style.md
[vue/v-on-style]: ./v-on-style.md
[vue/v-slot-style]: ./v-slot-style.md
[vue/valid-attribute-name]: ./valid-attribute-name.md
[vue/valid-define-emits]: ./valid-define-emits.md
[vue/valid-define-options]: ./valid-define-options.md
[vue/valid-define-props]: ./valid-define-props.md
[vue/valid-model-definition]: ./valid-model-definition.md
[vue/valid-next-tick]: ./valid-next-tick.md
[vue/valid-template-root]: ./valid-template-root.md
[vue/valid-v-bind-sync]: ./valid-v-bind-sync.md
[vue/valid-v-bind]: ./valid-v-bind.md
[vue/valid-v-cloak]: ./valid-v-cloak.md
[vue/valid-v-else-if]: ./valid-v-else-if.md
[vue/valid-v-else]: ./valid-v-else.md
[vue/valid-v-for]: ./valid-v-for.md
[vue/valid-v-html]: ./valid-v-html.md
[vue/valid-v-if]: ./valid-v-if.md
[vue/valid-v-is]: ./valid-v-is.md
[vue/valid-v-memo]: ./valid-v-memo.md
[vue/valid-v-model]: ./valid-v-model.md
[vue/valid-v-on]: ./valid-v-on.md
[vue/valid-v-once]: ./valid-v-once.md
[vue/valid-v-pre]: ./valid-v-pre.md
[vue/valid-v-show]: ./valid-v-show.md
[vue/valid-v-slot]: ./valid-v-slot.md
[vue/valid-v-text]: ./valid-v-text.md

<!-- link definitions for removed rules -->

[vue/experimental-script-setup-vars]: ./experimental-script-setup-vars.md
[vue/name-property-casing]: ./name-property-casing.md
[vue/no-confusing-v-for-v-if]: ./no-confusing-v-for-v-if.md
[vue/no-unregistered-components]: ./no-unregistered-components.md

<!-- link definitions for releases -->

[v5.0.0]: https://github.com/vuejs/eslint-plugin-vue/releases/tag/v5.0.0
[v7.0.0]: https://github.com/vuejs/eslint-plugin-vue/releases/tag/v7.0.0
[v7.13.0]: https://github.com/vuejs/eslint-plugin-vue/releases/tag/v7.13.0
[v8.4.0]: https://github.com/vuejs/eslint-plugin-vue/releases/tag/v8.4.0
[v9.0.0]: https://github.com/vuejs/eslint-plugin-vue/releases/tag/v9.0.0
