---
pageClass: rule-details
sidebarDepth: 0
title: vue/eqeqeq
description: Require the use of `===` and `!==` in `<template>`
since: v5.2.0
---

# vue/eqeqeq

> Require the use of `===` and `!==` in `<template>`

- :wrench: The `--fix` option on the [command line](https://eslint.org/docs/user-guide/command-line-interface#fix-problems) can automatically fix some of the problems reported by this rule.

This rule is the same rule as core [eqeqeq] rule but it applies to the expressions in `<template>`.

## :books: Further Reading

- [eqeqeq]

[eqeqeq]: https://eslint.org/docs/rules/eqeqeq

## :rocket: Version

This rule was introduced in eslint-plugin-vue v5.2.0

## :mag: Implementation

- [Rule source](https://github.com/vuejs/eslint-plugin-vue/blob/master/lib/rules/eqeqeq.js)
- [Test source](https://github.com/vuejs/eslint-plugin-vue/blob/master/tests/lib/rules/eqeqeq.js)

<sup>Taken with ❤️ [from ESLint core](https://eslint.org/docs/latest/rules/eqeqeq)</sup>
