---
pageClass: rule-details
sidebarDepth: 0
title: vue/dot-notation
description: Enforce dot notation whenever possible in `<template>`
since: v7.0.0
---

# vue/dot-notation

> Enforce dot notation whenever possible in `<template>`

- :wrench: The `--fix` option on the [command line](https://eslint.org/docs/user-guide/command-line-interface#fix-problems) can automatically fix some of the problems reported by this rule.

This rule is the same rule as core [dot-notation] rule but it applies to the expressions in `<template>`.

## :books: Further Reading

- [dot-notation]

[dot-notation]: https://eslint.org/docs/rules/dot-notation

## :rocket: Version

This rule was introduced in eslint-plugin-vue v7.0.0

## :mag: Implementation

- [Rule source](https://github.com/vuejs/eslint-plugin-vue/blob/master/lib/rules/dot-notation.js)
- [Test source](https://github.com/vuejs/eslint-plugin-vue/blob/master/tests/lib/rules/dot-notation.js)

<sup>Taken with ❤️ [from ESLint core](https://eslint.org/docs/latest/rules/dot-notation)</sup>
