//
//  AcknowLocalizationTests.swift
//  AcknowExample
//
//  Created by Vincent Tourraine on 1/05/16.
//  Copyright © 2015-2024 Vincent Tourraine. All rights reserved.
//

import XCTest

@testable import AcknowList

class AcknowLocalizationTests: XCTestCase {

    func testLocalizedStringReturnsDefault() {
        XCTAssertEqual("Default", AcknowLocalization.localizedString(forKey: "###UNKNOWN###", defaultString: "Default"))
    }

    func testLocalizedStringReturnsEnglish() {
        XCTAssertEqual("Acknowledgements", AcknowLocalization.localizedString(forKey: "VTAckAcknowledgements", defaultString: ""))
        XCTAssertEqual("Generated by CocoaPods", AcknowLocalization.localizedString(forKey: "VTAckGeneratedByCocoaPods", defaultString: ""))
    }
}
