# Contributor's Agreement
This code is licensed under the MPL 2.0 [LICENSE](LICENSE).

# Contributing
When contributing to the WatchMe Python Client, it is important to properly communicate the
gist of the contribution. If it is a simple code or editorial fix, simply
explaining this within the GitHub Pull Request (PR) will suffice. But if this
is a larger fix or Enhancement, it should be first discussed with the project
leader or developers. Please also note that we have a [CODE_OF_CONDUCT](CODE_OF_CONDUCT.md)
that should be followed for all interactions with the project members and users.

## Pull Request Process

1. Send PRs to the master branch for merge as a pypi release, or development
   if the intention is to add to next pypi release.
2. Follow the existing code style precedent. This does not need to be strictly
   defined as there are many thousands of lines of examples. Note the lack
   of tabs anywhere in the project, parentheses and spacing, documentation
   style, source code layout, variable scoping, and follow the project's
   standards.
3. Test your PR locally, and provide the steps necessary to test for the
   reviewers.
4. The project's default copyright and header have been included in any new
   source files.
5. All (major) changes to SIF Python Client must be documented in
   [docs](docs). If your PR changes a core functionality, please 
   include clear description of the changes in your PR so that the docs 
   can be updated, or better, submit another PR to update the docs directly.
6. If necessary, update the README.md.
7. The pull request will be reviewed by others, and the final merge must be
   done by the project lead, @vsoch (or approved by her).


When you contribute to the project, you agree to add code under the provided
licensing terms, and also we ask that you add your name to the [AUTHORS](AUTHORS.md)
file. Any contribution in the way of documentation, features, or bug fixes is
greatly appreciated.
