import axios from 'axios'
import { MessageBox, Message, Loading } from 'element-ui'
import store from '@/store'
import { getToken } from '@/utils/auth'

// create an axios instance
const service = axios.create({
  // baseURL: process.env.VUE_APP_BASE_API, // url = base url + request url
  baseURL: process.env.VUE_APP_BASE_HREF + process.env.VUE_APP_BASE_API,
  // withCredentials: true, // send cookies when cross-domain requests
  timeout: 20000 // request timeout
})
let loading = null
// request interceptor
service.interceptors.request.use(
  config => {
    // do something before request is sent
    loading = Loading.service({
      text: '正在加载中......',
      fullscreen: true
    })
    if (getToken()) {
      // let each request carry token
      // ['X-Token'] is a custom headers key
      // please modify it according to the actual situation
      config.headers['Authorization'] = 'Bearer ' + getToken()
    }
    return config
  },
  error => {
    // do something with request error
    console.log(error) // for debug
    return Promise.reject(error)
  }
)

// response interceptor
service.interceptors.response.use(
  /**
   * If you want to get http information such as headers or status
   * Please return  response => response
   */

  /**
   * Determine the request status by custom code
   * Here is just an example
   * You can also judge the status by HTTP Status Code
   */
  response => {
    const res = response.data
    let token = response.headers.authorization
    if (loading) loading.close()
    if (token) {
      // axios.defaults.headers.common['Authorization'] = token
      if (token.slice(0, 6) === 'Bearer' || token.slice(0, 6) === 'bearer') {
        token = token.slice(7)
      }
      store.dispatch('user/refreshToken', token)
    }
    // if the custom code is not 20000, it is judged as an error.
    if (res.code !== 200) {
      // 401: Illegal token; 402: Token expired; 403: Other clients logged in;
      Message({
        message: res.msg || 'Error',
        type: 'error',
        duration: 5 * 1000
      })
      return Promise.reject(new Error(res.msg || 'Error'))
    } else {
      return res
    }
  },
  error => {
    if (loading) loading.close()
    if (error.response) {
      if (error.response.data.code === 401 || error.response.data.code === 402) {
        MessageBox.confirm('登录状态已过期，您可以继续留在该页面，或者重新登录', '系统提示', {
          confirmButtonText: '重新登陆',
          cancelButtonText: '取消',
          type: 'warning'
        }).then(() => {
          store.dispatch('user/resetToken').then(() => {
            location.reload()
          })
        }).catch(() => {})
      } else {
        Message({
          message: error.response.data.msg,
          type: 'error',
          duration: 5 * 1000
        })
      }
    } else {
      Message({
        message: '网络开小差了!',
        type: 'error',
        duration: 3 * 1000
      })
    }
    return Promise.reject(error)
  }
)

export default service
