# From v1 to v2

Version 2 added exception rendering as the main feature, which required some API changes. Here is how you should upgrade your code to be compatible with version 2:

- If you have custom `RequestComponentSelector` implementations:
    - Rename `get_component_id()` methods to `get_component()` and add the new `error: Exception | None` argument to the methods.
    - Well-behaved `RequestComponentSelector`s that dont's support error rendering should reraise the received error if it's not `None` (although not doing so will not break anything as result and errors are clearly separated in `Jinja` and the core decorators don't rely on this protocol).
- If you've overridden any of the protected methods of `Jinja`, please go through this PR so you can upgrade your custom implementation.
- If you've written a custom integration, just add the required generic type to ComponentSelector type hints.
