// This file is auto-generated by @hey-api/openapi-ts

import type { CancelablePromise } from './core/CancelablePromise';
import { OpenAPI } from './core/OpenAPI';
import { request as __request } from './core/request';
import type { AiListAssistantsResponse, AiGetAssistantData, AiGetAssistantResponse, AiListThreadsData, AiListThreadsResponse, AiCreateThreadData, AiCreateThreadResponse, AiGetThreadData, AiGetThreadResponse, AiUpdateThreadData, AiUpdateThreadResponse, AiDeleteThreadData, AiDeleteThreadResponse, AiListThreadMessagesData, AiListThreadMessagesResponse, AiCreateThreadMessageData, AiCreateThreadMessageResponse, AiDeleteThreadMessageData, AiDeleteThreadMessageResponse } from './types.gen';

/**
 * List Assistants
 * @returns Assistant OK
 * @throws ApiError
 */
export const aiListAssistants = (): CancelablePromise<AiListAssistantsResponse> => { return __request(OpenAPI, {
    method: 'GET',
    url: '/assistants/'
}); };

/**
 * Get Assistant
 * @param data The data for the request.
 * @param data.assistantId
 * @returns Assistant OK
 * @throws ApiError
 */
export const aiGetAssistant = (data: AiGetAssistantData): CancelablePromise<AiGetAssistantResponse> => { return __request(OpenAPI, {
    method: 'GET',
    url: '/assistants/{assistant_id}/',
    path: {
        assistant_id: data.assistantId
    }
}); };

/**
 * List Threads
 * @param data The data for the request.
 * @param data.assistantId
 * @returns Thread OK
 * @throws ApiError
 */
export const aiListThreads = (data: AiListThreadsData = {}): CancelablePromise<AiListThreadsResponse> => { return __request(OpenAPI, {
    method: 'GET',
    url: '/threads/',
    query: {
        assistant_id: data.assistantId
    }
}); };

/**
 * Create Thread
 * @param data The data for the request.
 * @param data.requestBody
 * @returns Thread OK
 * @throws ApiError
 */
export const aiCreateThread = (data: AiCreateThreadData): CancelablePromise<AiCreateThreadResponse> => { return __request(OpenAPI, {
    method: 'POST',
    url: '/threads/',
    body: data.requestBody,
    mediaType: 'application/json'
}); };

/**
 * Get Thread
 * @param data The data for the request.
 * @param data.threadId
 * @returns Thread OK
 * @throws ApiError
 */
export const aiGetThread = (data: AiGetThreadData): CancelablePromise<AiGetThreadResponse> => { return __request(OpenAPI, {
    method: 'GET',
    url: '/threads/{thread_id}/',
    path: {
        thread_id: data.threadId
    }
}); };

/**
 * Update Thread
 * @param data The data for the request.
 * @param data.threadId
 * @param data.requestBody
 * @returns Thread OK
 * @throws ApiError
 */
export const aiUpdateThread = (data: AiUpdateThreadData): CancelablePromise<AiUpdateThreadResponse> => { return __request(OpenAPI, {
    method: 'PATCH',
    url: '/threads/{thread_id}/',
    path: {
        thread_id: data.threadId
    },
    body: data.requestBody,
    mediaType: 'application/json'
}); };

/**
 * Delete Thread
 * @param data The data for the request.
 * @param data.threadId
 * @returns void No Content
 * @throws ApiError
 */
export const aiDeleteThread = (data: AiDeleteThreadData): CancelablePromise<AiDeleteThreadResponse> => { return __request(OpenAPI, {
    method: 'DELETE',
    url: '/threads/{thread_id}/',
    path: {
        thread_id: data.threadId
    }
}); };

/**
 * List Thread Messages
 * @param data The data for the request.
 * @param data.threadId
 * @returns ThreadMessage OK
 * @throws ApiError
 */
export const aiListThreadMessages = (data: AiListThreadMessagesData): CancelablePromise<AiListThreadMessagesResponse> => { return __request(OpenAPI, {
    method: 'GET',
    url: '/threads/{thread_id}/messages/',
    path: {
        thread_id: data.threadId
    }
}); };

/**
 * Create Thread Message
 * @param data The data for the request.
 * @param data.threadId
 * @param data.requestBody
 * @returns unknown Created
 * @throws ApiError
 */
export const aiCreateThreadMessage = (data: AiCreateThreadMessageData): CancelablePromise<AiCreateThreadMessageResponse> => { return __request(OpenAPI, {
    method: 'POST',
    url: '/threads/{thread_id}/messages/',
    path: {
        thread_id: data.threadId
    },
    body: data.requestBody,
    mediaType: 'application/json'
}); };

/**
 * Delete Thread Message
 * @param data The data for the request.
 * @param data.threadId
 * @param data.messageId
 * @returns void No Content
 * @throws ApiError
 */
export const aiDeleteThreadMessage = (data: AiDeleteThreadMessageData): CancelablePromise<AiDeleteThreadMessageResponse> => { return __request(OpenAPI, {
    method: 'DELETE',
    url: '/threads/{thread_id}/messages/{message_id}/',
    path: {
        thread_id: data.threadId,
        message_id: data.messageId
    }
}); };