# Generated by Django 5.0.6 on 2024-06-06 20:54

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="MovieBacklogItem",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("movie_name", models.CharField(max_length=255)),
                ("imdb_url", models.URLField()),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="recommended_movies",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "Movie Backlog Item",
                "verbose_name_plural": "Movie Backlog Items",
                "ordering": ("user", "-created_at"),
                "indexes": [
                    models.Index(
                        models.OrderBy(models.F("created_at"), descending=True),
                        name="movie_item_created_at_desc",
                    )
                ],
            },
        ),
    ]
