
# iOS Universal Links
This is a tutorial of how to add a new Universal Link to your Delphi Firemonkey iOS app, to open your app by a link. In this tutorial we will add the Universal Link: https://yoursite.com/app/

##### Why Universal Links and not Custom Schemes?
For two reasons:
1) Because the custom scheme is not unique, if you configure the Custom Scheme ```yourapp://```, nothing will prevent other developers from configuring this same Custom Scheme to open their application and not yours. Universal Link is unique, it will only be linked to your App, and it cannot be linked to the third party app.
2) Universal Link and Custom Schemes works only for installed applications. Even with Universal Link, you can send the link to a user that if he doesn't have your app installed, the link won't open your app, much like the AppStore, but it will open your website's page, just like any link does . But we can make a redirect to the AppStore so that the user installs the app (I will also teach this throughout this tutorial), that is, when you send a Universal Link to someone and they click, if they have your app installed, yours app will open, but if it doesn't have your app installed, it will open the AppStore. This is impossible to do with Custom Schemes.

### 1) Configure your app to register approved domains
1) Enter in your apple developer account at [developer.apple.com](https://developer.apple.com/).
2) Enable **Associated Domains** on your app identifier.
3) Generate a new provision profile, and set it in the XCode.

### 2) Editing the file "Entitlement.TemplateiOS.xml"
You will find this file in your project folder. Unfortunately, I don't know a correct way to edit this model file, due to some limitations of Delphi itself. The only way that worked for me was to take the final entitlement file generated by compiling your iOS program and editing it. (I'm open to suggestions that work)
1) Save one copy of the file ```<your_project_folder>\Entitlement.TemplateiOS.xml``` for backup.
2) Compile for iOS.
3) Go to the iOS ouput directory of your project. Usually ```<your_project_folder>\iOSDevice64\Release\```
4) Open in the NotePad the file ```<your_app>.entitlements``` and copy the content.
5) Go back to the project directory, and open in the NotePad the file ```<your_project_folder>\Entitlement.TemplateiOS.xml```, delete all content and paste the new content.
6) Search for the lines

    	<key>com.apple.developer.associated-domains</key>
    	<string>*</string>

7) Replace with these new lines:

    	<key>com.apple.developer.associated-domains</key>
    	<array>
    		<string>applinks:yoursite.com</string>
    	</array>

   Remarks: Replace the ```yoursite.com``` with your domain. Although your Universal Link is for example https://yoursite.com/app or https://yoursite.com/teste/ios, you must only put the domain, as this is where we will put our ```.well-known/apple-app-site-association``` becoming accessible at this URL "https://yoursite.com/.well-known/apple-app-site-association"  (I'll explain more about this file in the next step)

8) Save the new content of the file ```<your_project_folder>\Entitlement.TemplateiOS.xml```.

### 3) Creating the file ".well-known/apple-app-site-association" in your website
Now you must create the file that will be on your website to confirm that you are the owner of the app and inform which URLs are linked to your app. You can link multiple Universal Links to your app, and also Universal Links from multiple apps, as I can have multiple apps and a single domain, and everything is done just in that file. But to be more simplistic, I'll explain how to add just one link to just one app.

1) Open again in the NotePad the file ```<your_project_folder>\Entitlement.TemplateiOS.xml```, find the line ```<key>application-identifier</key>```. Below it will have your appID, it will be something like ```A51GDSSDSJ.com.yourapp```. So, copy your appID.
2) Open the NotePad, paste the following content:

       {
        	"applinks": {
        		"apps": [],
        		"details": [
        			{
        				"appID": "A51GDSSDSJ.com.yourapp",
        				"paths": [ "/app/" ]
        			}
        		]
        	}
       }

   Replace the ```A51GDSSDSJ.com.yourapp``` with your appID that we copied in the last step, and replace the ```/app/``` by the path you want. I used the path ```/app/``` because I want my Universal Link to be "https://yoursite.com/app/". You will be able to use wildcards on your Universal Link, which is mainly used when we want Universal Link to not only open our app, but also open it by passing some type of information. For example, if I put the path ```/app/*```, I could send to the user the link "https://yoursite.com/app/sale_form", then my app could analyze the link that was used to open it and then open it with the sale form open, for example.
3) Save the content, which we edited in NotePad in the previous step, on your computer with the file name ```apple-app-site-association```. Note: This file has no extension.
4) On your website host, in the root directory create a folder called ```.well-known``` and place the file we created in the previous step in this folder, so that the file is accessible via the url "https://yoursite.com/.well-known/apple-app-site-association".
5) This file, ```apple-app-site-association```, must be configured on your web server as ```application/json``` MIME type. As I use the IIS web server, and for those who use it, just create a file called ```web.config``` with the following content:

       <?xml version="1.0" encoding="UTF-8"?>
       <configuration>
           <system.webServer>
               <staticContent>
                   <mimeMap fileExtension="." mimeType="application/json" />
                   <mimeMap fileExtension=".json" mimeType="application/json" />
               </staticContent>
           </system.webServer>
       </configuration>

   Save this file in the same folder of your ```apple-app-site-association``` file.
6) Test the URL "https://yoursite.com/.well-known/apple-app-site-association" in your browser. If you were unable to access, you have missed one of the previous steps.

### 4) Testing
1) First, you should unistall your app, since iOS only checks and saves the Universal Links for each application at the installation (I don't know if when updating an app iOS will also do this verification, you will have to test this).
It works as follows: On installation, iOS will check the key value ```com.apple.developer.associated-domains``` that is on your ```<your_app>.entitlements``` file, which is our domain, and then iOS will try to access the Apple file from our domain "https://yoursite.com/.well-known/apple-app-site-association". The iOS will then try to find the paths (our Universal Links) by the appID and then save internally on the system, and will be saved until the user uninstalls the app.
2) Send the link on WhatsApp, GMail, by SMS or any other application and click on the link. If the iOS opened your app directly, it worked. If the iOS opened Safari or any other browser, it didn't work and you missed a previous step.

### 5) Opening the AppStore when the user don't have the app installed

As I explained at the beginning, Universal Links only works for applications already installed. That is, when the user who does not have the app installed clicks on the link, it will open the page of your website in the browser, the URL that is linked, like any link. Then we will make a code to redirect from our website to the AppStore on the page of our app. Following the following steps:
1) There are several ways to redirect, but I will do it here using a simple php code:

       <?php
       	if (strpos($_SERVER['HTTP_USER_AGENT'],"iPod") || strpos($_SERVER['HTTP_USER_AGENT'],"iPhone") ||  strpos($_SERVER['HTTP_USER_AGENT'],"iPad")) {
       		header("Location: https://itunes.apple.com/app/id00000000", true, 301);
       	} else if (strpos($_SERVER['HTTP_USER_AGENT'],"Android")){
       		header("Location: market://details?id=com.yourapp", true, 301);
       	} else {
       		header("Location: https://yoursite.com", true, 301);
       	}
       ?>

   If your app is already on the AppStore, put its id in place of ```id00000000```. In this code I put a android redirection, this is because you can set the same link in your app in ios and android. Save this file with the name ```index.php``` and put it in the folder of your universal link on the host, to stay like this "https://yoursite.com/app/index.php".
2) I particularly use wildcard on my Universal Links, so I have to make the above php code run on any subpath, for example "https://yoursite.com/app/lahahaghgdhgsdhgfdhaasdf". For that, we have to configure a Friendly URL on our web server. How I use the IIS web server, and for those who use it, just create a file called ```web.config``` with the following content:

       <?xml version="1.0" encoding="UTF-8"?>
       <configuration>
           <system.webServer>
               <security>
                   <requestFiltering allowDoubleEscaping="True" />
               </security>
               <rewrite>
                   <rules>
                       <rule name="1RewriteUserFriendlyURL1" stopProcessing="true">
                           <match url="^app/+.*" />
                           <conditions>
                           </conditions>
                           <action type="Rewrite" url="app/index.php" />
                       </rule>
                       <rule name="1RewriteUserFriendlyURL3" stopProcessing="false">
                           <match url="\+" />
                           <conditions>
                               <add input="{REQUEST_FILENAME}" matchType="IsFile" negate="true" />
                               <add input="{REQUEST_FILENAME}" matchType="IsDirectory" negate="true" />
                           </conditions>
                           <action type="Rewrite" url="{UrlDecode:{REQUEST_URI}}" />
                       </rule>
                   </rules>
               </rewrite>
           </system.webServer>
       </configuration>

   Save this file in the root path of your website.

### 6) Recommendation: Set the Android App Links too
Although this tutorial is only for setting up Universal Links for your app on iOS, you should do the same for Android, which works in much the same way, but under another name: Android App Links. You can (should) configure Android App Links with the same Universal Link as iOS, so you can send the same link to your users, which will work to open your app on both Android and iOS. It will work identically.

### 7) Identify the URL that opened your app
If you use more than 1 Universal Link, or your Universal Link has a wildcard, you will probably want to know which link opened your app. As this task is a little more complex to be done with Delphi, I made a tutorial just for that which works for Universal Links and Custom Schemes: https://github.com/viniciusfbb/fmx_tutorials/tree/master/delphi_ios_handle_incoming_url/README.md

### 8) Utilities
The sky is the limit, so there are endless uses, but I will highlight special one: QRCode. For example, if your app is for customers of restaurants, you can print the QRCode containing your app's Universal Link, to paste in restaurants. Thus, when the user points the camera, he will open his app, if installed, or open the AppStore to install his app.